/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.wizard;

import com.sap.ide.eclipse.component.core.DCController;
import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.dcmdcommons.resources.MessageUtil;
import com.sap.ide.eclipse.component.provider.ui.message.ComponentProviderMessages;
import com.sap.ide.eclipse.component.wizard.IWizardValidator;
import com.sap.ide.eclipse.component.wizard.ProjectWizard;
import com.sap.ide.eclipse.component.wizard.SelectActivityPage;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DCDefinitionPage
extends WizardPage
implements DCController.ChangeListener {
    private boolean changeFlag = false;
    private boolean hasNextPage = false;
    private MessageUtil theMessageUtil;
    private String staticLocal = null;
    private TracerI theTracer = TracingManager.getTracer(this.getClass());
    private Map prefixMap = new HashMap();

    public DCDefinitionPage() {
        super("devComponentWizardPage");
        this.setTitle(ComponentProviderMessages.getString("titleDevComponentPage"));
        this.setDescription(ComponentProviderMessages.getString("descDevComponentPage"));
        this.theMessageUtil = MessageUtil.getInstance("com.sap.ide.eclipse.component.dcmdcommons.resources.messages");
    }

    public void createControl(Composite parent) {
        String parentName;
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        this.buildVendor(container);
        this.buildComponentName(container);
        this.buildCaption(container);
        this.buildLanguages(container);
        this.buildDomains(container);
        this.buildLocalCheckBox(container);
        this.buildSyncUsedCheckBox(container);
        this.buildType(container);
        this.setControl((Control)container);
        Rectangle bounds = this.getShell().getBounds();
        bounds.width = 500;
        bounds.height = 500;
        this.getShell().setBounds(bounds);
        this.getDCController().getUIAgent().getNameControl().setFocus();
        DCController controller = this.getDCController();
        if (controller != null && (parentName = controller.getParentDCName()) != null) {
            this.setDescription(ComponentProviderMessages.format("descChildDevComponentPage", new Object[]{parentName, controller.getParentDCVendor()}));
        }
        this.changeFlag = false;
        this.setErrorMessage(null);
    }

    private void buildCaption(Composite container) {
        new Label(container, 0).setText(ComponentProviderMessages.getString("caption"));
        Text caption = this.getDCController().getUIAgent().createCaptionControl(container, 2048);
        GridData gd = new GridData(768);
        caption.setLayoutData((Object)gd);
        new Label(container, 0);
    }

    private void buildType(Composite container) {
        new Label(container, 0).setText(ComponentProviderMessages.getString("type"));
        GridData gd = new GridData(1808);
        gd.verticalSpan = 5;
        TreeViewer typeTree = this.getDCController().getUIAgent().createDCTypeControl(container, 2048);
        typeTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DCDefinitionPage.this.dialogChanged();
            }
        });
        typeTree.getControl().setLayoutData((Object)gd);
        new Label(container, 0);
    }

    private void buildLocalCheckBox(Composite container) {
        new Label(container, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        Button createLocalDC = this.getDCController().getUIAgent().createForLocalControl(container, 0);
        createLocalDC.setText(ComponentProviderMessages.getString("createLocalDC"));
        createLocalDC.setLayoutData((Object)gd);
        createLocalDC.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DCDefinitionPage.this.dialogChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void buildSyncUsedCheckBox(Composite container) {
        new Label(container, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        Button syncUsedDCs = this.getDCController().getUIAgent().createSyncUsedControl(container, 0);
        syncUsedDCs.setText(ComponentProviderMessages.getString("syncUsedDCs.label"));
        if (syncUsedDCs.isEnabled()) {
            syncUsedDCs.setSelection(true);
        }
        syncUsedDCs.setLayoutData((Object)gd);
    }

    private void buildVendor(Composite container) {
        new Label(container, 0).setText(ComponentProviderMessages.getString("vendor"));
        Composite composite = this.getDCController().getUIAgent().createVendorControl(container, 2048);
        composite.setLayoutData((Object)new GridData(768));
        this.getDCController().getUIAgent().getVendorTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DCDefinitionPage.this.dialogChanged();
            }
        });
        new Label(container, 0);
    }

    private void buildLanguages(Composite container) {
        new Label(container, 0).setText(ComponentProviderMessages.getString("languages"));
        this.getDCController().getUIAgent().createLanguageControl(container, 2048);
        new Label(container, 0);
    }

    private void buildDomains(Composite container) {
        new Label(container, 0).setText("Domain:");
        this.getDCController().getUIAgent().createDomainControl(container, 2048);
        new Label(container, 0);
    }

    private void buildComponentName(Composite container) {
        new Label(container, 0).setText(ComponentProviderMessages.getString("componentName"));
        this.getDCController().getUIAgent().createDCNameControl(container, 2048);
        this.getDCController().getUIAgent().getNameControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DCDefinitionPage.this.dialogChanged();
            }
        });
        this.getDCController().getUIAgent().getPrefixControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DCDefinitionPage.this.dialogChanged();
            }
        });
        new Label(container, 0);
    }

    private DCController getDCController() {
        ProjectWizard projectWizard = this.getProjectWizard();
        return projectWizard.getDCController();
    }

    private void dialogChanged() {
        IStatus status = this.getDCController().validate();
        if (status.getSeverity() == 4) {
            this.updateStatus(status.getMessage());
        } else {
            this.updateStatus(null);
            if (status.getSeverity() == 2) {
                this.setMessage(status.getMessage(), 2);
            }
        }
    }

    public void updateStatus(String message) {
        this.setMessage(this.getDescription());
        if (this.changeFlag) {
            this.setErrorMessage(message);
        } else if (this.isCurrentPage()) {
            this.changeFlag = true;
        }
        this.setPageComplete(message == null);
    }

    public boolean isPageComplete() {
        if (!super.isPageComplete()) {
            return false;
        }
        if (this.isCurrentPage()) {
            try {
                this.hasNextPage = this.createConnectedWizard();
            }
            catch (CoreException e) {
                Util.logExceptionMessage(this.theTracer, 2, "DC typed Wizard coudn't be initialized", e);
                this.updateStatus(ComponentProviderMessages.getString("noWizardForDCType.error") + (e.getMessage() != null ? "\n" + e.getMessage() : ""));
                return false;
            }
            if (!this.hasNextPage) {
                boolean bl = this.hasNextPage = this.getFollowingPage(this.getProjectWizard()) != null;
            }
            if (this.hasNextPage) {
                return false;
            }
        } else if (this.getContainer().getCurrentPage().getName().equals("SelectSCPage")) {
            return false;
        }
        return super.isPageComplete();
    }

    public boolean canFlipToNextPage() {
        return super.isPageComplete() && this.hasNextPage;
    }

    private boolean createConnectedWizard() throws CoreException {
        ProjectWizard wizard = this.getProjectWizard();
        if (wizard != null) {
            wizard.reset();
            wizard.createConnectedWizard();
        }
        wizard.initializeConnectedWizard();
        return wizard.getAddtionalStartingPage() != null;
    }

    public IWizardPage getNextPage() {
        final ProjectWizard wizard = this.getProjectWizard();
        if (wizard != null) {
            final IStatus[] status = new IStatus[1];
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                public void run() {
                    IStatus finalStatus = wizard.getDCController().validateDCName();
                    if (finalStatus.getSeverity() != 4) {
                        Iterator it = wizard.getValidatorList().iterator();
                        while (it.hasNext() && !finalStatus.matches(4)) {
                            IWizardValidator validator = (IWizardValidator)it.next();
                            IStatus state = validator.validate();
                            if (state == null || state.isOK()) continue;
                            finalStatus = state;
                        }
                    }
                    status[0] = finalStatus;
                }
            });
            if (4 == status[0].getSeverity()) {
                this.updateStatus(status[0].getMessage());
                return null;
            }
            return this.getFollowingPage(wizard);
        }
        return super.getNextPage();
    }

    private IWizardPage getFollowingPage(ProjectWizard wizard) {
        if (wizard == null) {
            return null;
        }
        if (wizard.getDCController().isForLocalDevelopment()) {
            return wizard.getAddtionalStartingPage();
        }
        IWizardPage page = super.getNextPage();
        if (page instanceof SelectActivityPage && !((SelectActivityPage)page).isVisiable()) {
            return wizard.getAddtionalStartingPage();
        }
        return page;
    }

    private ProjectWizard getProjectWizard() {
        if (this.getWizard() != null && this.getWizard() instanceof ProjectWizard) {
            return (ProjectWizard)this.getWizard();
        }
        return null;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.dialogChanged();
        }
        super.setVisible(visible);
    }

    public void update(DCController controller) {
        IStatus status;
        if (controller == null) {
            return;
        }
        if (this.changeFlag && !(status = controller.validate()).isOK()) {
            this.updateStatus(status.getMessage());
        }
    }
}

