/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.wizard;

import com.sap.ide.eclipse.component.provider.ui.message.ComponentProviderMessages;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.DevelopmentConfiguration;
import com.sap.tc.complib.Repository;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BuildVariantPage
extends WizardPage {
    private Composite parent = null;
    private Map bufferMap = null;

    public BuildVariantPage() {
        super("buildVariantPage");
        this.setTitle(ComponentProviderMessages.getString("buildVariantPage.title"));
        this.setDescription(ComponentProviderMessages.getString("buildVariantPage.description"));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.createComposite(parent);
    }

    protected Composite createComposite(Composite parent) {
        return this.createComposite(parent, null);
    }

    protected Composite createComposite(Composite parent, DevelopmentConfiguration config) {
        if (this.parent != null) {
            this.parent.getParent().dispose();
        }
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        Composite c = new Composite((Composite)sc, 0);
        sc.setContent((Control)c);
        GridLayout layout = new GridLayout();
        c.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 20;
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        this.createInfoPart(c, config).setLayoutData((Object)data);
        this.parent = c;
        this.setControl((Control)sc);
        return this.parent;
    }

    private Composite createInfoPart(Composite parentFirst, DevelopmentConfiguration config) {
        Group parent = new Group(parentFirst, 16384);
        parent.setText("Development Configuration Details");
        GridLayout layout = new GridLayout(2, false);
        parent.setLayout((Layout)layout);
        Label name = new Label((Composite)parent, 0);
        name.setText("Name:");
        Text nameValue = new Text((Composite)parent, 8);
        Label caption = new Label((Composite)parent, 0);
        caption.setText("Caption:");
        Text captionValue = new Text((Composite)parent, 8);
        Label description = new Label((Composite)parent, 0);
        description.setText("Description:");
        Text descriptionValue = new Text((Composite)parent, 8);
        Label buildServer = new Label((Composite)parent, 0);
        buildServer.setText("Build Server:");
        Text buildServerValue = new Text((Composite)parent, 8);
        Label nameServer = new Label((Composite)parent, 0);
        nameServer.setText("Name Server:");
        Text nameServerValue = new Text((Composite)parent, 8);
        Label repositoryServer = new Label((Composite)parent, 0);
        repositoryServer.setText("Repository Server(s):");
        Text repositoryServerValue = new Text((Composite)parent, 8);
        if (config != null) {
            Iterator<Object> it;
            nameValue.setText(config.getName() != null ? config.getName() : "");
            captionValue.setText(config.getCaption() != null ? config.getCaption() : "");
            descriptionValue.setText(config.getDescription() != null ? config.getDescription() : "");
            nameServerValue.setText(config.getNameServer() != null ? config.getNameServer() : "");
            buildServerValue.setText(config.getBuildServer() != null ? config.getBuildServer() : "");
            String DTRServer = "";
            Map compartments = config.getCompartments();
            HashSet<String> nameSet = new HashSet<String>();
            if (compartments != null) {
                it = compartments.values().iterator();
                while (it.hasNext()) {
                    String url;
                    Compartment compartment = (Compartment)it.next();
                    if (compartment.getSourceState() == null) continue;
                    Repository repository = compartment.getSourceState().getRepository();
                    String string = url = repository != null ? repository.getURL() : null;
                    if (url == null) continue;
                    nameSet.add(url);
                }
            }
            it = nameSet.iterator();
            while (it.hasNext()) {
                String url = (String)it.next();
                DTRServer = DTRServer + url;
                if (!it.hasNext()) continue;
                DTRServer = DTRServer + '\n';
            }
            repositoryServerValue.setText(DTRServer);
        }
        return parent;
    }

    protected Map listCompartments(DevelopmentConfiguration config) {
        this.bufferMap = new HashMap();
        boolean editable = false;
        this.createComposite(this.parent.getParent().getParent(), config);
        if (config == null) {
            return this.bufferMap;
        }
        Collection nodes = config.getCompartments().values();
        if (nodes != null) {
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                Compartment node = (Compartment)it.next();
                Map map = node.getBuildVariants();
                Set keys = map.keySet();
                if (keys == null || keys.isEmpty()) continue;
                if (node.hasSourceState()) {
                    String compartment = this.getKey(node, this.parent);
                    if (keys.size() > 1) {
                        Combo combo = this.getCombo(keys, this.parent);
                        this.bufferMap.put(compartment, combo);
                        editable = true;
                        continue;
                    }
                    Label label = new Label(this.parent, 0);
                    String text = keys.iterator().next().toString();
                    label.setText(text);
                    this.bufferMap.put(node.getName(), text);
                    continue;
                }
                this.bufferMap.put(node.getName(), keys.iterator().next());
            }
        }
        if (this.bufferMap.isEmpty()) {
            new Label(this.parent, 0).setText(ComponentProviderMessages.getString("noCompartments.warning"));
        }
        if (!editable) {
            this.setDescription(ComponentProviderMessages.getString("buildVariantInfo.description"));
        }
        this.parent.setSize(this.parent.computeSize(-1, -1));
        this.parent.getParent().getParent().layout(true);
        return this.bufferMap;
    }

    protected String getKey(Compartment node, Composite parent) {
        String compartment = null;
        compartment = node.getName();
        String scName = node.getScName();
        if (scName == null) {
            scName = compartment;
        }
        Label label = new Label(parent, 0);
        label.setText(scName.concat(":"));
        return compartment;
    }

    protected Combo getCombo(Collection buildVariantData, Composite parent) {
        Combo buildvariants = null;
        if (buildVariantData != null && !buildVariantData.isEmpty()) {
            buildvariants = new Combo(parent, 12);
            Iterator it = buildVariantData.iterator();
            while (it.hasNext()) {
                buildvariants.add((String)it.next());
            }
            buildvariants.select(0);
        } else {
            new Label(parent, 0).setText("");
        }
        return buildvariants;
    }

    public Map getResults() {
        return this.bufferMap;
    }

    public boolean isPageComplete() {
        return this.isCurrentPage();
    }
}

