/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.ui.properties;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.dcmdcommons.resources.MessageUtil;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.component.provider.UpdateUtil;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.ide.eclipse.component.provider.ui.properties.ComponentPropertyReader;
import com.sap.ide.eclipse.dii.component.ProjectConsistencyManager;
import com.sap.ide.login.UserValidator;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.tssap.dii.component.DCUtil;
import com.tssap.dii.dtri.util.RepositoryObject;
import com.tssap.dii.dtri.util.RepositoryServiceException;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.extension.PropertySetProvider;
import com.tssap.selena.model.extension.filefolder.FileAndFolderManagement;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class PublicPartPropertyWriter
extends ComponentPropertyReader
implements PropertySetProvider {
    private TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$provider$ui$properties$PublicPartPropertyWriter == null ? (class$com$sap$ide$eclipse$component$provider$ui$properties$PublicPartPropertyWriter = PublicPartPropertyWriter.class$("com.sap.ide.eclipse.component.provider.ui.properties.PublicPartPropertyWriter")) : class$com$sap$ide$eclipse$component$provider$ui$properties$PublicPartPropertyWriter));
    private MessageUtil theMessageUtil = MessageUtil.getInstance("com.sap.ide.eclipse.component.dcmdcommons.resources.messages");
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$provider$ui$properties$PublicPartPropertyWriter;

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        IResource res = FileAndFolderManagement.getInstance().getResource((Element)element.getModel());
        if (res instanceof IProject && !DCUtil.isDCProject((IProject)((IProject)res))) {
            return false;
        }
        IDevelopmentComponentNode dcNode = ComponentUtil.getParentDCNode(element);
        if (dcNode == null || dcNode.isInstalledLocally()) {
            return false;
        }
        if (dcNode.isLocalOnlySource()) {
            return true;
        }
        if (UserValidator.isDefaultServerOnline()) {
            return dcNode.isSynchedAsSource();
        }
        return false;
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        String domain = element.getUniqueName().getDomain();
        String subDomain = element.getUniqueName().getSubDomain();
        if (domain == "com.sap.ide.eclipse.component.DCMetaData" && subDomain == "com.sap.ide.eclipse.component.DCMetaData.PPMetaData") {
            if (propertyName.equals("purpose")) {
                String aTrimValue = propertyValue.trim();
                String theTypeVendor = null;
                String theType = null;
                IDevelopmentComponentNode aDCNode = ComponentUtil.getParentDCNode(element);
                if (aDCNode != null) {
                    try {
                        DevelopmentComponent aDC = aDCNode.getDevelopmentComponent(false);
                        if (aDC != null) {
                            theTypeVendor = aDC.getComponentType().getVendor();
                            theType = aDC.getComponentType().getType();
                        }
                    }
                    catch (Exception e) {
                        Util.logException(this.theTracer, e);
                    }
                }
                if (theTypeVendor != null && theType != null && theTypeVendor.equals("sap.com") && (theType.equals("Build Infrastructure") || theType.equals("Build Plugin"))) {
                    boolean result = aTrimValue.equals(PublicPart.Purpose.INFRASTRUCTURE.toString());
                    return result;
                }
                boolean result = aTrimValue.equals(PublicPart.Purpose.ASSEMBLY.toString()) || aTrimValue.equals(PublicPart.Purpose.COMPILATION.toString());
                return result;
            }
            return true;
        }
        return false;
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        Object object = ObjectUtil.getComponentObject(element);
        if (!(object instanceof PublicPart)) {
            return;
        }
        PublicPart aPP = (PublicPart)object;
        IDevelopmentComponentNode dcNode = ComponentUtil.getParentDCNode(element);
        try {
            DevelopmentComponent aDC = dcNode.getDevelopmentComponent(true);
            aPP = (PublicPart)aDC.getPublicParts().get(aPP.getName());
        }
        catch (Exception e) {
            Util.logExceptionMessage(this.theTracer, 2, this.theMessageUtil.getString("Exception.Occured"), e);
        }
        if (dcNode == null) {
            return;
        }
        IProject aDCProject = DCProjectUtil.getProject(dcNode);
        if (aDCProject == null) {
            return;
        }
        IDevelopmentConfiguration aDevConf = null;
        if (propertyName.equals("purpose") && !Util.saveSensitiveEditors(aDevConf = ComponentUtil.getParentDevConf(element))) {
            return;
        }
        IFile thePPFile = (IFile)aDCProject.findMember("def/" + aPP.getName() + ".pp");
        if (thePPFile == null || !thePPFile.exists() || !thePPFile.isAccessible()) {
            Util.showUserOutputViewer();
            this.theTracer.userOut(3, this.theMessageUtil.getString("Warning.Target.PublicPart.NotAccessible"));
            return;
        }
        if (thePPFile.isReadOnly()) {
            try {
                RepositoryObject anObjectToEdit = new RepositoryObject("PublicPart", thePPFile.getName(), thePPFile.getProject());
                anObjectToEdit.addlResource((IResource)thePPFile);
                RepositoryObject.ResourceRepositoryStatus aStatus = anObjectToEdit.checkOut(false, null);
                if (!aStatus.status) {
                    Util.showUserOutputViewer();
                    this.theTracer.userOut(3, this.theMessageUtil.getString("Warning.Target.PublicPart.Could.Not.Be.Checked.Out"));
                    return;
                }
            }
            catch (RepositoryServiceException rse) {
                Util.showUserOutputViewer();
                this.theTracer.userOut(2, rse.getMessage());
                return;
            }
        }
        if (propertyName.equals("caption")) {
            aPP.setCaption(propertyValue);
        } else if (propertyName.equals("description")) {
            aPP.setDescription(propertyValue);
        } else {
            aPP.setPurpose(PublicPart.Purpose.valueOf((String)propertyValue));
        }
        try {
            IDCProxy aProxy = dcNode.getDCProxy();
            aProxy.serializePPDefinition(aPP.getName());
        }
        catch (Exception e) {
            Util.logExceptionMessage(this.theTracer, 2, this.theMessageUtil.getString("Exception.Occured"), e);
        }
        if (propertyName.equals("purpose")) {
            if (aDevConf != null) {
                ProjectConsistencyManager aManager = ProjectConsistencyManager.getInstance((IDevelopmentConfiguration)aDevConf);
                this.updateDCProjects(aManager);
            } else {
                Util.logExceptionMessage(this.theTracer, 3, this.theMessageUtil.getString("Warning.DevConf.Not.Updated"), null);
            }
        }
        UpdateUtil.updateElement(element, ModelDeltaNodeKind.CHANGED);
    }

    public Property addProperty(Element element, String string, String string1) {
        return null;
    }

    private void updateDCProjects(ProjectConsistencyManager aManager) {
        ProgressMonitorDialog aProgressMonitor = new ProgressMonitorDialog(ComponentProviderPlugin.getPlugin().getMyShell());
        try {
            aProgressMonitor.run(false, false, (IRunnableWithProgress)aManager);
        }
        catch (InvocationTargetException ite) {
            Util.logExceptionMessage(this.theTracer, 2, this.theMessageUtil.getString("Exception.Occured"), ite);
        }
        catch (InterruptedException ie) {
            Util.logExceptionMessage(this.theTracer, 2, this.theMessageUtil.getString("Exception.Occured"), ie);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

