/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.ui.properties;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.NamereservationUtil;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.ide.eclipse.component.provider.objects.PackageObject;
import com.sap.ide.eclipse.component.provider.ui.properties.AbstractPropertyReader;
import com.sap.ide.eclipse.component.wizard.ProjectWizard;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.ComponentReference;
import com.sap.tc.complib.ComponentType;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.DevelopmentConfiguration;
import com.sap.tc.complib.Entity;
import com.sap.tc.complib.EntityReference;
import com.sap.tc.complib.FileSet;
import com.sap.tc.complib.PPReference;
import com.sap.tc.complib.Property;
import com.sap.tc.complib.PropertyElement;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.complib.SourceState;
import com.sap.tc.devconf.ICompartmentNode;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.InvalidDefinitionException;
import com.sap.tc.devconf.RepositoryAccessException;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ComponentPropertyReader
extends AbstractPropertyReader {
    public static final String NAME_PROP = "name";
    public static final String CAPTION_PROP = "caption";
    public static final String DESCRIPTION_PROP = "description";
    public static final String VERSION_PROP = "version";
    public static final String BUILDSERVER_PROP = "buildServer";
    public static final String SLLOCATION_PROP = "slLocation";
    public static final String NAMESERVER_PROP = "nameServer";
    public static final String CMS_PROP = "cms";
    public static final String SC_PROP = "softComp";
    public static final String SCALIEASES_PROP = "scAliases";
    public static final String USESCOMPARTMENTS_PROP = "usesCompartments";
    public static final String MODIFICATION_PROP = "modificationAllowed";
    public static final String SOURCESTATE_PROP = "sourceState";
    public static final String REPOSITORY_PROP = "repositoryURL";
    public static final String SOURCELOCATION_PROP = "sourceLocation";
    public static final String SOURCEINACTIVELOCATION_PROP = "inactiveLocation";
    public static final String SOURCEEXPORT_PROP = "exportAllowed";
    public static final String SYNCSTATE_PROP = "syncState";
    public static final String VENDOR_PROP = "dcVendor";
    public static final String SYNCMODE_PROP = "syncMode";
    public static final String ROOTFOLDER_PROP = "dcRootFolder";
    public static final String DIRTY_PROP = "dirty";
    public static final String BROKEN_PROP = "broken";
    public static final String BUILDNO_PROP = "synchedBuildNumber";
    public static final String DC_TYPE_PROP = "dcType";
    public static final String DC_BUILDER_PROP = "dcBuilder";
    public static final String DC_LANGUAGE_PROP = "dcLanguage";
    public static final String DC_IS_EXTERNAL_PROP = "dcIsExternal";
    public static final String DC_IS_DELIVERED_PROP = "dcIsDelivered";
    public static final String DC_PARENT_DC_PROP = "dcParent";
    public static final String AT_BUILD_TIME_PROP = "isAtBuildTime";
    public static final String AT_DEPLOY_TIME_PROP = "isAtDeployTime";
    public static final String AT_DESIGN_TIME_PROP = "isAtDesignTime";
    public static final String AT_RUN_TIME_PROP = "isAtRunTime";
    public static final String FOR_CHILDREN_PROP = "isForChildrenOnly";
    public static final String SC_ALIAS_PROP = "scAlias";
    public static final String PP_REF_PROP = "ppReference";
    public static final String PURPOSE_PROP = "purpose";
    public static final String SUBTYPE_PROP = "subType";
    public static final String TYPE_PROP = "type";
    public static final String PACKAGE_NAME_PROP = "packageName";
    public static final String EXCLUDES_PROP = "excludes";
    public static final String INCLUDES_PROP = "includes";
    public static final String PUBLIC_PART_PROP = "publicPart";
    public static final String DC_NAME_PROP = "dcName";
    public static final String NAME_RESERVATION_PROP = "nameReservationState";
    private TracerI theTracer = TracingManager.getTracer(((Object)((Object)this)).getClass());

    public ComponentPropertyReader() {
        this.configurationNames.add(NAME_PROP);
        this.configurationNames.add(CAPTION_PROP);
        this.configurationNames.add(DESCRIPTION_PROP);
        this.configurationNames.add(VERSION_PROP);
        this.configurationNames.add(BUILDSERVER_PROP);
        this.configurationNames.add(SLLOCATION_PROP);
        this.configurationNames.add(NAMESERVER_PROP);
        this.configurationNames.add(CMS_PROP);
        this.configurationNames.add(ROOTFOLDER_PROP);
        this.compartmentNames.add(NAME_PROP);
        this.compartmentNames.add(CAPTION_PROP);
        this.compartmentNames.add(DESCRIPTION_PROP);
        this.compartmentNames.add(SC_PROP);
        this.compartmentNames.add(SOURCESTATE_PROP);
        this.compartmentNames.add(SCALIEASES_PROP);
        this.compartmentNames.add(USESCOMPARTMENTS_PROP);
        this.compartmentNames.add(MODIFICATION_PROP);
        this.compartmentNames.add(REPOSITORY_PROP);
        this.compartmentNames.add(SOURCELOCATION_PROP);
        this.compartmentNames.add(SOURCEINACTIVELOCATION_PROP);
        this.compartmentNames.add(SOURCEEXPORT_PROP);
        this.dcNames.add(NAME_PROP);
        this.dcNames.add(CAPTION_PROP);
        this.dcNames.add(DESCRIPTION_PROP);
        this.dcNames.add(SYNCSTATE_PROP);
        this.dcNames.add(VENDOR_PROP);
        this.dcNames.add(SYNCMODE_PROP);
        this.dcNames.add(ROOTFOLDER_PROP);
        this.dcNames.add(DIRTY_PROP);
        this.dcNames.add(BROKEN_PROP);
        this.dcNames.add(BUILDNO_PROP);
        this.grantNames.add(TYPE_PROP);
        this.grantNames.add(NAME_PROP);
        this.grantNames.add(VENDOR_PROP);
        this.grantNames.add(SC_ALIAS_PROP);
        this.dcMetaDataNames.add(NAME_PROP);
        this.dcMetaDataNames.add(CAPTION_PROP);
        this.dcMetaDataNames.add(DESCRIPTION_PROP);
        this.dcMetaDataNames.add(VENDOR_PROP);
        this.dcMetaDataNames.add(DC_TYPE_PROP);
        this.dcMetaDataNames.add(DC_BUILDER_PROP);
        this.dcMetaDataNames.add(DC_PARENT_DC_PROP);
        this.dcMetaDataNames.add(DC_LANGUAGE_PROP);
        this.dcMetaDataNames.add(DC_IS_DELIVERED_PROP);
        this.dcMetaDataNames.add(DC_IS_EXTERNAL_PROP);
        this.dependencyNames.add(NAME_PROP);
        this.dependencyNames.add(VENDOR_PROP);
        this.dependencyNames.add(SC_ALIAS_PROP);
        this.dependencyNames.add(PP_REF_PROP);
        this.dependencyNames.add(AT_BUILD_TIME_PROP);
        this.dependencyNames.add(AT_DEPLOY_TIME_PROP);
        this.dependencyNames.add(AT_DESIGN_TIME_PROP);
        this.dependencyNames.add(AT_RUN_TIME_PROP);
        this.dependencyNames.add(FOR_CHILDREN_PROP);
        this.publicPartNames.add(NAME_PROP);
        this.publicPartNames.add(CAPTION_PROP);
        this.publicPartNames.add(DESCRIPTION_PROP);
        this.publicPartNames.add(PURPOSE_PROP);
        this.entityNames.add(NAME_PROP);
        this.entityNames.add(CAPTION_PROP);
        this.entityNames.add(DESCRIPTION_PROP);
        this.entityNames.add(PACKAGE_NAME_PROP);
        this.entityNames.add(TYPE_PROP);
        this.entityNames.add(SUBTYPE_PROP);
        this.entityNames.add(EXCLUDES_PROP);
        this.entityNames.add(INCLUDES_PROP);
        this.entityReferenceNames.add(NAME_PROP);
        this.entityReferenceNames.add(TYPE_PROP);
        this.entityReferenceNames.add(PUBLIC_PART_PROP);
        this.entityReferenceNames.add(VENDOR_PROP);
        this.entityReferenceNames.add(DC_NAME_PROP);
        this.packageNames.add(NAME_PROP);
        this.packageNames.add(NAME_RESERVATION_PROP);
    }

    public String getPropertyValue(Element element, String propertyName) {
        String subdomain = element.getUniqueName().getSubDomain();
        if ("$metaclass".equals(propertyName)) {
            return subdomain;
        }
        Object obj = ObjectUtil.getComponentObject(element);
        if (obj == null) {
            return "";
        }
        if ("com.sap.ide.eclipse.component.model".equals(subdomain) || "com.sap.ide.eclipse.component.local.model".equals(subdomain)) {
            return this.getConfigurationProperty(obj, propertyName);
        }
        if ("com.sap.ide.eclipse.component.compartment".equals(subdomain) || "com.sap.ide.eclipse.component.SC.active".equals(subdomain) || "com.sap.ide.eclipse.component.SC.inactive".equals(subdomain)) {
            return this.getCompartmentProperty(obj, propertyName);
        }
        if ("com.sap.ide.eclipse.component.DC".equals(subdomain)) {
            return this.getDCProperty(obj, propertyName);
        }
        if ("com.sap.ide.eclipse.component.DCMetaData.Folder".equals(subdomain)) {
            return this.getDCMetaDataProperty(obj, propertyName);
        }
        if ("com.sap.ide.eclipse.component.DCMetaData.DCDependency".equals(subdomain)) {
            return this.getDependencyProperty(obj, propertyName);
        }
        if ("com.sap.ide.eclipse.component.DCMetaData.AccessList".equals(subdomain)) {
            return this.getAccessListProperty(obj, propertyName);
        }
        if ("com.sap.ide.eclipse.component.DCMetaData.PPAccessList".equals(subdomain)) {
            return this.getAccessListProperty(obj, propertyName);
        }
        if ("com.sap.ide.eclipse.component.DCMetaData.PPMetaData".equals(subdomain)) {
            return this.getPPProperty(obj, propertyName);
        }
        if ("com.sap.ide.eclipse.component.DCMetaData.PPEntity".equals(subdomain)) {
            return this.getPPEntityProperty(obj, propertyName);
        }
        if ("com.sap.ide.eclipse.component.DCMetaData.PPEntityReference".equals(subdomain)) {
            return this.getPPEntityReferenceProperty(obj, propertyName);
        }
        if ("com.sap.ide.eclipse.component.DCMetaData.Package".equals(subdomain)) {
            return this.getPackageProperty(element, obj, propertyName);
        }
        return null;
    }

    private String getConfigurationProperty(Object object, String propertyName) {
        IDevelopmentConfiguration configuration = null;
        if (object instanceof IDevelopmentConfiguration) {
            configuration = (IDevelopmentConfiguration)object;
        }
        if (configuration == null) {
            return "";
        }
        if (ROOTFOLDER_PROP.equals(propertyName)) {
            return configuration.getConfigurationRootFolder();
        }
        DevelopmentConfiguration data = configuration.getConfigurationData();
        if (data == null) {
            return null;
        }
        if (NAME_PROP.equals(propertyName)) {
            return data.getName();
        }
        if (CAPTION_PROP.equals(propertyName)) {
            return data.getCaption();
        }
        if (DESCRIPTION_PROP.equals(propertyName)) {
            return data.getDescription();
        }
        if (VERSION_PROP.equals(propertyName)) {
            return data.getConfigVersion();
        }
        if (BUILDSERVER_PROP.equals(propertyName)) {
            return data.getBuildServer();
        }
        if (SLLOCATION_PROP.equals(propertyName)) {
            return data.getLocation();
        }
        if (NAMESERVER_PROP.equals(propertyName)) {
            return data.getNameServer();
        }
        if (CMS_PROP.equals(propertyName)) {
            return data.getCMS();
        }
        return null;
    }

    private String getCompartmentProperty(Object object, String propertyName) {
        ICompartmentNode compNode = null;
        if (object instanceof ICompartmentNode) {
            compNode = (ICompartmentNode)object;
        }
        if (compNode == null) {
            return "";
        }
        if (SC_PROP.equals(propertyName)) {
            return compNode.getSCName() + (compNode.getSCVendor() != null ? " (" + compNode.getSCVendor() + ")" : "");
        }
        if (MODIFICATION_PROP.equals(propertyName)) {
            return new Boolean(compNode.modificationAllowed()).toString();
        }
        Compartment compartment = null;
        compartment = compNode.getCompartment();
        if (compartment == null) {
            return "";
        }
        if (NAME_PROP.equals(propertyName)) {
            return compartment.getName();
        }
        if (CAPTION_PROP.equals(propertyName)) {
            return compartment.getCaption();
        }
        if (DESCRIPTION_PROP.equals(propertyName)) {
            return compartment.getDescription();
        }
        if (SCALIEASES_PROP.equals(propertyName)) {
            Map map = compartment.getScAliases();
            if (map != null) {
                return map.toString();
            }
            return "";
        }
        if (USESCOMPARTMENTS_PROP.equals(propertyName)) {
            if (compartment.getUsedCompartments() == null) {
                return "";
            }
            return compartment.getUsedCompartments().toString();
        }
        SourceState state = compartment.getSourceState();
        if (SOURCESTATE_PROP.equals(propertyName)) {
            if (state == null) {
                return "none";
            }
            return state.toString();
        }
        if (state == null) {
            return null;
        }
        if (REPOSITORY_PROP.equals(propertyName)) {
            if (state.getRepository() != null) {
                return state.getRepository().getURL();
            }
            return "";
        }
        if (SOURCELOCATION_PROP.equals(propertyName)) {
            return state.getLocation();
        }
        if (SOURCEINACTIVELOCATION_PROP.equals(propertyName)) {
            return state.getInactiveLocation();
        }
        if (SOURCEEXPORT_PROP.equals(propertyName)) {
            return new Boolean(state.isExportAllowed()).toString();
        }
        return null;
    }

    private String getDCProperty(Object object, String propertyName) {
        IDevelopmentComponentNode dcNode = null;
        if (object instanceof IDevelopmentComponentNode) {
            dcNode = (IDevelopmentComponentNode)object;
        }
        if (dcNode == null) {
            return "";
        }
        if (NAME_PROP.equals(propertyName)) {
            return dcNode.getName();
        }
        if (VENDOR_PROP.equals(propertyName)) {
            return dcNode.getVendor();
        }
        if (SYNCSTATE_PROP.equals(propertyName)) {
            return dcNode.getNodeSyncState().toString();
        }
        if (SYNCMODE_PROP.equals(propertyName)) {
            return dcNode.getNodeSyncMode().toString();
        }
        if (ROOTFOLDER_PROP.equals(propertyName)) {
            return dcNode.getComponentRootFolder();
        }
        if (DIRTY_PROP.equals(propertyName)) {
            return dcNode.isDirty() ? "yes" : "no";
        }
        if (BROKEN_PROP.equals(propertyName)) {
            return dcNode.isBroken() ? "yes" : "no";
        }
        if (BUILDNO_PROP.equals(propertyName)) {
            try {
                String buildVariant = Util.getBuildVariant(dcNode.getConfiguration(), dcNode.getCompartmentName());
                long bnr = dcNode.getSynchedBuildNumber(buildVariant);
                return bnr == -1L ? "N/A (not synched as archive)" : bnr + " (" + buildVariant + ")";
            }
            catch (Exception e1) {
                return "unknown";
            }
        }
        DevelopmentComponent dc = null;
        try {
            dc = dcNode.getDevelopmentComponent(false);
        }
        catch (RepositoryAccessException e) {
            Util.logExceptionMessage(this.theTracer, 3, "Get DC Propertiy failed", e);
        }
        catch (InvalidDefinitionException e) {
            Util.logExceptionMessage(this.theTracer, 3, "Get DC Propertiy failed", e);
        }
        if (dc == null) {
            return "";
        }
        if (CAPTION_PROP.equals(propertyName)) {
            return dc.getCaption();
        }
        if (DESCRIPTION_PROP.equals(propertyName)) {
            return dc.getDescription();
        }
        return null;
    }

    private String getDCMetaDataProperty(Object object, String propertyName) {
        IDevelopmentComponentNode dcNode = null;
        if (object instanceof IDevelopmentComponentNode) {
            dcNode = (IDevelopmentComponentNode)object;
        }
        if (dcNode == null) {
            return "";
        }
        if (NAME_PROP.equals(propertyName)) {
            return dcNode.getName();
        }
        if (VENDOR_PROP.equals(propertyName)) {
            return dcNode.getVendor();
        }
        DevelopmentComponent dc = null;
        try {
            dc = dcNode.getDevelopmentComponent(false);
        }
        catch (RepositoryAccessException e) {
            Util.logExceptionMessage(this.theTracer, 3, "Get DC Propertiy failed", e);
        }
        catch (InvalidDefinitionException e) {
            Util.logExceptionMessage(this.theTracer, 3, "Get DC Propertiy failed", e);
        }
        if (dc == null) {
            return "";
        }
        if (CAPTION_PROP.equals(propertyName)) {
            return dc.getCaption();
        }
        if (DESCRIPTION_PROP.equals(propertyName)) {
            return dc.getDescription();
        }
        if (DC_TYPE_PROP.equals(propertyName)) {
            ComponentType compType = dc.getComponentType();
            if (compType != null) {
                return (compType.getType() != null ? compType.getType() : "") + (compType.getSubType() != null ? "/" + compType.getSubType() : "") + (compType.getVendor() != null ? " (" + compType.getVendor() + ")" : "");
            }
            return "";
        }
        if (DC_BUILDER_PROP.equals(propertyName)) {
            PPReference ppRef = dc.getBuildPlugin();
            if (ppRef != null && ppRef.getName() != null) {
                return ppRef.getName();
            }
            return "";
        }
        if (DC_PARENT_DC_PROP.equals(propertyName)) {
            DCReference aParentDcRef = dc.getEnclosingComponent();
            if (aParentDcRef == null) {
                return "";
            }
            StringBuffer aBuffer = new StringBuffer();
            aBuffer.append("Name: ");
            aBuffer.append(aParentDcRef.getName());
            aBuffer.append(" Vendor: ");
            aBuffer.append(aParentDcRef.getVendor());
            String anSCAlias = aParentDcRef.getSCAlias();
            if (anSCAlias != null && anSCAlias.trim() != "") {
                aBuffer.append(" SCAlias: ");
                aBuffer.append(anSCAlias);
            }
            return aBuffer.toString();
        }
        if (DC_LANGUAGE_PROP.equals(propertyName)) {
            PropertyElement pe;
            Property p = dc.getProperty("localization", "http://xml.sap.com/2003/06/Localization");
            if (p != null && (pe = p.getChild("originalLocale")) != null) {
                return pe.getValue();
            }
            Property prop = dc.getProperty(ProjectWizard.LANGUAGE_PROPERTY);
            return prop != null ? prop.getValue() : "unknown";
        }
        if (DC_IS_EXTERNAL_PROP.equals(propertyName)) {
            String result = dc.isExternal() ? "true" : "false";
            return result;
        }
        if (DC_IS_DELIVERED_PROP.equals(propertyName)) {
            return dc.isInternal() ? "false" : "true";
        }
        return null;
    }

    private String getAccessListProperty(Object object, String propertyName) {
        ComponentReference aGrant = null;
        if (object instanceof ComponentReference) {
            aGrant = (ComponentReference)object;
        }
        if (aGrant == null) {
            return "";
        }
        if (TYPE_PROP.equals(propertyName)) {
            return aGrant instanceof DCReference ? "DC" : "SC";
        }
        if (NAME_PROP.equals(propertyName)) {
            return aGrant.getName();
        }
        if (VENDOR_PROP.equals(propertyName)) {
            return aGrant.getVendor();
        }
        if (SC_ALIAS_PROP.equals(propertyName)) {
            return aGrant.getSCAlias();
        }
        return null;
    }

    private String getDependencyProperty(Object object, String propertyName) {
        Dependency dependency = null;
        if (object instanceof Dependency) {
            dependency = (Dependency)object;
        }
        if (dependency == null) {
            return "";
        }
        if (AT_BUILD_TIME_PROP.equals(propertyName)) {
            return String.valueOf(dependency.isAtBuildTime());
        }
        if (AT_DEPLOY_TIME_PROP.equals(propertyName)) {
            return String.valueOf(dependency.isAtDeployTime());
        }
        if (AT_DESIGN_TIME_PROP.equals(propertyName)) {
            return String.valueOf(dependency.isAtDesignTime());
        }
        if (AT_RUN_TIME_PROP.equals(propertyName)) {
            return String.valueOf(dependency.isAtRunTime());
        }
        if (FOR_CHILDREN_PROP.equals(propertyName)) {
            return String.valueOf(dependency.isForChildrenOnly());
        }
        PPReference ppRef = dependency.getPublicPartDependency();
        if (ppRef != null && PP_REF_PROP.equals(propertyName)) {
            return ppRef.getName();
        }
        DCReference reference = dependency.getComponent();
        if (reference != null) {
            if (NAME_PROP.equals(propertyName)) {
                return reference.getName();
            }
            if (VENDOR_PROP.equals(propertyName)) {
                return reference.getVendor();
            }
            if (SC_ALIAS_PROP.equals(propertyName)) {
                return reference.getSCAlias();
            }
        }
        return null;
    }

    private String getPPProperty(Object object, String propertyName) {
        PublicPart pp = null;
        if (object instanceof PublicPart) {
            pp = (PublicPart)object;
        }
        if (pp == null) {
            return "";
        }
        if (NAME_PROP.equals(propertyName)) {
            return pp.getName();
        }
        if (CAPTION_PROP.equals(propertyName)) {
            return pp.getCaption();
        }
        if (DESCRIPTION_PROP.equals(propertyName)) {
            return pp.getDescription();
        }
        if (PURPOSE_PROP.equals(propertyName)) {
            return pp.getPurpose().toString();
        }
        return null;
    }

    private String getPPEntityProperty(Object object, String propertyName) {
        List aList;
        FileSet aFileSet;
        Entity entity = null;
        if (object instanceof Entity) {
            entity = (Entity)object;
        }
        if (entity == null) {
            return "";
        }
        if (NAME_PROP.equals(propertyName)) {
            return entity.getName();
        }
        if (CAPTION_PROP.equals(propertyName)) {
            return entity.getCaption();
        }
        if (DESCRIPTION_PROP.equals(propertyName)) {
            return entity.getDescription();
        }
        if (PACKAGE_NAME_PROP.equals(propertyName)) {
            return entity.getPackageName();
        }
        if (TYPE_PROP.equals(propertyName)) {
            return entity.getType();
        }
        if (SUBTYPE_PROP.equals(propertyName)) {
            return entity.getSubType();
        }
        if (EXCLUDES_PROP.equals(propertyName) && (aFileSet = entity.getFileSet()) != null && (aList = aFileSet.getExcludes()) != null) {
            StringBuffer aBuffer = new StringBuffer();
            Iterator anIter = aList.iterator();
            while (anIter.hasNext()) {
                aBuffer.append(anIter.next());
                if (!anIter.hasNext()) continue;
                aBuffer.append(",");
            }
            return aBuffer.toString();
        }
        if (INCLUDES_PROP.equals(propertyName) && (aFileSet = entity.getFileSet()) != null && (aList = aFileSet.getIncludes()) != null) {
            StringBuffer aBuffer = new StringBuffer();
            Iterator anIter = aList.iterator();
            while (anIter.hasNext()) {
                aBuffer.append(anIter.next());
                if (!anIter.hasNext()) continue;
                aBuffer.append(",");
            }
            return aBuffer.toString();
        }
        return null;
    }

    private String getPPEntityReferenceProperty(Object object, String propertyName) {
        EntityReference entityRef = null;
        if (object instanceof EntityReference) {
            entityRef = (EntityReference)object;
        }
        if (entityRef == null) {
            return "";
        }
        if (NAME_PROP.equals(propertyName)) {
            return entityRef.getName();
        }
        if (TYPE_PROP.equals(propertyName)) {
            return entityRef.getType();
        }
        if (PUBLIC_PART_PROP.equals(propertyName)) {
            return entityRef.getPublicPart();
        }
        if (DC_NAME_PROP.equals(propertyName)) {
            return entityRef.getComponent().getName();
        }
        if (VENDOR_PROP.equals(propertyName)) {
            return entityRef.getComponent().getVendor();
        }
        return null;
    }

    private String getPackageProperty(Element element, Object object, String propertyName) {
        PackageObject pack = null;
        if (object instanceof PackageObject) {
            pack = (PackageObject)object;
        }
        if (pack == null) {
            return "";
        }
        if (NAME_PROP.equals(propertyName)) {
            return pack.getFragment().getElementName();
        }
        if (NAME_RESERVATION_PROP.equals(propertyName)) {
            return NamereservationUtil.getPackageNRState(pack);
        }
        return null;
    }

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        if ("$metaclass".equals(propertyName)) {
            return true;
        }
        Set propSet = this.getPropNames(element);
        if (propSet != null) {
            return propSet.contains(propertyName);
        }
        return false;
    }

    public boolean hasProperty(Element element, String propertyName) {
        if (super.hasProperty(element, propertyName)) {
            if (!propertyName.equals(SOURCESTATE_PROP)) {
                return true;
            }
            Object object = ObjectUtil.getComponentObject(element);
            if (object instanceof ICompartmentNode) {
                ICompartmentNode compNode = (ICompartmentNode)object;
                return compNode.getCompartment() != null && compNode.getCompartment().getSourceState() != null;
            }
        }
        return false;
    }
}

