/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.ui.properties;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.PropertyAdapter;
import com.tssap.selena.model.util.SingleEnumeration;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractPropertyReader
extends AbstractProvider
implements PropertyGetProvider {
    protected final Set configurationNames = new HashSet();
    protected final Set compartmentNames = new HashSet();
    protected final Set dcNames = new HashSet();
    protected final Set dcMetaDataNames = new HashSet();
    protected final Set grantNames = new HashSet();
    protected final Set dependencyNames = new HashSet();
    protected final Set publicPartNames = new HashSet();
    protected final Set entityNames = new HashSet();
    protected final Set entityReferenceNames = new HashSet();
    protected final Set packageNames = new HashSet();

    public Property getProperty(Element element, String propertyName) {
        Set props = this.getPropNames(element);
        if (props == null) {
            return null;
        }
        if (!props.contains(propertyName)) {
            return null;
        }
        String propertyValue = this.getPropertyValue(element, propertyName);
        if (propertyValue == null) {
            return null;
        }
        return this.getPropertyAdapter(element, propertyName, propertyValue);
    }

    public boolean hasProperty(Element element, String propertyName) {
        Set props = this.getPropNames(element);
        if (props == null) {
            return false;
        }
        return props.contains(propertyName) && this.getPropertyValue(element, propertyName) != null;
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        if (propertyValue == null) {
            return false;
        }
        Set props = this.getPropNames(element);
        if (props == null) {
            return false;
        }
        if (!props.contains(propertyName)) {
            return false;
        }
        return propertyValue.equals(this.getPropertyValue(element, propertyName));
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        Property property = this.getProperty(element, propertyName);
        return property == null ? EmptyEnumeration.getPropertyEnumeration() : SingleEnumeration.createPropertyEnumeration((Property)property);
    }

    public PropertyEnumeration properties(Element element) {
        Set props = this.getPropNames(element);
        if (props == null) {
            return null;
        }
        ArrayList<Property> properties = new ArrayList<Property>(props.size());
        Iterator propertyNames = props.iterator();
        while (propertyNames.hasNext()) {
            Property property = this.getProperty(element, (String)propertyNames.next());
            if (property == null) continue;
            properties.add(property);
        }
        return EnumerationConverter.toPropertyEnumeration(properties.iterator());
    }

    protected Property getPropertyAdapter(Element element, String propertyName, String propertyValue) {
        return new PropertyAdapter(propertyName, propertyValue, element);
    }

    protected String unknownProperty(String propertyName) {
        throw new RuntimeException("Unknown property [" + propertyName + "]");
    }

    protected Set getPropNames(Element element) {
        String subdomain = element.getUniqueName().getSubDomain();
        if ("com.sap.ide.eclipse.component.model".equals(subdomain) || "com.sap.ide.eclipse.component.local.model".equals(subdomain)) {
            return this.configurationNames;
        }
        if ("com.sap.ide.eclipse.component.compartment".equals(subdomain) || "com.sap.ide.eclipse.component.SC.active".equals(subdomain) || "com.sap.ide.eclipse.component.SC.inactive".equals(subdomain)) {
            return this.compartmentNames;
        }
        if ("com.sap.ide.eclipse.component.DC".equals(subdomain)) {
            return this.dcNames;
        }
        if ("com.sap.ide.eclipse.component.DCMetaData.Folder".equals(subdomain)) {
            return this.dcMetaDataNames;
        }
        if ("com.sap.ide.eclipse.component.DCMetaData.DCDependency".equals(subdomain)) {
            return this.dependencyNames;
        }
        if ("com.sap.ide.eclipse.component.DCMetaData.AccessList".equals(subdomain)) {
            return this.grantNames;
        }
        if ("com.sap.ide.eclipse.component.DCMetaData.PPAccessList".equals(subdomain)) {
            return this.grantNames;
        }
        if ("com.sap.ide.eclipse.component.DCMetaData.PPMetaData".equals(subdomain)) {
            return this.publicPartNames;
        }
        if ("com.sap.ide.eclipse.component.DCMetaData.PPEntity".equals(subdomain)) {
            return this.entityNames;
        }
        if ("com.sap.ide.eclipse.component.DCMetaData.PPEntityReference".equals(subdomain)) {
            return this.entityReferenceNames;
        }
        if ("com.sap.ide.eclipse.component.DCMetaData.Package".equals(subdomain)) {
            return this.packageNames;
        }
        return null;
    }

    public abstract String getPropertyValue(Element var1, String var2);

    public abstract boolean isPropertyProviderApplicable(Element var1, String var2);
}

