/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.ui.message;

import com.sap.tc.devconf.SyncException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ComponentProviderMessages {
    private static final String RESOURCE_BUNDLE = "com.sap.ide.eclipse.component.provider.ui.message.messages";
    private static ResourceBundle bundle = ResourceBundle.getBundle("com.sap.ide.eclipse.component.provider.ui.message.messages");

    private ComponentProviderMessages() {
    }

    public static String format(String key, Object[] args) {
        return MessageFormat.format(ComponentProviderMessages.getString(key), args);
    }

    public static String getString(String key) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static String getString(String key, String def) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return def;
        }
    }

    public static String getSyncExceptionText(SyncException ex) {
        String dcName = ex.getComponentName();
        String dcVendor = ex.getComponentVendor();
        String message = "";
        switch (ex.getErrorCode()) {
            case -1: {
                message = ComponentProviderMessages.getString("SyncException.INTERNAL_ERROR");
                break;
            }
            case 0: {
                message = null;
                break;
            }
            case 1: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_COMPONENT_SYNC");
                break;
            }
            case 2: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_COMPDEF_READ");
                break;
            }
            case 3: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_COMPDEF_READ_XML");
                break;
            }
            case 4: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_COMPDEF_READ_IO");
                break;
            }
            case 5: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_COMPDEF_READ_PROVIDER");
                break;
            }
            case 6: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_NO_SOURCE_STATE");
                break;
            }
            case 7: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_OBJECTS_CHECKED_OUT");
                break;
            }
            case 8: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_NO_ARCHIVE_STATE");
                break;
            }
            case 9: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_NO_BUILD_SPACE");
                break;
            }
            case 10: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_DEVCONF_ALREADY_EXISTS");
                break;
            }
            case 11: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_USED_COMPONENT_NOT_FOUND");
                break;
            }
            case 12: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_USED_PUBLIC_PART_NOT_FOUND");
                break;
            }
            case 13: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_COMPONENT_NOT_LOCAL_ONLY");
                break;
            }
            case 14: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_PARENT_COMPONENT_NOT_FOUND");
                break;
            }
            case 15: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_VFS_BS_NOT_FOUND");
                break;
            }
            case 16: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_BUILD_SERVER");
                break;
            }
            case 17: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_DEFAULT_VARIANT");
                break;
            }
            case 18: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_FILE_DELETE");
                break;
            }
            case 19: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_LOCAL_FILE_READ");
                break;
            }
            case 20: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_DC_NOT_AVAILABLE_LOCALLY");
                break;
            }
            case 21: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_SDK_PATH_PROPERTY_NOT_FOUND");
                break;
            }
            case 22: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_OFFLINE");
                break;
            }
            case 23: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_WRONG_SYNC_MODE");
                break;
            }
            case 24: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_COMMUNICATION");
                break;
            }
            case 25: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_NO_COMPARTMENT");
                break;
            }
            case 26: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_NO_VARIANT");
                break;
            }
            case 27: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_NO_DC_VARIANT");
                break;
            }
            case 28: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_LOCAL_IO");
                break;
            }
            case 29: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_CBS_RESULTS_LOCKED");
                break;
            }
            case 30: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_NO_PUBLICPART");
                break;
            }
            case 100: {
                message = ComponentProviderMessages.getString("SyncException.ERROR_VFS");
            }
        }
        if (message == null || "".equals(message)) {
            message = ex.getLocalizedMessage();
        }
        if (message == null) {
            message = "";
        }
        if (dcName == null) {
            dcName = "";
        }
        if (dcVendor == null) {
            dcVendor = "";
        }
        if (!"".equals(dcName) || !"".equals(dcVendor)) {
            return ComponentProviderMessages.format("SyncException.message", new String[]{dcName, dcVendor, message});
        }
        return message;
    }
}

