/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.ui.label;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.eclipse.component.provider.objects.ComponentVfsModelObject;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.ide.eclipse.component.provider.objects.PackageObject;
import com.sap.ide.eclipse.dii.component.PackageUtil;
import com.sap.ide.login.UserValidator;
import com.sap.lcr.namealloc.api.CommunicationFailureException;
import com.tssap.dtr.client.eclipse.ui.DAVDecorator;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.NeutralLabelDecorator;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.swt.graphics.Image;

public class DCMetaDataDecoratorProvider
extends NeutralLabelDecorator {
    private TracerI theTracer = TracingManager.getTracer(((Object)((Object)this)).getClass());

    public Image decorateImage(Image image, Object object) {
        if (image == null || !(object instanceof Element)) {
            return image;
        }
        if (!UserValidator.isDefaultServerOnline()) {
            return image;
        }
        Element element = (Element)object;
        Object obj = ObjectUtil.getComponentModelObject(element);
        if (obj instanceof ComponentVfsModelObject) {
            IVfsFolderItem vfsFolderItem = ((ComponentVfsModelObject)obj).getVfsFolderItem();
            boolean stretch = false;
            return DAVDecorator.decorateFolderItem((Image)image, (IVfsFolderItem)vfsFolderItem, (boolean)stretch);
        }
        String sd = element.getUniqueName().getSubDomain();
        if (!"com.sap.ide.eclipse.component.DCMetaData.Package".equals(sd)) {
            return image;
        }
        obj = ObjectUtil.getComponentObject(element);
        if (obj == null) {
            return image;
        }
        if (obj instanceof PackageObject) {
            VfsFolderItemLocationState locationState = null;
            Object activityState = null;
            PackageObject pack = (PackageObject)obj;
            IPackageFragment resource = pack.getFragment();
            if (pack.getState() != null && pack.getState().isReserved()) {
                IVfsFile file = null;
                try {
                    file = PackageUtil.getVFSPackageFile((IPackageFragment)resource);
                }
                catch (VfsException e) {
                    Util.logExceptionMessage(this.theTracer, 3, "Check package state failed", e);
                }
                locationState = file != null && (!VfsFolderItemLocationState.LOCAL_ONLY.equals(file.getLocationState()) || VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE.equals(file.getActivityState())) ? VfsFolderItemLocationState.SYNCED_TO_LATEST : (pack.getState().isReservedPreliminary() ? VfsFolderItemLocationState.SYNCED_TO_FORMER : VfsFolderItemLocationState.SERVER_ONLY);
            } else {
                locationState = VfsFolderItemLocationState.LOCAL_ONLY;
                try {
                    if (!PackageUtil.isPackageNameValid((IPackageFragment)resource)) {
                        locationState = VfsFolderItemLocationState.SYNCED_TO_FORMER;
                    }
                }
                catch (CommunicationFailureException e) {
                    Util.logExceptionMessage(this.theTracer, 3, "Check package state failed", e);
                }
            }
            return ComponentCategoryImage.getCompositeImage(image, (Object)locationState, activityState);
        }
        return image;
    }
}

