/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.ui.label;

import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.tc.devconf.DCNodeSyncMode;
import com.sap.tc.devconf.DCNodeSyncState;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.ui.NeutralLabelDecorator;
import org.eclipse.swt.graphics.Image;

public class DCGenericDecoratorProvider
extends NeutralLabelDecorator {
    public Image decorateImage(Image image, Object object) {
        if (image == null || !(object instanceof Element)) {
            return image;
        }
        DCNodeSyncMode mode = null;
        DCNodeSyncState state = null;
        Element element = (Element)object;
        Object obj = ObjectUtil.getComponentObject(element);
        if (!(obj instanceof IDevelopmentComponentNode)) {
            return image;
        }
        IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)obj;
        mode = dcNode.getNodeSyncMode();
        state = dcNode.getNodeSyncState();
        boolean dirty = dcNode.isDirty() && ComponentUtil.isLocal(element);
        boolean broken = dcNode.isBroken() && ComponentUtil.isLocal(element);
        return DCGenericDecoratorProvider.getDecoratedImage(image, mode, state, dirty, broken);
    }

    public static Image getDecoratedImage(Image image, DCNodeSyncMode mode, DCNodeSyncState state, boolean dirty, boolean broken) {
        VfsFolderItemLocationState locationState = null;
        Object activityState = null;
        String syncInactive = null;
        if (mode != null && state != null) {
            locationState = VfsFolderItemLocationState.LOCAL_ONLY;
            if (DCNodeSyncMode.LOCAL_ONLY.equals(mode)) {
                if (DCNodeSyncState.INSTALLED.equals(state)) {
                    locationState = null;
                }
            } else if (DCNodeSyncMode.NOT_SYNCHED.equals(mode)) {
                locationState = null;
            } else if (DCNodeSyncMode.SYNCHED_AS_ARCHIVE.equals(mode) || DCNodeSyncMode.SYNCHED_AS_ACTIVE_SOURCE.equals(mode)) {
                locationState = VfsFolderItemLocationState.SYNCED_TO_LATEST;
            } else if (DCNodeSyncMode.SYNCHED_AS_INACTIVE_SOURCE.equals(mode)) {
                syncInactive = "Sync inactive";
            }
            if (DCNodeSyncState.UPTODATE.equals(state) && !DCNodeSyncMode.LOCAL_ONLY.equals(mode)) {
                locationState = VfsFolderItemLocationState.SYNCED_TO_LATEST;
            } else if (DCNodeSyncState.OUTDATED.equals(state)) {
                locationState = VfsFolderItemLocationState.SYNCED_TO_FORMER;
            }
        }
        Image decoratedImage = syncInactive == null ? ComponentCategoryImage.getCompositeImage(image, (Object)locationState, activityState) : ComponentCategoryImage.getDecoratedImage(ComponentCategoryImage.getCompositeImage(image, (Object)locationState, activityState), syncInactive);
        if (dirty) {
            decoratedImage = ComponentCategoryImage.getDecoratedImage(decoratedImage, "DC dirty");
        } else if (broken) {
            decoratedImage = ComponentCategoryImage.getDecoratedImage(decoratedImage, "DC broken");
        }
        return decoratedImage;
    }
}

