/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.ui.filter;

import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.login.UserValidator;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.filter.YesManFilter;

public class ConfigurableFilter
extends YesManFilter {
    private int visibleLevel = 2;
    public static final int SC_VISIBLE_LEVEL = 1;
    public static final int DC_VISIBLE_LEVEL = 2;
    public static final int PP_VISIBLE_LEVEL = 4;
    public static final int ENTITY_VISIBLE_LEVEL = 8;
    protected static final int ALL_LEVEL = 15;

    public ConfigurableFilter(int level) {
        this.setVisibleLevel(level);
    }

    public boolean isAvailable(PropertyMap propertyMap) {
        if (propertyMap instanceof Element) {
            Element element = (Element)propertyMap;
            if (ComponentUtil.isLoginConfiguration(element)) {
                return true;
            }
            UniqueName name = element.getUniqueName();
            String domain = name.getDomain();
            String subdomain = name.getSubDomain();
            if (!"com.sap.ide.eclipse.component".equals(domain) && !"com.sap.ide.eclipse.component.DCMetaData".equals(domain)) {
                return false;
            }
            if (UserValidator.isDefaultServerOnline()) {
                if (this.visibleLevel == 1 && "com.sap.ide.eclipse.component.model".equals(subdomain)) {
                    return false;
                }
                if ("com.sap.ide.eclipse.component.local.model".equals(subdomain) && this.visibleLevel != 1) {
                    IDevelopmentConfiguration config = ComponentUtil.getParentDevConf(element);
                    if (config != null) {
                        return config.isLocalConfiguration();
                    }
                    return false;
                }
            }
            if (!UserValidator.isDefaultServerOnline() && "com.sap.ide.eclipse.component".equals(domain) && "com.sap.ide.eclipse.component.model".equals(subdomain)) {
                return false;
            }
            if ("com.sap.ide.eclipse.component.local.model".endsWith(subdomain) || "com.sap.ide.eclipse.component.model".endsWith(subdomain) || "com.sap.ide.eclipse.component.compartment".endsWith(subdomain) || "com.sap.ide.eclipse.component.SC.active".endsWith(subdomain) || "com.sap.ide.eclipse.component.SC.inactive".endsWith(subdomain)) {
                return true;
            }
            if (this.visibleLevel >= 2 && ("com.sap.ide.eclipse.component.DC".equals(subdomain) || "com.sap.ide.eclipse.component.DCMetaData.Folder".equals(subdomain) || "com.sap.ide.eclipse.component.DCMetaData.DCDefinition".equals(subdomain) || "com.sap.ide.eclipse.component.DCMetaData.DCChildrenFolder".equals(subdomain))) {
                return true;
            }
            if (this.visibleLevel >= 4 && ("com.sap.ide.eclipse.component.DCMetaData.PPFolder".equals(subdomain) || "com.sap.ide.eclipse.component.DCMetaData.PPMetaData".equals(subdomain))) {
                return true;
            }
            if (this.visibleLevel >= 8 && ("com.sap.ide.eclipse.component.DCMetaData.PPEntityFolder".equals(subdomain) || "com.sap.ide.eclipse.component.DCMetaData.PPEntity".equals(subdomain))) {
                return true;
            }
        }
        return false;
    }

    public int getVisibleLevel() {
        return this.visibleLevel;
    }

    public void setVisibleLevel(int visibleLevel) {
        this.visibleLevel = visibleLevel & 0xF;
    }
}

