/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.ui.filter;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.InvalidDefinitionException;
import com.sap.tc.devconf.RepositoryAccessException;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.extension.filter.YesManFilter;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;

public class BuildPluginFilter
extends YesManFilter {
    private static String DEFAULT_BUILDPLUGIN_TYPE = "build plugin";
    private static String ALTERNATIVE_BUILDPLUGIN_TYPE = "buildplugin";
    private TracerI theTracer = TracingManager.getTracer(((Object)((Object)this)).getClass());

    public boolean isAvailable(PropertyMap propertyMap) {
        Object obj;
        if (propertyMap instanceof Element && (obj = ObjectUtil.getComponentObject((Element)propertyMap)) != null && obj instanceof IDevelopmentComponentNode) {
            IDevelopmentComponentNode node = (IDevelopmentComponentNode)obj;
            DevelopmentComponent dc = null;
            try {
                dc = node.getDevelopmentComponent(false);
            }
            catch (RepositoryAccessException e) {
                Util.logExceptionMessage(this.theTracer, 3, "get DC Meta Data failed", e);
            }
            catch (InvalidDefinitionException e) {
                Util.logExceptionMessage(this.theTracer, 3, "get DC Meta Data failed", e);
            }
            if (dc == null) {
                return false;
            }
            String type = dc.getComponentType().getType();
            if (type == null) {
                return false;
            }
            return (type = type.toLowerCase()).startsWith(DEFAULT_BUILDPLUGIN_TYPE) || type.startsWith(ALTERNATIVE_BUILDPLUGIN_TYPE);
        }
        return true;
    }
}

