/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.ui.filter;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.debug.DebugWizard;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.ide.login.UserValidator;
import com.sap.tc.complib.BuildVariant;
import com.sap.tc.complib.Compartment;
import com.sap.tc.devconf.ICompartmentNode;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.filter.YesManFilter;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.List;
import java.util.Map;

public class AddDebugSrcFilter
extends YesManFilter {
    private static final String SOURCE_OPTION = "include_debug_sources";
    private TracerI theTracer = TracingManager.getTracer(((Object)((Object)this)).getClass());

    public boolean isAvailable(PropertyMap propertyMap) {
        if (propertyMap instanceof Element) {
            Element element = (Element)propertyMap;
            UniqueName name = element.getUniqueName();
            String domain = name.getDomain();
            String subdomain = name.getSubDomain();
            if (!"com.sap.ide.eclipse.component".equals(domain) && !"com.sap.ide.eclipse.component.DCMetaData".equals(domain)) {
                return false;
            }
            if ("com.sap.ide.eclipse.component.model".equals(subdomain)) {
                return UserValidator.isDefaultServerOnline();
            }
            if ("com.sap.ide.eclipse.component.local.model".equals(subdomain)) {
                return !UserValidator.isDefaultServerOnline();
            }
            Object obj = ObjectUtil.getComponentObject(element);
            if ("com.sap.ide.eclipse.component.compartment".equals(subdomain) || "com.sap.ide.eclipse.component.SC.active".equals(subdomain)) {
                if (obj instanceof ICompartmentNode) {
                    ICompartmentNode compNode = (ICompartmentNode)obj;
                    return (compNode.getCompartment().getHasArchiveState() || compNode.getCompartment().getSourceState().getInactiveLocation() != null) && this.hasDebugOption(compNode.getCompartment(), ComponentUtil.getParentDevConf(element));
                }
                return false;
            }
            if ("com.sap.ide.eclipse.component.DC".equals(subdomain) && obj instanceof IDevelopmentComponentNode) {
                IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)obj;
                if (dcNode.isSynchedAsArchives()) {
                    return this.hasSrcZip(dcNode);
                }
                return UserValidator.isDefaultServerOnline();
            }
        }
        return false;
    }

    private boolean hasDebugOption(Compartment compartment, IDevelopmentConfiguration config) {
        if (compartment != null) {
            Map buildVariants = compartment.getBuildVariants();
            BuildVariant bv = null;
            if (buildVariants.size() == 1) {
                bv = (BuildVariant)buildVariants.values().iterator().next();
            } else {
                String buildVariantStr = null;
                try {
                    buildVariantStr = Util.getBuildVariant(config, compartment.getName());
                }
                catch (Exception e) {
                    Util.logExceptionMessage(this.theTracer, 3, "failed to get build variant", e);
                }
                bv = (BuildVariant)buildVariants.get(buildVariantStr);
            }
            if (bv != null) {
                List optionNames = bv.getBuildOptionNames();
                if (optionNames == null || !optionNames.contains(SOURCE_OPTION)) {
                    return true;
                }
                List optionValues = bv.getBuildOptionValues(SOURCE_OPTION);
                if (optionValues == null || optionValues.isEmpty() || !"false".equals((String)optionValues.get(0))) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasSrcZip(IDevelopmentComponentNode dcNode) {
        return DebugWizard.getDeployZipFile(dcNode) != null || !DebugWizard.getPPZipFiles(dcNode).isEmpty();
    }
}

