/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.ui;

import com.sap.ide.eclipse.component.provider.InstancesProvider;
import com.sap.ide.eclipse.component.provider.listener.DevConfJumpActivitiesListener;
import com.sap.ide.eclipse.component.provider.ui.DcViewLegendManager;
import com.sap.ide.eclipse.component.provider.ui.label.StructureLabelProvider;
import com.sap.ide.eclipse.component.provider.ui.sorter.DCMetaDataSorter;
import com.sap.ide.eclipse.component.provider.ui.sorter.FolderFileSorter;
import com.sap.ide.eclipse.dii.component.ui.DCGenericView;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.ui.LegendDialog;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.IRepositoryViewLegendManager;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.extension.ModelUtilPlugin;
import com.tssap.selena.model.extension.filter.IMutableFilterSet;
import com.tssap.util.UtilPlugin;
import com.tssap.util.ui.ILabelProviderContainer;
import com.tssap.util.ui.LabelProviderContainer;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.image.SapImage;
import com.tssap.util.ui.viewer.sorter.IViewerSorterContainer;
import com.tssap.util.ui.viewer.sorter.ViewerSorterContainer;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;

public abstract class DevConfGenericView
extends DCGenericView {
    private static final String MENU_LABEL_SHOW_LEGEND = "Display Legend";
    private static final String IMAGE_NAME_LEGEND = "showlegend.gif";

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        this.createShowLegendMenu(menuManager);
    }

    private void createShowLegendMenu(IMenuManager mainMenuManager) {
        IContributionItem[] items = mainMenuManager.getItems();
        if (items != null && items.length > 0) {
            mainMenuManager.add((IContributionItem)new Separator());
        }
        Action actShowLegend = new Action(MENU_LABEL_SHOW_LEGEND){

            public ImageDescriptor getImageDescriptor() {
                return BluebirdPlugin.getDefault().createImageDescriptor(DevConfGenericView.IMAGE_NAME_LEGEND);
            }

            public void run() {
                new LegendDialog(DevConfGenericView.this.getSite().getShell(), (IRepositoryViewLegendManager)new DcViewLegendManager(DevConfGenericView.this.getViewType()), this.getImageDescriptor().createImage(true)).open();
            }
        };
        mainMenuManager.add((IAction)actShowLegend);
    }

    abstract int getViewType();

    public void createViewer(Composite parent, IMutableFilterSet treeFilter) {
        super.createViewer(parent, treeFilter);
        TreeViewer treeViewer = this.getTreeViewer().getTreeViewer();
        treeViewer.addPostSelectionChangedListener((ISelectionChangedListener)new DevConfJumpActivitiesListener());
    }

    public void addToolBar() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        Action refreshAction = this.getRefreshAction();
        if (refreshAction != null) {
            refreshAction.setImageDescriptor(SapIdeUtilImages.getImageDescriptorFromIconsDirectory((String)UtilPlugin.getPluginId(), (String)"refresh.gif"));
            refreshAction.setToolTipText("Refresh tree");
            toolBarManager.add((IAction)refreshAction);
        }
        Action setNodesAsRootsAction = new Action(){

            public void run() {
                PropertyMap[] roots = ModelUtilPlugin.computeModels();
                DevConfGenericView.this.getTreeViewer().setRoots(roots);
            }
        };
        setNodesAsRootsAction.setToolTipText("Set all Development Configurations as roots");
        setNodesAsRootsAction.setImageDescriptor(SapIdeUtilImages.getSapImageDescriptor((ISapImage)SapImage.ICON_DISPLAY_TREE));
        toolBarManager.add((IAction)setNodesAsRootsAction);
        Action setSelectedModelsAsRootsAction = new Action(){

            public void run() {
                TreeItem[] selectedItems = DevConfGenericView.this.getTreeViewer().getTree().getSelection();
                Vector<Object> newRootVec = new Vector<Object>();
                int i = 0;
                while (i < selectedItems.length) {
                    TreeItem treeItem = selectedItems[i];
                    Object treeItemData = treeItem.getData();
                    if (treeItemData instanceof PropertyMap) {
                        newRootVec.add(treeItemData);
                    }
                    ++i;
                }
                if (newRootVec.size() > 0) {
                    DevConfGenericView.this.getTreeViewer().setRoots(newRootVec.toArray(new PropertyMap[newRootVec.size()]));
                }
            }
        };
        setSelectedModelsAsRootsAction.setToolTipText("Set selected node as root");
        setSelectedModelsAsRootsAction.setImageDescriptor(SapIdeUtilImages.getSapImageDescriptor((ISapImage)SapImage.ICON_DBOM_SUB_ITEM));
        toolBarManager.add((IAction)setSelectedModelsAsRootsAction);
    }

    public ILabelProviderContainer getLabelProviderContainer() {
        if (this.labelProviderContainer == null) {
            this.labelProviderContainer = new LabelProviderContainer();
            this.labelProviderContainer.addLabelProvider((ILabelProvider)new StructureLabelProvider());
            this.labelProviderContainer.addLabelProvider((ILabelProvider)new DecoratingLabelProvider(InstancesProvider.getDCGenericLabelProvider(), InstancesProvider.getDCGenericDecoratorProvider()));
            this.labelProviderContainer.addLabelProvider((ILabelProvider)new DecoratingLabelProvider(InstancesProvider.getDCMetaDataLabelProvider(), InstancesProvider.getDCMetaDataDecoratorProvider()));
            this.labelProviderContainer.addLabelProvider((ILabelProvider)new DecoratingLabelProvider(InstancesProvider.getFolderFileLabelProvider(), InstancesProvider.getFolderFileDecoratorProvider()));
            this.labelProviderContainer.setDefaultText("?");
        }
        return this.labelProviderContainer;
    }

    public IViewerSorterContainer getViewerSorterContainer() {
        if (this.viewerSorterContainer == null) {
            this.viewerSorterContainer = new ViewerSorterContainer();
            this.viewerSorterContainer.addViewerSorter((ViewerSorter)new DCMetaDataSorter());
            this.viewerSorterContainer.addViewerSorter((ViewerSorter)new FolderFileSorter());
        }
        return this.viewerSorterContainer;
    }
}

