/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.ui;

import com.sap.ide.eclipse.component.core.ComponentTypeTreeViewer;
import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.eclipse.component.provider.ui.label.DCGenericDecoratorProvider;
import com.sap.tc.complib.ComponentType;
import com.sap.tc.devconf.DCNodeSyncMode;
import com.sap.tc.devconf.DCNodeSyncState;
import com.tssap.dtr.client.eclipse.ui.DAVDecorator;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.IRepositoryViewLegendManager;
import com.tssap.dtr.client.eclipse.util.ILegend;
import com.tssap.dtr.client.eclipse.util.LegendElement;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemCategory;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.swt.graphics.Image;

public class DcViewLegendManager
implements IRepositoryViewLegendManager,
IExecutableExtension {
    private IConfigurationElement m_config;
    private String m_viewId;
    private int _viewType;
    public static final int VIEWTYPE_ACTIVE_DCS = 0;
    public static final int VIEWTYPE_INACTIVE_DCS = 1;
    public static final int VIEWTYPE_LOCAL_DCS = 2;

    public DcViewLegendManager(int viewType) {
        this._viewType = viewType;
    }

    public ILegend[] getViewLegend() {
        ArrayList<LegendElement> legendList = new ArrayList<LegendElement>();
        if (this.getViewId().equals("")) {
            legendList.add(new LegendElement("Main Objects:"));
            legendList.add(new LegendElement("Offline", (Object)"jiServerOffline", null, null, null, null));
            legendList.add(new LegendElement(ComponentCategoryImage.getImage("Configuration"), "Development Configuration"));
            switch (this._viewType) {
                case 0: {
                    legendList.add(new LegendElement(ComponentCategoryImage.getImage("Software Component active"), "Software Component in active state (read-only)"));
                    break;
                }
                case 1: {
                    legendList.add(new LegendElement(ComponentCategoryImage.getImage("Software Component inactive"), "Software Component in inactive state (editable)"));
                    break;
                }
                case 2: {
                    legendList.add(new LegendElement(ComponentCategoryImage.getImage("Compartment"), "Software Component"));
                }
            }
            if (this._viewType == 2) {
                this.appendDcTypesLegend(legendList);
            } else if (this._viewType == 0) {
                legendList.add(new LegendElement(ComponentCategoryImage.getImage("Development Component (active)"), "Development Component (DC) in active state"));
                this.appendDcStatesLegend(legendList, false, true);
            } else {
                legendList.add(new LegendElement(ComponentCategoryImage.getImage("Development Component (inactive)"), "Development Component (DC) in inactive state"));
                this.appendDcStatesLegend(legendList, false, false);
            }
            this.appendDcMetaDataLegend(legendList);
            this.appendDtrLegend(legendList, this._viewType == 2);
        }
        return legendList.toArray(new ILegend[legendList.size()]);
    }

    private void appendDcTypesLegend(List legendList) {
        legendList.add(new LegendElement("Development Component (DC) Types:"));
        legendList.add(new LegendElement(ComponentTypeTreeViewer.getTypeImage(new ComponentType("sap.com", "Composite Application Services")), "Composite Application Services DC"));
        legendList.add(new LegendElement(ComponentTypeTreeViewer.getTypeImage(new ComponentType("sap.com", "Dictionary")), "Dictionary DC"));
        legendList.add(new LegendElement(ComponentTypeTreeViewer.getTypeImage(new ComponentType("sap.com", "J2EE")), "J2EE DC"));
        legendList.add(new LegendElement(ComponentTypeTreeViewer.getTypeImage(new ComponentType("sap.com", "J2EE Server Component")), "J2EE Server Component DC"));
        legendList.add(new LegendElement(ComponentTypeTreeViewer.getTypeImage(new ComponentType("sap.com", "Java")), "Java DC"));
        legendList.add(new LegendElement(ComponentTypeTreeViewer.getTypeImage(new ComponentType("sap.com", "Web Dynpro")), "Web Dynpro DC"));
        legendList.add(new LegendElement(ComponentTypeTreeViewer.getTypeImage(new ComponentType("sap.com", "Web Services")), "Web Services DC"));
        this.appendDcStatesLegend(legendList, true, false);
    }

    private void appendDcStatesLegend(List legendList, boolean isLocalDcView, boolean isActiveDcView) {
        legendList.add(new LegendElement(isLocalDcView ? "DC States (all examples for Dictionary DC):" : "DC States:"));
        Image image = isLocalDcView ? ComponentTypeTreeViewer.getTypeImage(new ComponentType("sap.com", "Dictionary")) : (isActiveDcView ? ComponentCategoryImage.getImage("Development Component (active)") : ComponentCategoryImage.getImage("Development Component (inactive)"));
        legendList.add(new LegendElement(DCGenericDecoratorProvider.getDecoratedImage(image, DCNodeSyncMode.LOCAL_ONLY, DCNodeSyncState.UPTODATE, false, false), "Local, not yet in repository"));
        legendList.add(new LegendElement(DCGenericDecoratorProvider.getDecoratedImage(image, DCNodeSyncMode.SYNCHED_AS_INACTIVE_SOURCE, DCNodeSyncState.UPTODATE, false, false), "Synced as inactive source (not necessarily up-to-date)"));
        legendList.add(new LegendElement(DCGenericDecoratorProvider.getDecoratedImage(image, DCNodeSyncMode.SYNCHED_AS_ACTIVE_SOURCE, DCNodeSyncState.UPTODATE, false, false), "Synced active state (archive or source)"));
        legendList.add(new LegendElement(DCGenericDecoratorProvider.getDecoratedImage(image, DCNodeSyncMode.SYNCHED_AS_ARCHIVE, DCNodeSyncState.OUTDATED, false, false), "Synced as archive (active), but outdated"));
        if (isLocalDcView) {
            legendList.add(new LegendElement(DCGenericDecoratorProvider.getDecoratedImage(image, DCNodeSyncMode.NOT_SYNCHED, DCNodeSyncState.UNKNOWN, true, false), "Modified locally, rebuild needed"));
            legendList.add(new LegendElement(DCGenericDecoratorProvider.getDecoratedImage(image, DCNodeSyncMode.NOT_SYNCHED, DCNodeSyncState.UNKNOWN, false, true), "Last build failed (rebuild will also fail)"));
        }
    }

    private void appendDcMetaDataLegend(List legendList) {
        legendList.add(new LegendElement("DC MetaData Objects:"));
        legendList.add(new LegendElement(ComponentCategoryImage.getImage("DC Definition"), "DC Definition"));
        legendList.add(new LegendElement(ComponentCategoryImage.getImage("Access List Folder"), "Access List"));
        legendList.add(new LegendElement(ComponentCategoryImage.getImage("Grant"), "Grant"));
        legendList.add(new LegendElement(ComponentCategoryImage.getImage("Child DC Folder"), "Child DCs"));
        legendList.add(new LegendElement(ComponentCategoryImage.getImage("DC Folders"), "Folders"));
        legendList.add(new LegendElement(ComponentCategoryImage.getImage("DC Folder"), "Folder"));
        legendList.add(new LegendElement(ComponentCategoryImage.getImage("Dependencies Folder"), "Used DCs"));
        legendList.add(new LegendElement(ComponentCategoryImage.getImage("Dependency"), "Used DC"));
        legendList.add(new LegendElement(ComponentCategoryImage.getImage("Public Parts Folder"), "Public Parts"));
        legendList.add(new LegendElement(ComponentCategoryImage.getImage("Public Part Purpose Compilation"), "Public Part for Compilation"));
        legendList.add(new LegendElement(ComponentCategoryImage.getImage("Public Part Purpose Assembly"), "Public Part for Assemply"));
        legendList.add(new LegendElement(ComponentCategoryImage.getImage("Public Part Purpose Infrastructure"), "Public Part for Infrastructure"));
        legendList.add(new LegendElement(ComponentCategoryImage.getImage("Package Folder"), "Packages"));
        legendList.add(new LegendElement(JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif"), "Package"));
        legendList.add(new LegendElement(ComponentCategoryImage.getImage("Entity Folder"), "Public Part Entities"));
        legendList.add(new LegendElement(ComponentCategoryImage.getImage("Public Part Entity"), "Public Part Entity"));
        legendList.add(new LegendElement(ComponentCategoryImage.getImage("Entity Reference Folder"), "Public Part Entity References"));
        legendList.add(new LegendElement(ComponentCategoryImage.getImage("Entity Reference"), "Public Part Entity Reference (re-publish PP entity of a used DC)"));
    }

    private void appendDtrLegend(List legendList, boolean isLocalDcView) {
        legendList.add(new LegendElement("Design Time Repository (DTR) Objects:"));
        legendList.add(new LegendElement("Folder", (Object)VfsFolderItemCategory.FOLDER, null, null, null, null));
        legendList.add(new LegendElement("File", (Object)VfsFolderItemCategory.FILE, null, null, null, null));
        legendList.add(new LegendElement("DTR Location States:"));
        if (!isLocalDcView) {
            legendList.add(new LegendElement("Not mounted, e.g. for folder", (Object)VfsFolderItemCategory.FOLDER, DAVDecorator.getLocationStateFilteredByPreferences((Object)"NOT_MOUNTED", null), null, null, null));
        }
        legendList.add(new LegendElement("Local, e.g. for file", (Object)VfsFolderItemCategory.FILE, DAVDecorator.getLocationStateFilteredByPreferences((Object)VfsFolderItemLocationState.LOCAL_ONLY, (Object)VfsFolderItemActivityState.NOT_CHECKED_OUT), (Object)VfsFolderItemActivityState.NOT_CHECKED_OUT, null, null));
        legendList.add(new LegendElement("Remote, e.g. for file", (Object)VfsFolderItemCategory.FILE, DAVDecorator.getLocationStateFilteredByPreferences((Object)VfsFolderItemLocationState.SERVER_ONLY, (Object)VfsFolderItemActivityState.NOT_CHECKED_OUT), (Object)VfsFolderItemActivityState.NOT_CHECKED_OUT, null, null));
        legendList.add(new LegendElement("Up-to-date, for file", (Object)VfsFolderItemCategory.FILE, DAVDecorator.getLocationStateFilteredByPreferences((Object)VfsFolderItemLocationState.SYNCED_TO_LATEST, (Object)VfsFolderItemActivityState.NOT_CHECKED_OUT), (Object)VfsFolderItemActivityState.NOT_CHECKED_OUT, null, null));
        legendList.add(new LegendElement("Outdated, for file", (Object)VfsFolderItemCategory.FILE, DAVDecorator.getLocationStateFilteredByPreferences((Object)VfsFolderItemLocationState.SYNCED_TO_FORMER, (Object)VfsFolderItemActivityState.NOT_CHECKED_OUT), (Object)VfsFolderItemActivityState.NOT_CHECKED_OUT, null, null));
        legendList.add(new LegendElement("DTR Activity States:"));
        legendList.add(new LegendElement("Checked-out for create, e.g. for folder", (Object)VfsFolderItemCategory.FOLDER, DAVDecorator.getLocationStateFilteredByPreferences((Object)VfsFolderItemLocationState.LOCAL_ONLY, (Object)VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE), (Object)VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE, null, null));
        legendList.add(new LegendElement("Checked-out for edit, e.g. for file", (Object)VfsFolderItemCategory.FILE, null, (Object)VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT, null, null));
        legendList.add(new LegendElement("Exclusive checked-out for edit, e.g. for file", (Object)VfsFolderItemCategory.FILE, null, (Object)VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT, (Object)"CHECKOUT_LOCK", null));
        legendList.add(new LegendElement("Checked-out for delete, e.g. for file", (Object)VfsFolderItemCategory.FILE, null, (Object)VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE, null, null));
        legendList.add(new LegendElement("Checked-out by other user, e.g. for file", (Object)VfsFolderItemCategory.FILE, null, null, (Object)"FOREIGN_CO", null));
        legendList.add(new LegendElement("Exclusive checked-out for edit by other user, e.g. for file", (Object)VfsFolderItemCategory.FILE, null, null, (Object)"FOREIGN_CO_EX", null));
        legendList.add(new LegendElement("Check-in conflict, e.g. for file, checked-out for create", (Object)VfsFolderItemCategory.FILE, (Object)"COLLISION", (Object)VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE, null, null));
    }

    private void appendInfrastructureServersLegend(List legendList) {
        legendList.add(new LegendElement("Infrastructure Servers:"));
        legendList.add(new LegendElement(ComponentCategoryImage.getImage("CBS"), "Component Build Server (CBS)"));
        legendList.add(new LegendElement(ComponentCategoryImage.getImage("DTR Server"), "Design Time Repository (DTR)"));
        legendList.add(new LegendElement(ComponentCategoryImage.getImage("Landscape Directory"), "Landscape Directory"));
        legendList.add(new LegendElement(ComponentCategoryImage.getImage("Name Server"), "Name Server"));
    }

    public String getViewId() {
        if (this.m_viewId == null) {
            if (this.m_config != null) {
                this.m_viewId = this.m_config.getAttribute("id");
            }
            if (this.m_viewId == null) {
                this.m_viewId = "";
            }
        }
        return this.m_viewId;
    }

    public String getViewName() {
        switch (this._viewType) {
            case 0: {
                return "Active DCs";
            }
            case 1: {
                return "Inactive DCs";
            }
            case 2: {
                return "Local DCs";
            }
        }
        return "";
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.m_config = config;
    }
}

