/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.preference;

import com.sap.ide.eclipse.component.devconf.DevConfManager;
import com.sap.ide.eclipse.component.devconf.DevConfValidator;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.preference.DevConfPreferenceDialog;
import com.sap.ide.eclipse.component.provider.preference.DisabledDirectoryFieldEditor;
import com.sap.ide.login.UserValidator;
import com.sap.lcr.api.cimclient.CIMClient;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.UnauthorizedUserException;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.util.ui.dialog.MessageDialog;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class DevConfPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String CONFIG_POOL_URL = "configPoolURL";
    private static final String CONFIG_POOL_ROOT_NAME = "configPoolRoot";
    private StringFieldEditor configPoolURL = null;
    private DisabledDirectoryFieldEditor configPoolRoot = null;
    private Label errorLabel = null;
    private Label errorImage = null;
    private Label errorLabel_2 = null;
    private Label errorImage_2 = null;
    private ResourceBundle labels = null;
    private static String configPoolRootOld = "";
    private Button button;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(ComponentProviderPlugin.getPlugin().getPreferenceStore());
    }

    private Composite createErrorArea(Composite ctrl, int index) {
        Composite labels = new Composite(ctrl, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        labels.setLayout((Layout)layout);
        GridData data = new GridData();
        labels.setLayoutData((Object)data);
        Label myErrorImage = new Label(labels, 64);
        myErrorImage.setImage(JFaceResources.getImageRegistry().get("dialog_message_error_image"));
        myErrorImage.setVisible(false);
        Label myErrorLabel = new Label(labels, 64);
        data = new GridData(768);
        myErrorLabel.setLayoutData((Object)data);
        if (index == 0) {
            this.errorImage = myErrorImage;
            this.errorLabel = myErrorLabel;
        } else {
            this.errorImage_2 = myErrorImage;
            this.errorLabel_2 = myErrorLabel;
        }
        return labels;
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        this.labels = ResourceBundle.getBundle("com.sap.ide.eclipse.component.provider.preference.label");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        new Label(composite, 0);
        Label firstLabel = new Label(composite, 0);
        new Label(composite, 0);
        firstLabel.setText(this.labels.getString("configPoolURL.description"));
        Composite errorComposite = this.createErrorArea(composite, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        errorComposite.setLayoutData((Object)gd);
        this.configPoolURL = new StringFieldEditor(CONFIG_POOL_URL, this.labels.getString(CONFIG_POOL_URL), composite);
        this.configPoolURL.setPreferenceStore(this.getPreferenceStore());
        this.configPoolURL.load();
        this.configPoolURL.getTextControl(composite).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                DevConfPreferencePage.this.dialogChanged();
            }
        });
        new Label(composite, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.button = new Button(composite, 0);
        this.button.setText("Ping server");
        this.button.setLayoutData((Object)gd);
        this.button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DevConfPreferencePage.this.ping();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        new Label(composite, 0);
        gd = new GridData();
        gd.horizontalSpan = 3;
        new Label(composite, 0).setLayoutData((Object)gd);
        errorComposite = this.createErrorArea(composite, 1);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        errorComposite.setLayoutData((Object)gd);
        this.dialogChanged();
        Label label = new Label(composite, 0);
        label.setText(this.labels.getString("configPoolRoot.description"));
        gd = new GridData();
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        this.configPoolRoot = new DisabledDirectoryFieldEditor(CONFIG_POOL_ROOT_NAME, this.labels.getString(CONFIG_POOL_ROOT_NAME), composite);
        this.configPoolRoot.setPreferenceStore(this.getPreferenceStore());
        this.configPoolRoot.load();
        if (this.configPoolRoot.getStringValue() == null || this.configPoolRoot.getStringValue().length() <= 0) {
            this.configPoolRoot.setStringValue(DevConfManager.DEVCONF_WORK_FOLDER);
        }
        configPoolRootOld = this.configPoolRoot.getStringValue();
        if (!DevConfManager.isRootMovable()) {
            this.configPoolRoot.setEnabled(composite, false);
        }
        this.configPoolRoot.getTextControl(composite).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IStatus status = DevConfPreferencePage.this.validateDTCPath(DevConfPreferencePage.this.configPoolRoot.getStringValue());
                switch (status.getSeverity()) {
                    case 0: {
                        if (DevConfPreferencePage.this.errorLabel_2 != null) {
                            DevConfPreferencePage.this.errorLabel_2.setText("");
                        }
                        if (DevConfPreferencePage.this.errorImage_2 == null) break;
                        DevConfPreferencePage.this.errorImage_2.setVisible(false);
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (DevConfPreferencePage.this.errorLabel_2 != null) {
                            DevConfPreferencePage.this.errorLabel_2.setText(status.getMessage());
                        }
                        if (DevConfPreferencePage.this.errorImage_2 == null) break;
                        DevConfPreferencePage.this.errorImage_2.setVisible(true);
                        break;
                    }
                }
            }
        });
        return composite;
    }

    private void dialogChanged() {
        String validationValue = this.validateInput();
        if (validationValue != null) {
            if (this.errorLabel != null) {
                this.errorLabel.setText(validationValue);
            }
            if (this.errorImage != null) {
                this.errorImage.setVisible(true);
            }
            if (this.button != null) {
                this.button.setEnabled(false);
            }
        } else {
            if (this.errorLabel != null) {
                this.errorLabel.setText("");
            }
            if (this.errorImage != null) {
                this.errorImage.setVisible(false);
            }
            if (this.button != null) {
                this.button.setEnabled(true);
            }
        }
    }

    public String validateInput() {
        String value;
        if (this.configPoolURL != null && ((value = this.configPoolURL.getStringValue()) == null || value.length() <= 0)) {
            return "URL is required";
        }
        return null;
    }

    private void ping() {
        String user = "";
        String password = "";
        String urlValue = null;
        if (UserValidator.isDefaultServerOnline()) {
            user = UserValidator.getDefaultServerData().getUser();
            password = UserValidator.getDefaultServerData().getPassword();
        }
        if (this.configPoolURL != null) {
            urlValue = this.configPoolURL.getStringValue().trim();
        }
        if (urlValue == null || urlValue.length() <= 0) {
            MessageDialog.showWarning((String)this.labels.getString("pingServer.title"), (String)this.labels.getString("pingServer.noURL.message"), (String)"");
            return;
        }
        URL url = null;
        try {
            url = new URL(urlValue);
        }
        catch (MalformedURLException e) {
            MessageDialog.showWarning((String)this.labels.getString("pingServer.title"), (String)this.labels.getString("pingServer.invalidURL.message"), (String)e.getMessage());
            return;
        }
        CIMClient client = null;
        try {
            client = DevConfManager.getCIMClient(url, user, password, UserValidator.getKeyStore());
        }
        catch (IOException e) {
            MessageDialog.showError((String)this.labels.getString("pingServer.title"), (String)this.labels.getString("pingServer.noClient.message"), (String)e.getMessage());
        }
        catch (CIMClientException e) {
            MessageDialog.showError((String)this.labels.getString("pingServer.title"), (String)this.labels.getString("pingServer.noClient.message"), (String)e.getMessage());
        }
        if (client == null) {
            return;
        }
        try {
            client.ping();
        }
        catch (CIMClientException e) {
            if (e instanceof UnauthorizedUserException && !UserValidator.isDefaultServerOnline()) {
                MessageDialog.showInfo((String)this.labels.getString("pingServer.title"), (String)this.labels.getString("pingServer.success.message"), (String)("URL: " + urlValue + "\nWarning:User authentication is not checked in offline mode."));
                return;
            }
            String message = e.getMessage();
            if (message.indexOf("500") > 0) {
                message = message + "\nThe Host Name should be full.\nCheck Proxy Settings for the Host.";
            }
            MessageDialog.showError((String)this.labels.getString("pingServer.title"), (String)this.labels.getString("pingServer.failed.message"), (String)message);
            return;
        }
        MessageDialog.showInfo((String)this.labels.getString("pingServer.title"), (String)this.labels.getString("pingServer.success.message"), (String)("URL: " + urlValue));
    }

    public static String getDevConfPoolURL() {
        String value = ComponentProviderPlugin.getPlugin().getPreferenceStore().getString(CONFIG_POOL_URL);
        if (value != null) {
            return value.trim();
        }
        return null;
    }

    public static String getDevConfPoolRoot() {
        String result = ComponentProviderPlugin.getPlugin().getPreferenceStore().getString(CONFIG_POOL_ROOT_NAME);
        if (result == null || result.trim().length() <= 0) {
            result = DevConfManager.DEVCONF_WORK_FOLDER;
        }
        if (!result.endsWith(File.separator)) {
            result = result + File.separator;
        }
        return result;
    }

    protected void performApply() {
        this.store();
        super.performApply();
    }

    public boolean performOk() {
        this.store();
        return super.performOk();
    }

    public void store() {
        if (this.configPoolURL != null) {
            this.configPoolURL.store();
        }
        if (this.configPoolRoot != null && this.configPoolRoot.isEnabled()) {
            if (!this.configPoolRoot.getStringValue().equalsIgnoreCase(configPoolRootOld) && this.validateDTCPath(this.configPoolRoot.getStringValue()).getSeverity() != 4) {
                this.configPoolRoot.store();
                DevConfManager.freeDevConfs();
                DevConfManager.initializeDevConfs();
                DevConfValidator.update();
            }
        } else {
            UserValidator.enableLoginButton();
        }
    }

    public IStatus validateDTCPath(String path) {
        if (path == null) {
            return new Status(4, "com.sap.ide.eclipse.component.provider", 0, "The Path has not to be empty.", null);
        }
        String eclipseRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString() + File.separator;
        String myPath = path.trim();
        if (!myPath.endsWith(File.separator)) {
            myPath = myPath + File.separator;
        }
        if (myPath.startsWith(eclipseRoot)) {
            return new Status(4, "com.sap.ide.eclipse.component.provider", 0, "The Path overlaps with Workspace Folder.", null);
        }
        if (myPath.length() > 50) {
            return new Status(2, "com.sap.ide.eclipse.component.provider", 0, "Use shorter path, to avoid path length problem.", null);
        }
        return new Status(0, "com.sap.ide.eclipse.component.provider", 0, "The Path has not to be empty.", null);
    }

    public static void popUpPage(Shell shell) {
        PreferenceManager pm = WorkbenchPlugin.getDefault().getPreferenceManager();
        if (pm != null) {
            DevConfPreferenceDialog d = new DevConfPreferenceDialog(shell, pm);
            d.create();
            WorkbenchHelp.setHelp((Control)d.getShell(), (String)"org.eclipse.ui.preference_dialog_context");
            d.open();
        }
    }
}

