/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.objects;

import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.objects.ComponentModelObject;
import com.sap.ide.eclipse.component.provider.objects.ComponentVfsModelObject;
import com.sap.ide.eclipse.component.provider.objects.DCModelObject;
import com.sap.ide.eclipse.component.provider.objects.DCProjectModelObject;
import com.sap.ide.eclipse.component.provider.objects.IComponentModelObject;
import com.sap.tc.devconf.ICompartmentNode;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.util.SelenaElementUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;

public class ComponentModelObjectMap {
    private static HashMap modelMap = new HashMap();
    private static HashMap projectMap = new HashMap();

    protected static void addModel(Model model, Object config) {
        UniqueName modelUin = model.getUniqueName();
        HashMap<UniqueName, ComponentModelObject> compMap = (HashMap<UniqueName, ComponentModelObject>)modelMap.get(modelUin);
        if (compMap == null) {
            compMap = new HashMap<UniqueName, ComponentModelObject>();
            modelMap.put(modelUin, compMap);
        }
        ComponentModelObject componentObject = new ComponentModelObject(null, config);
        compMap.put(modelUin, componentObject);
    }

    protected static void addComponentModelObject(Entity parent, UniqueName keyUin, Object addObject) {
        UniqueName modelUin = parent.getModel().getUniqueName();
        HashMap compMap = (HashMap)modelMap.get(modelUin);
        if (compMap != null) {
            compMap.put(keyUin, new ComponentModelObject(parent.getUniqueName(), addObject));
        }
    }

    protected static void addComponentVfsModelObject(Entity parent, UniqueName keyUin, Object addObject) {
        UniqueName modelUin = parent.getModel().getUniqueName();
        HashMap compMap = (HashMap)modelMap.get(modelUin);
        if (compMap != null) {
            compMap.put(keyUin, new ComponentVfsModelObject(parent.getUniqueName(), addObject));
        }
    }

    protected static void addComponentVfsModelObject(Entity parent, UniqueName keyUin, Object addObject, IVfsFolderItem vfsFolderItem) {
        UniqueName modelUin = parent.getModel().getUniqueName();
        HashMap compMap = (HashMap)modelMap.get(modelUin);
        if (compMap != null) {
            compMap.put(keyUin, new ComponentVfsModelObject(parent.getUniqueName(), addObject, vfsFolderItem));
        }
    }

    protected static void addDCModelObject(Entity parent, UniqueName keyUin, ICompartmentNode compNode, IDevelopmentComponentNode dcNode, UniqueName projectUin) {
        UniqueName modelUin = parent.getModel().getUniqueName();
        HashMap compMap = (HashMap)modelMap.get(modelUin);
        if (compMap != null) {
            compMap.put(keyUin, new DCModelObject(parent.getUniqueName(), compNode, dcNode, projectUin));
        }
    }

    protected static void addDCProjectModelObject(Entity parent, UniqueName keyUin, UniqueName dcUin, IProject project) {
        UniqueName modelUin = parent.getModel().getUniqueName();
        HashMap compMap = (HashMap)modelMap.get(modelUin);
        if (compMap != null) {
            projectMap.put(keyUin, new DCProjectModelObject(modelUin, parent.getUniqueName(), dcUin, project));
            ComponentModelObjectMap.addModel(ModelAccess.getModel((UniqueName)keyUin), null);
        }
    }

    protected static boolean containsUin(UniqueName modelUin, UniqueName keyUin) {
        HashMap compMap = (HashMap)modelMap.get(modelUin);
        if (compMap != null) {
            return compMap.containsKey(keyUin);
        }
        return false;
    }

    protected static boolean containsUin(Model model, UniqueName keyUin) {
        return ComponentModelObjectMap.containsUin(model.getUniqueName(), keyUin);
    }

    protected static boolean containsProjectUin(UniqueName projectUin) {
        return projectMap.containsKey(projectUin);
    }

    protected static IComponentModelObject getComponentModelObject(UniqueName modelUin, UniqueName keyUin) {
        if (modelUin == null || keyUin == null) {
            return null;
        }
        if (SelenaElementUtil.isProjectModelUniqueName((UniqueName)keyUin)) {
            return ComponentModelObjectMap.getDCProjectModelObject(keyUin);
        }
        HashMap compMap = (HashMap)modelMap.get(modelUin);
        if (compMap == null) {
            return null;
        }
        Object obj = compMap.get(keyUin);
        if (!(obj instanceof IComponentModelObject)) {
            return null;
        }
        return (IComponentModelObject)obj;
    }

    protected static IComponentModelObject getComponentModelObject(Element element) {
        if (element == null) {
            return null;
        }
        UniqueName modelUin = element.getModel().getUniqueName();
        UniqueName keyUin = element.getUniqueName();
        return ComponentModelObjectMap.getComponentModelObject(modelUin, keyUin);
    }

    protected static DCProjectModelObject getDCProjectModelObject(UniqueName keyUin) {
        return (DCProjectModelObject)projectMap.get(keyUin);
    }

    protected static UniqueName getDCProjectUniqueNameByDCUin(UniqueName valueUin, UniqueName configName) {
        Iterator values = projectMap.entrySet().iterator();
        while (values.hasNext()) {
            Map.Entry entry = values.next();
            DCProjectModelObject modelObject = (DCProjectModelObject)entry.getValue();
            if (!modelObject.getDCNodeUin().equals(valueUin)) continue;
            if (configName != null) {
                Model prjModel = ModelAccess.getModel((UniqueName)((UniqueName)entry.getKey()));
                Element configElement = ComponentUtil.getParentDevConfElement((Element)prjModel);
                if (configElement == null || !configName.equals(configElement.getUniqueName())) continue;
                return prjModel.getUniqueName();
            }
            return (UniqueName)entry.getKey();
        }
        return null;
    }

    protected static void deleteObject(UniqueName modelUin, Element element) {
        Object componentObject;
        UniqueName keyUin = element.getUniqueName();
        HashMap compMap = (HashMap)modelMap.get(modelUin);
        if (compMap != null && (componentObject = compMap.get(keyUin)) != null) {
            compMap.remove(keyUin);
        }
    }

    protected static void deleteObject(Model model, Element element) {
        ComponentModelObjectMap.deleteObject(model.getUniqueName(), element);
    }

    protected static void disposeModelMap(Model model) {
        modelMap.remove(model.getUniqueName());
    }

    protected static void disposeProjectMap() {
        projectMap.clear();
    }

    protected static void disposeAllObjectMaps() {
        modelMap.clear();
        projectMap.clear();
    }
}

