/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.listener;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.UpdateUtil;
import com.sap.tc.devconf.DevelopmentConfigurationFactory;
import com.tssap.dii.component.DCProjectInfo;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;

public class WorkspaceResourceListener
implements IResourceChangeListener {
    static WorkspaceResourceListener listener = null;
    protected List toIgnoreProjects = new ArrayList();
    private TracerI theTracer = TracingManager.getTracer(this.getClass());

    public static WorkspaceResourceListener getListener() {
        if (listener == null) {
            listener = new WorkspaceResourceListener();
        }
        return listener;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            IResourceDelta rsDelta = event.getDelta();
            if (rsDelta == null) {
                return;
            }
            IResourceDelta[] deltas = rsDelta.getAffectedChildren();
            if (deltas != null) {
                int i = 0;
                while (i < deltas.length) {
                    IProject prj;
                    IResource res = deltas[i].getResource();
                    if (res instanceof IProject && !this.toIgnoreProjects.contains(prj = (IProject)res) && prj.exists() && prj.isOpen() && DCProjectInfo.isDCProject((IProject)prj)) {
                        List list = this.getLeafResources(deltas[i]);
                        Iterator it = list.iterator();
                        while (it.hasNext()) {
                            IResourceDelta delta = (IResourceDelta)it.next();
                            IResource file = delta.getResource();
                            int kind = delta.getKind();
                            if (kind == 1 || kind == 4 && (delta.getFlags() & 0x100) > 1) {
                                DevelopmentConfigurationFactory.getInstance().getFileMonitor().notifyFileModified(file.getLocation().toOSString());
                            } else if (kind == 2) {
                                DevelopmentConfigurationFactory.getInstance().getFileMonitor().notifyFileDeleted(file.getLocation().toOSString());
                            }
                            UpdateUtil.specialFileCheck(file, kind);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Throwable ex) {
            Util.logExceptionMessage(this.theTracer, 3, "Resource Changed for DC failed", ex);
        }
    }

    public void addToIgnoreProject(IProject prj) {
        if (prj == null) {
            return;
        }
        List list = this.toIgnoreProjects;
        synchronized (list) {
            this.toIgnoreProjects.add(prj);
        }
    }

    public void removeToIgnoreProject(IProject prj) {
        if (prj == null) {
            return;
        }
        List list = this.toIgnoreProjects;
        synchronized (list) {
            this.toIgnoreProjects.remove(prj);
        }
    }

    private List getLeafResources(IResourceDelta delta) {
        ArrayList<IResourceDelta> resultList = new ArrayList<IResourceDelta>();
        if (delta == null) {
            return null;
        }
        ArrayList<IResourceDelta> list = new ArrayList<IResourceDelta>();
        list.add(delta);
        while (!list.isEmpty()) {
            list.remove(0);
            IResourceDelta[] deltas = delta.getAffectedChildren();
            if (deltas == null || deltas.length <= 0) {
                if (delta.getResource() != null) {
                    resultList.add(delta);
                }
            } else {
                list.addAll(Arrays.asList(deltas));
            }
            IResourceDelta iResourceDelta = delta = list.size() > 0 ? (IResourceDelta)list.get(0) : null;
        }
        return resultList;
    }
}

