/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.listener;

import com.sap.cms.client.ideAPI.CmsConfigurationFactory;
import com.sap.cms.client.ideAPI.CmsConfigurationIF;
import com.sap.cms.util.exception.CMSUnexpectedException;
import com.sap.cms.util.exception.client.CMSClientDTCDeletedException;
import com.sap.cms.util.exception.client.CMSClientDTCNotFoundException;
import com.sap.cms.util.exception.client.CMSClientVersionConflictException;
import com.sap.cms.util.exception.misc.CMSPermissionDeniedException;
import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.devconf.DevConfManager;
import com.sap.ide.eclipse.component.provider.ComponentMetaDataUtil;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.login.LoginListenerWithProgress;
import com.sap.ide.login.UserValidator;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.selena.impl.model.elements.ModelImpl;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DevConfLoginListener
implements LoginListenerWithProgress {
    private TracerI theTracer = TracingManager.getTracer(this.getClass());

    public void loginPerformed(UserValidator.Data loginData, IProgressMonitor monitor) {
        if (loginData.isOnline()) {
            Model offlineModel = ModelAccess.getModel((UniqueName)ComponentMetaDataUtil.createDevConfLoginName());
            if (offlineModel != null && offlineModel instanceof ModelImpl) {
                ((ModelImpl)offlineModel).delete();
            }
        } else {
            this.theTracer.debug("Removing Online DevConfig Models");
            Enumeration enumeration = ModelAccess.models();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    ModelImpl model;
                    Object obj = enumeration.nextElement();
                    if (!(obj instanceof ModelImpl) || !"com.sap.ide.eclipse.component".equals((model = (ModelImpl)obj).getUniqueName().getDomain())) continue;
                    this.theTracer.debug("Removing Model: " + model.getUniqueName());
                    model.delete();
                }
            }
        }
        DevConfManager.initializeDevConfs(true, monitor);
        if (loginData.isOnline()) {
            this.updateDevConfigVersions(DevConfManager.getInstalledDevConfs(), loginData);
        }
    }

    private void updateDevConfigVersions(List installedDevConfs, UserValidator.Data loginData) {
        if (installedDevConfs == null) {
            return;
        }
        String resultMessage = "";
        Iterator it = installedDevConfs.iterator();
        while (it.hasNext()) {
            IDevelopmentConfiguration config = (IDevelopmentConfiguration)it.next();
            if (config.isLocalConfiguration()) continue;
            String oldVersion = config.getConfigurationData().getConfigVersion();
            String cmsUrl = config.getConfigurationData().getCMS();
            String configId = config.getConfigurationData().getLocation();
            if (cmsUrl == null || configId == null) continue;
            String newVersion = null;
            try {
                URL url = new URL(cmsUrl);
                CmsConfigurationIF cmsConfiguration = CmsConfigurationFactory.getInstance().createCmsConfiguration(url, loginData.getUser(), loginData.getPassword(), UserValidator.getKeyStore());
                newVersion = cmsConfiguration.getActualDTCVersion(configId);
            }
            catch (CMSClientDTCNotFoundException e) {
                Util.logExceptionMessage(this.theTracer, 3, "get Version from CMS for DevConfig " + config.getConfigurationRootFolder() + "failed", e);
            }
            catch (CMSClientDTCDeletedException e) {
                Util.logExceptionMessage(this.theTracer, 3, "get Version from CMS for DevConfig " + config.getConfigurationRootFolder() + "failed", e);
            }
            catch (CMSPermissionDeniedException e) {
                Util.logExceptionMessage(this.theTracer, 3, "get Version from CMS for DevConfig " + config.getConfigurationRootFolder() + "failed", e);
            }
            catch (CMSUnexpectedException e) {
                Util.logExceptionMessage(this.theTracer, 3, "get Version from CMS for DevConfig " + config.getConfigurationRootFolder() + "failed", e);
            }
            catch (MalformedURLException e) {
                Util.logExceptionMessage(this.theTracer, 3, "get Version from CMS for DevConfig " + config.getConfigurationRootFolder() + "failed", e);
            }
            catch (CMSClientVersionConflictException e) {
                Util.logExceptionMessage(this.theTracer, 3, "get Version from CMS for DevConfig " + config.getConfigurationRootFolder() + "failed", e);
                continue;
            }
            if (newVersion == null || oldVersion.compareTo(newVersion) == 0) continue;
            resultMessage = resultMessage + "The Version " + newVersion + " of Devlopment Configuration " + ComponentMetaDataUtil.getNumberedDevConfigName(config) + " (Version:" + oldVersion + ") is now available\n";
        }
        if (!"".equals(resultMessage)) {
            final String message = resultMessage + "For Updating of Development Configurations you have to remove and import them.";
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openInformation((Shell)ComponentProviderPlugin.getPlugin().getMyShell(), (String)"Outdated Development Configuration(s)", (String)message);
                }
            });
        }
    }
}

