/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.listener;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.dcmdcommons.resources.MessageUtil;
import com.sap.ide.eclipse.component.provider.UpdateUtil;
import com.sap.ide.eclipse.component.provider.actions.dc.WorkerThreadConsistency;
import com.sap.tc.devconf.DCActivityState;
import com.sap.tc.devconf.DCEventType;
import com.sap.tc.devconf.DCMessageType;
import com.sap.tc.devconf.DCNodeSyncMode;
import com.sap.tc.devconf.DCNodeSyncState;
import com.sap.tc.devconf.DefaultDevConfListener;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDCMessage;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevConfListener;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.File;
import java.io.FileInputStream;

public class DevConfListener
extends DefaultDevConfListener {
    private static DevConfListener singleton;
    protected static TracerI theTracer;
    private MessageUtil theMessageUtil = MessageUtil.getInstance("com.sap.ide.eclipse.component.dcmdcommons.resources.messages");
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$provider$listener$DevConfListener;

    public static DevConfListener getDevConfListener() {
        if (singleton == null) {
            singleton = new DevConfListener();
        }
        return singleton;
    }

    public void onDCSyncModeChanged(IDevelopmentComponentNode dcNode, DCNodeSyncMode oldMode) {
        if (WorkerThreadConsistency.isWorkerThreadActive()) {
            WorkerThreadConsistency.onDCSyncModeChanged((IDevConfListener)this, dcNode, oldMode);
            return;
        }
        DCNodeSyncMode newMode = dcNode.getNodeSyncMode();
        if ((oldMode.equals(DCNodeSyncMode.SYNCHED_AS_ACTIVE_SOURCE) || oldMode.equals(DCNodeSyncMode.SYNCHED_AS_INACTIVE_SOURCE) || oldMode.equals(DCNodeSyncMode.SYNCHED_AS_ARCHIVE)) && newMode.equals(DCNodeSyncMode.NOT_SYNCHED)) {
            UpdateUtil.updateDC(dcNode, ModelDeltaNodeKind.DELETED);
        } else if (oldMode.equals(DCNodeSyncMode.NOT_SYNCHED) && (newMode.equals(DCNodeSyncMode.SYNCHED_AS_ACTIVE_SOURCE) || newMode.equals(DCNodeSyncMode.SYNCHED_AS_INACTIVE_SOURCE) || newMode.equals(DCNodeSyncMode.SYNCHED_AS_ARCHIVE))) {
            UpdateUtil.updateDC(dcNode, ModelDeltaNodeKind.NEW);
        } else {
            UpdateUtil.updateDC(dcNode, ModelDeltaNodeKind.CHANGED);
        }
    }

    public void onDCSyncStateChanged(IDevelopmentComponentNode dcNode, DCNodeSyncState oldMode) {
        if (WorkerThreadConsistency.isWorkerThreadActive()) {
            WorkerThreadConsistency.onDCSyncStateChanged((IDevConfListener)this, dcNode, oldMode);
            return;
        }
        UpdateUtil.updateDC(dcNode, ModelDeltaNodeKind.CHANGED);
    }

    public void onDCActivityStateChanged(IDevelopmentComponentNode dcNode, DCActivityState oldState) {
        if (WorkerThreadConsistency.isWorkerThreadActive()) {
            WorkerThreadConsistency.onDCActivityStateChanged((IDevConfListener)this, dcNode, oldState);
            return;
        }
        UpdateUtil.updateDC(dcNode, ModelDeltaNodeKind.CHANGED);
    }

    public void onDCsBuildStatusChanged(IDevelopmentComponentNode[] dirtyDCs) {
        if (WorkerThreadConsistency.isWorkerThreadActive()) {
            WorkerThreadConsistency.onDCsBuildStatusChanged((IDevConfListener)this, dirtyDCs);
            return;
        }
        int i = 0;
        while (i < dirtyDCs.length) {
            IDevelopmentComponentNode dirtyDC = dirtyDCs[i];
            UpdateUtil.updateDC(dirtyDC, ModelDeltaNodeKind.CHANGED);
            ++i;
        }
    }

    public void onDCDeleted(IDevelopmentComponentNode dcNode) {
        if (WorkerThreadConsistency.isWorkerThreadActive()) {
            WorkerThreadConsistency.onDCDeleted((IDevConfListener)this, dcNode);
            return;
        }
        UpdateUtil.updateDC(dcNode, ModelDeltaNodeKind.DELETED);
    }

    public void onDCCreated(IDevelopmentComponentNode dcNode) {
        if (WorkerThreadConsistency.isWorkerThreadActive()) {
            WorkerThreadConsistency.onDCCreated((IDevConfListener)this, dcNode);
            return;
        }
        UpdateUtil.updateDC(dcNode, ModelDeltaNodeKind.NEW);
    }

    public void onDCChanged(IDevelopmentComponentNode dcNode) {
        if (WorkerThreadConsistency.isWorkerThreadActive()) {
            WorkerThreadConsistency.onDCChanged((IDevConfListener)this, dcNode);
            return;
        }
        UpdateUtil.updateDC(dcNode, ModelDeltaNodeKind.TOTALLY_CHANGED);
    }

    public void dcMessage(IDCMessage message) {
        if (message == null || DCEventType.CHECK_REFERENCE.equals(message.getEventType())) {
            return;
        }
        String buildLog = null;
        if (DCEventType.BUILD_FINISHED.equals(message.getEventType())) {
            buildLog = DevConfListener.getBuildLog(message.getDC(), message.getBuildVariant());
        }
        if ("".equals(buildLog)) {
            buildLog = null;
        }
        String msg = this.theMessageUtil.format("Console.Message.Default.DC", new Object[]{message.getDC() != null ? message.getDC().getName() : "", message.getText()});
        if (buildLog != null) {
            msg = msg + "\n\n------------------------------------- Build log ------------------------------------------------------" + buildLog;
        }
        if (DCMessageType.INFO.equals(message.getMessageType())) {
            theTracer.userOut("Development Component", 4, msg);
        } else if (DCMessageType.WARNING.equals(message.getMessageType())) {
            Util.showUserOutputViewer();
            theTracer.userOut("Development Component", 3, msg);
        } else if (DCMessageType.ERROR.equals(message.getMessageType())) {
            Util.showUserOutputViewer();
            theTracer.userOut("Development Component", 2, msg);
        } else {
            theTracer.userOut("Development Component", 4, msg);
        }
    }

    private static String getBuildLog(IDevelopmentComponentNode dcNode, String buildVariant) {
        File aLogFile;
        IDevelopmentConfiguration config;
        IDCProxy dcProxy = null;
        try {
            dcProxy = dcNode.getDCProxy();
        }
        catch (DevConfigException ex) {
            Util.logExceptionMessage(theTracer, 3, "get DC Proxy failed", ex);
        }
        if (dcProxy != null && (config = dcProxy.getDevelopmentConfiguration()) != null && (aLogFile = config.getBuildLogFile(dcNode.getCompartmentName(), dcProxy.getVendor(), dcProxy.getName(), buildVariant)) != null && aLogFile.exists()) {
            try {
                FileInputStream file = new FileInputStream(aLogFile);
                byte[] b = new byte[file.available()];
                file.read(b);
                file.close();
                String fileContent = new String(b);
                return "\n" + fileContent;
            }
            catch (Throwable e) {
                Util.logExceptionMessage(theTracer, 3, "get Build Log failed", e);
            }
        }
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$provider$listener$DevConfListener == null ? (class$com$sap$ide$eclipse$component$provider$listener$DevConfListener = DevConfListener.class$("com.sap.ide.eclipse.component.provider.listener.DevConfListener")) : class$com$sap$ide$eclipse$component$provider$listener$DevConfListener));
    }
}

