/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.listener;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.login.UserValidator;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.OfflineException;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.VersionedFileSystemFactory;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.Iterator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;

public class DevConfJumpActivitiesListener
implements ISelectionChangedListener {
    protected static ComponentProviderPlugin myPlugin = ComponentProviderPlugin.getPlugin();
    private TracerI theTracer = TracingManager.getTracer(this.getClass());

    public void selectionChanged(SelectionChangedEvent event) {
        IClient client;
        if (!UserValidator.isDefaultServerOnline()) {
            return;
        }
        ISelection selection = event.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        if (1 != ((IStructuredSelection)selection).size()) {
            return;
        }
        Object object = ((IStructuredSelection)selection).getFirstElement();
        if (!(object instanceof Element)) {
            return;
        }
        IDevelopmentConfiguration config = ComponentUtil.getParentDevConf((Element)object);
        if (config == null) {
            return;
        }
        IClient dtrClient = null;
        try {
            if (!config.isInOfflineMode()) {
                dtrClient = config.getDTRClient();
            }
        }
        catch (OfflineException e) {
            Util.logExceptionMessage(this.theTracer, 3, "Getting DTR Client failed", e);
        }
        if (dtrClient == null) {
            return;
        }
        final IConfiguration conf = Configuration.getConfiguration();
        Iterator clients = conf.clients();
        IClient tempClient = null;
        while (clients.hasNext()) {
            client = (IClient)clients.next();
            if (!dtrClient.equals(client)) continue;
            tempClient = client;
            break;
        }
        if (tempClient == null) {
            return;
        }
        client = tempClient;
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                boolean successful = true;
                IWorkbenchPartSite site = myPlugin.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite();
                if (!(site instanceof IViewSite)) {
                    return;
                }
                IViewSite viewSite = (IViewSite)site;
                viewSite.getActionBars().getStatusLineManager().setErrorMessage(null);
                try {
                    if (VersionedFileSystemFactory.getVersionedFileSystemManager((IVfsContext)client.getContext()) != null) {
                        conf.setActiveClient(client);
                    } else {
                        successful = false;
                    }
                }
                catch (VfsException x) {
                    successful = false;
                    Util.logExceptionMessage(DevConfJumpActivitiesListener.this.theTracer, 3, "Jump to Development Configuration Activities failed", x);
                }
                if (!successful) {
                    viewSite.getActionBars().getStatusLineManager().setErrorMessage("Communication Error: Could not initialize the DTR client \"" + client.getName() + "\"!");
                }
            }
        });
    }
}

