/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.listener;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.ide.login.UserValidator;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.SyncException;
import com.tssap.dii.component.DCUtil;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;

public class DCProjectMoveDeleteHook
implements IMoveDeleteHook {
    protected TracerI theTracer = TracingManager.getTracer(this.getClass());

    public boolean deleteFile(IResourceTree tree, IFile file, int updateFlags, IProgressMonitor monitor) {
        return false;
    }

    public boolean deleteFolder(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor monitor) {
        return false;
    }

    public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
        IDevelopmentComponentNode dcNode;
        if (!DCUtil.isDCProject((IProject)project)) {
            return false;
        }
        if ((updateFlags & 4) == 0) {
            return false;
        }
        final String projectName = project.getName();
        monitor.setTaskName("Deleting DC Project ...");
        IDCExtendedProject dcProject = null;
        try {
            dcProject = (IDCExtendedProject)project.getNature("com.sap.ide.eclipse.component.provider.dcnature");
        }
        catch (CoreException e) {
            Util.logExceptionMessage(this.theTracer, 2, "get DC Project failed", e);
        }
        IDevelopmentComponentNode iDevelopmentComponentNode = dcNode = dcProject != null ? dcProject.getDCNode() : null;
        if (dcNode != null && dcNode.isSynchedAsSource()) {
            if (!UserValidator.isDefaultServerOnline()) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        UserValidator.getDefaultServerData((int)UserValidator.USER_LOGIN, null);
                    }
                });
            }
            if (!UserValidator.isDefaultServerOnline()) {
                return true;
            }
            monitor.subTask(project.getName() + ": romoving DC from Client ...");
            try {
                dcNode.unsync();
            }
            catch (SyncException e) {
                Util.logExceptionMessage(this.theTracer, 2, "Unsync for " + project.getName() + " failed", e);
                final SyncException ex = e;
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        Util.showException(ex, "Delete DC Project failed", "Deltion from Client for DC Project " + projectName + " failed", null);
                    }
                });
                return true;
            }
            monitor.subTask("");
            try {
                project.delete(updateFlags, monitor);
            }
            catch (CoreException e) {
                Util.logExceptionMessage(this.theTracer, 2, "Unsync for " + project.getName() + " failed", e);
                final CoreException ex = e;
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        Util.showException(ex, "Delete DC Project failed", "Eclipse Delete for " + projectName + " failed", null);
                    }
                });
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean moveFile(IResourceTree tree, IFile source, IFile destination, int updateFlags, IProgressMonitor monitor) {
        return false;
    }

    public boolean moveFolder(IResourceTree tree, IFolder source, IFolder destination, int updateFlags, IProgressMonitor monitor) {
        return false;
    }

    public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
        return true;
    }
}

