/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.actions.namereservation;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.UpdateUtil;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.ide.eclipse.component.provider.objects.PackageObject;
import com.sap.ide.eclipse.component.provider.ui.message.ComponentProviderMessages;
import com.sap.ide.eclipse.dii.component.PackageUtil;
import com.sap.ide.eclipse.dii.namereservation.NameServerUtil;
import com.sap.lcr.namealloc.NameAllocator;
import com.sap.lcr.namealloc.api.AllocationState;
import com.sap.lcr.namealloc.api.CommunicationFailureException;
import com.sap.lcr.namealloc.api.NameNotFoundException;
import com.sap.lcr.namealloc.api.NotOwnerException;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import javax.naming.CompoundName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;

public class RevertActionImpl
extends Action {
    private Element element;
    private TracerI theTracer = TracingManager.getTracer(((Object)((Object)this)).getClass());

    public RevertActionImpl(Element element) {
        this.element = element;
    }

    public void run() {
        AllocationState state = null;
        Shell shell = ComponentProviderPlugin.getPlugin().getMyShell();
        NameAllocator nameAlloc = null;
        try {
            nameAlloc = NameServerUtil.getNameAllocator((Element)this.element);
        }
        catch (Throwable e) {
            Util.logExceptionMessage(this.theTracer, 3, "Getting Name allocator failed", e);
            Util.showException(e, shell);
        }
        if (nameAlloc == null) {
            return;
        }
        Object obj = ObjectUtil.getComponentObject(this.element);
        PackageObject pack = null;
        if (obj instanceof PackageObject) {
            pack = (PackageObject)obj;
        }
        IVfsFile packFile = null;
        try {
            packFile = PackageUtil.getVFSPackageFile((IPackageFragment)pack.getFragment());
        }
        catch (VfsException e) {
            Util.logExceptionMessage(this.theTracer, 3, "Getting package representing VFS File failed", e);
        }
        IFile iFile = PackageUtil.getPackageFile((IPackageFragment)pack.getFragment());
        CompoundName packageName = PackageUtil.getPackageName((String)this.element.getUniqueName().getName(), (NameAllocator)nameAlloc);
        try {
            state = nameAlloc.getAllocationState("SAP_DesignTimePackage", packageName);
        }
        catch (CommunicationFailureException e) {
            Util.logExceptionMessage(this.theTracer, 3, "Getting package Allocation State failed", e);
        }
        catch (NameNotFoundException e) {
            Util.logExceptionMessage(this.theTracer, 3, "Getting package Allocation State failed", e);
        }
        if (state != null && state.getReservationKey() != null) {
            try {
                state = nameAlloc.revert("SAP_DesignTimePackage", packageName, state.getReservationKey());
            }
            catch (CommunicationFailureException e) {
                Util.logExceptionMessage(this.theTracer, 2, "Reverting package Name Reservation failed", e);
                Util.showException(e, "Error", ComponentProviderMessages.getString("nameReservation.error"), shell);
                return;
            }
            catch (NameNotFoundException e) {
                Util.logExceptionMessage(this.theTracer, 3, "Reverting package Name Reservation failed", e);
            }
            catch (NotOwnerException e) {
                Util.logExceptionMessage(this.theTracer, 2, "Reverting package Name Reservation failed", e);
                Util.showException(e, "error", ComponentProviderMessages.getString("nameReservation.error"), shell);
                return;
            }
            if (packFile != null) {
                if (!VfsFolderItemActivityState.NOT_CHECKED_OUT.equals(packFile.getActivityState()) && !VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE.equals(packFile.getActivityState())) {
                    try {
                        packFile.uncheckout();
                    }
                    catch (VfsException e) {
                        Util.logExceptionMessage(this.theTracer, 2, "Reverting package Name Reservation failed", e);
                        Util.showException(e, "Error", ComponentProviderMessages.getString("nameReservationRevert.dtr.error"), shell);
                        return;
                    }
                }
                if (VfsFolderItemLocationState.LOCAL_ONLY.equals(packFile.getLocationState())) {
                    packFile.getLocalFile().delete();
                } else if (VfsFolderItemActivityState.NOT_CHECKED_OUT.equals(packFile.getActivityState())) {
                    try {
                        NameServerUtil.removeFile((IVfsFile)packFile, (Shell)shell);
                    }
                    catch (VfsException e) {
                        Util.logExceptionMessage(this.theTracer, 2, "Reverting package Name Reservation failed", e);
                        Util.showException(e, "Error", ComponentProviderMessages.getString("nameReservationRevert.dtr.error"), shell);
                        return;
                    }
                }
            }
        }
        if (iFile != null) {
            try {
                iFile.refreshLocal(0, null);
            }
            catch (CoreException e) {
                Util.logExceptionMessage(this.theTracer, 3, "Refreshing package name reservation file failed", e);
            }
        }
        if (pack != null) {
            pack.setState(state);
        }
        UpdateUtil.updateElement(this.element, ModelDeltaNodeKind.CHANGED);
    }
}

