/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.actions.namereservation;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.eclipse.component.provider.actions.namereservation.AbstractNameReservationAction;
import com.sap.ide.eclipse.component.provider.actions.namereservation.RevertActionImpl;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.ide.eclipse.component.provider.objects.PackageObject;
import com.sap.ide.eclipse.dii.component.PackageUtil;
import com.sap.ide.eclipse.dii.namereservation.NameServerUtil;
import com.sap.ide.login.UserValidator;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.action.ICategory;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.action.IAction;

public class RevertAction
extends AbstractNameReservationAction {
    private TracerI theTracer = TracingManager.getTracer(this.getClass());

    public ICategory getCategory() {
        return ComponentCategoryImage.CATEGORY__NAME_RESERVATION_REVERT;
    }

    public boolean isEnabled(Element element) {
        if (!UserValidator.isDefaultServerOnline()) {
            return false;
        }
        Object obj = ObjectUtil.getComponentObject(element);
        if (obj instanceof PackageObject) {
            PackageObject pack = (PackageObject)obj;
            if (pack.getState() == null) {
                return false;
            }
            if (pack.getState().isReservedPreliminary()) {
                IPackageFragment resource = pack.getFragment();
                IVfsFile file = null;
                try {
                    file = PackageUtil.getVFSPackageFile((IPackageFragment)resource);
                }
                catch (VfsException e) {
                    Util.logExceptionMessage(this.theTracer, 3, "Getting representing VFS File failed", e);
                }
                if (file == null) {
                    return false;
                }
                if (NameServerUtil.isNamereservationSetted((IVfsFile)file)) {
                    return !file.isDeleted();
                }
                return false;
            }
        }
        return false;
    }

    protected IAction getReservationAction(Element element) {
        return new RevertActionImpl(element);
    }

    public boolean isAvailable(Element element) {
        if (!"com.sap.ide.eclipse.component.DCMetaData.Package".equals(element.getUniqueName().getSubDomain())) {
            return false;
        }
        try {
            if (NameServerUtil.getNameAllocator((Element)element) != null) {
                return true;
            }
        }
        catch (Throwable e) {
            Util.logExceptionMessage(this.theTracer, 3, "Get Name Allocator failed", e);
        }
        return super.isAvailable(element);
    }
}

