/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.actions.namereservation;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.UpdateUtil;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.ide.eclipse.component.provider.objects.PackageObject;
import com.sap.ide.eclipse.component.provider.ui.message.ComponentProviderMessages;
import com.sap.ide.eclipse.dii.component.PackageUtil;
import com.sap.ide.eclipse.dii.namereservation.NameServerUtil;
import com.sap.lcr.namealloc.NameAllocator;
import com.sap.lcr.namealloc.api.AllocationState;
import com.sap.lcr.namealloc.api.CommunicationFailureException;
import com.sap.lcr.namealloc.api.NameSyntaxViolation;
import com.sap.lcr.namealloc.api.NotOwnerException;
import com.sap.lcr.namealloc.api.ReservedBeforeException;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import javax.naming.CompoundName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ProvisionalReservationActionImpl
extends Action {
    private Element element;
    private static TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$provider$actions$namereservation$ProvisionalReservationActionImpl == null ? (class$com$sap$ide$eclipse$component$provider$actions$namereservation$ProvisionalReservationActionImpl = ProvisionalReservationActionImpl.class$("com.sap.ide.eclipse.component.provider.actions.namereservation.ProvisionalReservationActionImpl")) : class$com$sap$ide$eclipse$component$provider$actions$namereservation$ProvisionalReservationActionImpl));
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$provider$actions$namereservation$ProvisionalReservationActionImpl;

    public ProvisionalReservationActionImpl(Element element) {
        this.element = element;
    }

    public void run() {
        AllocationState state = null;
        Shell shell = ComponentProviderPlugin.getPlugin().getMyShell();
        String name = this.element.getUniqueName().getName();
        NameAllocator nameAlloc = null;
        IDevelopmentComponentNode dcNode = ComponentUtil.getParentDCNode(this.element);
        try {
            nameAlloc = NameServerUtil.getNameAllocator((Element)this.element);
        }
        catch (Throwable e) {
            Util.showException(e, shell);
        }
        if (nameAlloc != null) {
            CompoundName packageName = PackageUtil.getPackageName((String)name, (NameAllocator)nameAlloc);
            Object obj = ObjectUtil.getComponentObject(this.element);
            if (obj instanceof PackageObject) {
                PackageObject pack = (PackageObject)obj;
                IPackageFragment resource = pack.getFragment();
                if (!PackageUtil.hasPackageFile((IPackageFragment)resource)) {
                    try {
                        if (!PackageUtil.createPackageFile((IPackageFragment)resource)) {
                            MessageDialog.openError((Shell)shell, (String)ComponentProviderMessages.getString("nameReservation.error"), (String)ComponentProviderMessages.format("packageFileCreation.error", new Object[]{""}));
                            return;
                        }
                    }
                    catch (VfsException e) {
                        MessageDialog.openError((Shell)shell, (String)ComponentProviderMessages.getString("nameReservation.error"), (String)(ComponentProviderMessages.format("packageFileCreation.error", new Object[]{""}) + "\n" + ((Object)((Object)e)).getClass() + " " + (e.getMessage() != null ? e.getMessage() : "")));
                        return;
                    }
                }
                IVfsFile file = null;
                try {
                    file = PackageUtil.getVFSPackageFile((IPackageFragment)resource);
                }
                catch (VfsException e) {
                    Util.showException(e, shell);
                    ProvisionalReservationActionImpl.cleanUp(resource);
                    return;
                }
                if (file == null) {
                    ProvisionalReservationActionImpl.cleanUp(resource);
                    MessageDialog.openError((Shell)shell, (String)ComponentProviderMessages.getString("nameReservation.error"), (String)ComponentProviderMessages.getString("dtrAccessDenied.nr.error"));
                    return;
                }
                if (!VfsFolderItemActivityState.NOT_CHECKED_OUT.equals(file.getActivityState())) {
                    String fileName = PackageUtil.getPackageFile((IPackageFragment)pack.getFragment()).getFullPath().toOSString();
                    MessageDialog.openError((Shell)shell, (String)ComponentProviderMessages.getString("nameReservation.error"), (String)ComponentProviderMessages.format("packageFileInActivity.error", new String[]{fileName}));
                    return;
                }
                String user = nameAlloc.getMyConnectUser();
                try {
                    state = nameAlloc.reservePreliminary("SAP_DesignTimePackage", packageName, user, dcNode != null ? "Package reserved in DC " + dcNode.getVendor() + "/" + dcNode.getName() : "PACKAGE RESERVATION", null, false, null, null);
                }
                catch (NameSyntaxViolation e) {
                    Util.logExceptionMessage(theTracer, 3, "Name Reservation failed", e);
                    String prefixes = null;
                    try {
                        prefixes = NameServerUtil.PrefixesToString((CompoundName[])nameAlloc.getAllowedPrefixList("SAP_DesignTimePackage"));
                    }
                    catch (CommunicationFailureException ex) {
                        Util.logExceptionMessage(theTracer, 3, "List prefixes failed", ex);
                    }
                    String message = e.getMessage();
                    if (message == null) {
                        message = ComponentProviderMessages.getString("NameSyntaxViolationPackage.error");
                    }
                    if (prefixes != null) {
                        message = message + ComponentProviderMessages.format("NameSyntaxViolationPackage.error", new String[]{name, prefixes});
                    }
                    MessageDialog.openError((Shell)shell, (String)ComponentProviderMessages.getString("nameServer.error"), (String)message);
                }
                catch (NotOwnerException e) {
                    if (e.isCausedByLockedBranch()) {
                        state = ProvisionalReservationActionImpl.retryReserve(shell, name, nameAlloc, packageName, user, false, e);
                    } else {
                        Util.logExceptionMessage(theTracer, 3, "Name Reservation failed", e);
                        Util.showException(e, "Error", ComponentProviderMessages.getString("nameServer.error"), shell);
                    }
                }
                catch (ReservedBeforeException e) {
                    if (e.isCausedByLockedBranch()) {
                        state = ProvisionalReservationActionImpl.retryReserve(shell, name, nameAlloc, packageName, user, false, e);
                    } else {
                        Util.logExceptionMessage(theTracer, 3, "Name Reservation failed", e);
                        Util.showException(e, "Error", ComponentProviderMessages.getString("nameServer.error"), shell);
                    }
                }
                catch (Throwable e) {
                    Util.logExceptionMessage(theTracer, 3, "Name Reservation failed", e);
                    Util.showException(e, "Error", ComponentProviderMessages.getString("nameServer.error"), shell);
                }
                if (state == null || state.getReservationKey() == null) {
                    ProvisionalReservationActionImpl.cleanUp(resource);
                    return;
                }
                String url = null;
                boolean reservedInDTR = false;
                try {
                    url = NameServerUtil.getURL((NameAllocator)nameAlloc);
                }
                catch (MalformedURLException e) {
                    Util.logExceptionMessage(theTracer, 3, "Getting Name Sever URL failed", e);
                    Util.showException(e, "Error", ComponentProviderMessages.getString("nameReservation.error"), shell);
                }
                try {
                    if (url != null) {
                        reservedInDTR = NameServerUtil.reserveInDTR((IVfsFile)file, (String)"SAP_DesignTimePackage", (String)name, (String)state.getReservationKey(), (String)url, (Shell)shell);
                    }
                }
                catch (VfsException e) {
                    Util.logExceptionMessage(theTracer, 3, "Setting DTR Property failed", e);
                    Util.showException(e, "Error", ComponentProviderMessages.getString("nameReservation.error"), shell);
                }
                catch (Exception e) {
                    Util.logExceptionMessage(theTracer, 3, "Setting DTR Property failed", e);
                    Util.showException(e, "Error", ComponentProviderMessages.getString("nameReservation.error"), shell);
                }
                if (!reservedInDTR) {
                    try {
                        state = nameAlloc.revert("SAP_DesignTimePackage", packageName, state.getReservationKey());
                    }
                    catch (Throwable e) {
                        Util.logExceptionMessage(theTracer, 3, "Name Revert failed", e);
                    }
                    ProvisionalReservationActionImpl.cleanUp(resource);
                }
                if (state != null) {
                    pack.setState(state);
                }
                UpdateUtil.updateElement(this.element, ModelDeltaNodeKind.CHANGED);
            }
        }
    }

    public static void cleanUp(IPackageFragment resource) {
        if (resource == null) {
            return;
        }
        IFile file = PackageUtil.getPackageFile((IPackageFragment)resource);
        if (file != null && file.exists()) {
            try {
                file.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Util.logExceptionMessage(theTracer, 3, "Package file couldn't be deleted " + file.getName(), e);
            }
        }
    }

    public static AllocationState retryReserve(Shell shell, String name, NameAllocator nameAlloc, CompoundName packageName, String user, boolean protectGrowth, Throwable e) {
        AllocationState resState = null;
        AllocationState exState = null;
        if (e instanceof ReservedBeforeException) {
            exState = ((ReservedBeforeException)e).getAllocationState();
        } else if (e instanceof NotOwnerException) {
            exState = ((NotOwnerException)e).getAllocationState();
        }
        if (exState != null) {
            String message = ComponentProviderMessages.getString("branchProtected.error");
            if (!MessageDialog.openQuestion((Shell)shell, (String)ComponentProviderMessages.getString("nameReservation.title"), (String)MessageFormat.format(message, name, exState.getFlatName(), exState.getUserId()))) {
                return null;
            }
            try {
                resState = nameAlloc.reserveSubNamePreliminary("SAP_DesignTimePackage", packageName, user, "PACKAGE RESERVATION", null, protectGrowth, null, null);
            }
            catch (Throwable ex) {
                Util.logExceptionMessage(theTracer, 3, "Setting DTR Property failed", e);
                Util.showException(e, "Error", ComponentProviderMessages.getString("nameServer.error"), shell);
                return null;
            }
        }
        return resState;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

