/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.actions.namereservation;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.actions.namereservation.AbstractNameReservationAction;
import com.sap.ide.eclipse.component.provider.actions.namereservation.ProvisionalReservationActionImpl;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.ide.eclipse.component.provider.objects.PackageObject;
import com.sap.ide.eclipse.dii.namereservation.NameServerUtil;
import com.sap.ide.login.UserValidator;
import com.sap.tc.devconf.DCNodeSyncMode;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.action.ICategory;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.jface.action.IAction;

public class ProvisionalReservationAction
extends AbstractNameReservationAction {
    private TracerI theTracer = TracingManager.getTracer(this.getClass());

    public ICategory getCategory() {
        return ComponentCategoryImage.CATEGORY__NAME_RESERVATION_PROVISIONAL;
    }

    public boolean isEnabled(Element element) {
        if (!UserValidator.isDefaultServerOnline()) {
            return false;
        }
        Object obj = ObjectUtil.getComponentObject(element);
        if (obj instanceof PackageObject) {
            PackageObject pack = (PackageObject)obj;
            if (pack.getState() == null) {
                return true;
            }
            if (!pack.getState().isReserved()) {
                return true;
            }
        }
        return false;
    }

    public boolean isAvailable(Element element) {
        if (!"com.sap.ide.eclipse.component.DCMetaData.Package".equals(element.getUniqueName().getSubDomain())) {
            return false;
        }
        IDevelopmentComponentNode node = ComponentUtil.getParentDCNode(element);
        if (node != null && DCNodeSyncMode.LOCAL_ONLY.equals(node.getNodeSyncMode())) {
            return false;
        }
        try {
            if (NameServerUtil.getNameAllocator((Element)element) == null) {
                return false;
            }
        }
        catch (Throwable e) {
            Util.logExceptionMessage(this.theTracer, 3, "get Name allocator failed", e);
        }
        return super.isAvailable(element);
    }

    protected IAction getReservationAction(Element element) {
        return new ProvisionalReservationActionImpl(element);
    }
}

