/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.actions.namereservation;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.UpdateUtil;
import com.sap.ide.eclipse.component.provider.actions.namereservation.ProvisionalReservationActionImpl;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.ide.eclipse.component.provider.objects.PackageObject;
import com.sap.ide.eclipse.component.provider.ui.message.ComponentProviderMessages;
import com.sap.ide.eclipse.dii.component.PackageUtil;
import com.sap.ide.eclipse.dii.namereservation.NameServerUtil;
import com.sap.lcr.namealloc.NameAllocator;
import com.sap.lcr.namealloc.api.AllocationState;
import com.sap.lcr.namealloc.api.CommunicationFailureException;
import com.sap.lcr.namealloc.api.NameSyntaxViolation;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.CompoundName;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class BranchReservationActionImpl
extends Action {
    private Element element;
    private TracerI theTracer = TracingManager.getTracer(((Object)((Object)this)).getClass());

    public BranchReservationActionImpl(Element element) {
        this.element = element;
    }

    public void run() {
        Object state = null;
        Shell shell = ComponentProviderPlugin.getPlugin().getMyShell();
        String name = this.element.getUniqueName().getName();
        NameAllocator nameAlloc = null;
        IDevelopmentComponentNode dcNode = ComponentUtil.getParentDCNode(this.element);
        try {
            nameAlloc = NameServerUtil.getNameAllocator((Element)this.element);
        }
        catch (Throwable e) {
            Util.showException(e, shell);
        }
        if (nameAlloc != null) {
            String returnMsg = this.reserveSubBrunces(this.getSubBrunches(), nameAlloc, null, shell);
            if (returnMsg != null) {
                MessageDialog.openWarning((Shell)shell, (String)ComponentProviderMessages.getString("nameReservation.error"), (String)returnMsg);
            }
            UpdateUtil.updateElement(this.element, ModelDeltaNodeKind.CHANGED);
        }
    }

    private List getSubBrunches() {
        ArrayList<Entity> result = new ArrayList<Entity>();
        Entity parent = (Entity)this.element;
        if (parent != null) {
            EntityEnumeration entities = parent.childEntities();
            while (entities.hasMoreElements()) {
                result.add(entities.next());
            }
        }
        return result;
    }

    private String reserveSubBrunces(List entities, NameAllocator nameAlloc, IVfsActivity activity, Shell shell) {
        String message = "";
        boolean atLeastOneToReserve = false;
        Iterator it = entities.iterator();
        while (it.hasNext()) {
            Entity entity = (Entity)it.next();
            String name = entity.getUniqueName().getName();
            CompoundName packageName = PackageUtil.getPackageName((String)name, (NameAllocator)nameAlloc);
            IDevelopmentComponentNode dcNode = ComponentUtil.getParentDCNode((Element)entity);
            Object obj = ObjectUtil.getComponentObject((Element)entity);
            if (!(obj instanceof PackageObject)) continue;
            PackageObject pack = (PackageObject)obj;
            IPackageFragment resource = pack.getFragment();
            if (pack.getState() != null && pack.getState().isReserved()) continue;
            atLeastOneToReserve = true;
            if (!PackageUtil.hasPackageFile((IPackageFragment)resource)) {
                try {
                    if (!PackageUtil.createPackageFile((IPackageFragment)resource)) {
                        message = message + ComponentProviderMessages.format("packageFileCreation.error", new String[]{name}) + "\n";
                        continue;
                    }
                }
                catch (VfsException e) {
                    message = message + ComponentProviderMessages.format("packageFileCreation.error", new String[]{name}) + "\n" + ((Object)((Object)e)).getClass() + " " + (e.getMessage() != null ? e.getMessage() : "") + "\n";
                    return message;
                }
            }
            IVfsFile file = null;
            try {
                file = PackageUtil.getVFSPackageFile((IPackageFragment)resource);
            }
            catch (VfsException e) {
                message = message + ComponentProviderMessages.format("packageNameReservation.exception", new String[]{name, ((Object)((Object)e)).getClass().toString(), e.getMessage()}) + "\n";
                ProvisionalReservationActionImpl.cleanUp(resource);
                continue;
            }
            if (file == null) {
                ProvisionalReservationActionImpl.cleanUp(resource);
                message = message + ComponentProviderMessages.getString("dtrAccessDenied.nr.error") + "\n";
                return message;
            }
            if (activity == null) {
                try {
                    activity = NameServerUtil.getValidActivity(null, (IVfsFile)file, (Shell)shell);
                }
                catch (VfsException e) {
                    Util.logExceptionMessage(this.theTracer, 3, "Branch Name Reservation failed", e);
                    return "Can not get Activity";
                }
            }
            AllocationState state = null;
            try {
                String user = nameAlloc.getMyConnectUser();
                state = nameAlloc.reserveSubNamePreliminary("SAP_DesignTimePackage", packageName, user, dcNode != null ? "Package reserved in DC " + dcNode.getVendor() + "/" + dcNode.getName() : "PACKAGE RESERVATION", null, false, null, null);
            }
            catch (NameSyntaxViolation e) {
                Util.logExceptionMessage(this.theTracer, 3, "Branch Name Reservation failed", e);
                String prefixes = null;
                try {
                    prefixes = NameServerUtil.PrefixesToString((CompoundName[])nameAlloc.getAllowedPrefixList("SAP_DesignTimePackage"));
                }
                catch (CommunicationFailureException ex) {
                    Util.logExceptionMessage(this.theTracer, 3, "Get Prefixes failed", ex);
                }
                String msg = e.getMessage();
                if (msg == null) {
                    msg = ComponentProviderMessages.getString("NameSyntaxViolationPackage.error");
                }
                if (prefixes != null) {
                    msg = msg + ComponentProviderMessages.format("NameSyntaxViolationPackage.error", new String[]{name, prefixes});
                }
                message = message + msg + "\n";
                continue;
            }
            catch (Throwable e) {
                Util.logExceptionMessage(this.theTracer, 2, "Branch Name Reservation failed", e);
                message = message + ComponentProviderMessages.format("packageNameReservation.exception", new Object[]{name, e.getClass(), e.getMessage()}) + "\n";
            }
            if (state == null || state.getReservationKey() == null) {
                ProvisionalReservationActionImpl.cleanUp(resource);
                continue;
            }
            String url = null;
            boolean reservedInDTR = false;
            try {
                url = NameServerUtil.getURL((NameAllocator)nameAlloc);
            }
            catch (MalformedURLException e) {
                message = message + ComponentProviderMessages.format("packageNameReservation.exception", new Object[]{name, e.getClass(), e.getMessage()}) + "\n";
            }
            try {
                if (url != null) {
                    reservedInDTR = NameServerUtil.reserveInDTR((IVfsFile)file, (String)"SAP_DesignTimePackage", (String)name, (String)state.getReservationKey(), (String)url, (IVfsActivity)activity, null);
                }
            }
            catch (VfsException e) {
                message = message + ComponentProviderMessages.format("packageNameReservation.exception", new Object[]{name, ((Object)((Object)e)).getClass(), e.getMessage()}) + "\n";
            }
            catch (Throwable e) {
                message = message + ComponentProviderMessages.format("packageNameReservation.exception", new Object[]{name, e.getClass(), e.getMessage()}) + "\n";
            }
            if (!reservedInDTR) {
                ProvisionalReservationActionImpl.cleanUp(resource);
                try {
                    state = nameAlloc.revert("SAP_DesignTimePackage", packageName, state.getReservationKey());
                }
                catch (Throwable e) {
                    Util.logExceptionMessage(this.theTracer, 3, "Revert of Name failed", e);
                }
            }
            if (state != null) {
                pack.setState(state);
            }
            UpdateUtil.updateElement((Element)entity, ModelDeltaNodeKind.CHANGED);
        }
        if (message.equals("")) {
            return atLeastOneToReserve ? null : "No Packages to reserve";
        }
        return message;
    }
}

