/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.actions.dcproject;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.dcmdcommons.model.ActionStatus;
import com.sap.ide.eclipse.component.dcmetadata.model.IPPModel;
import com.sap.ide.eclipse.component.dcmetadata.model.PublicPartFileOutputProvider;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.actions.dcmetadata.ModifyPublicPartAction;
import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.ComponentType;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.Entity;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.action.ICategory;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;

public class PublishJarAction
extends ModifyPublicPartAction
implements IActionDelegate {
    private TracerI theTracer = TracingManager.getTracer(this.getClass());
    private List objects = null;
    private HashMap thePPModels = new HashMap();

    public void run(IAction action) {
        if (this.objects == null || this.objects.isEmpty()) {
            return;
        }
        Iterator it = this.objects.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof IFile)) continue;
            IFile file = (IFile)obj;
            this.addToPP(file);
        }
    }

    private boolean isJarFile(IFile file) {
        return "jar".equalsIgnoreCase(file.getFileExtension());
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.objects != null) {
            this.objects.clear();
        }
        this.clearPPModels();
        ArrayList<IFile> list = new ArrayList<IFile>();
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        if (selection != null && selection instanceof IStructuredSelection) {
            Iterator it = ((IStructuredSelection)selection).iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (obj instanceof IFile) {
                    IFile file = (IFile)obj;
                    if (!this.isJarFile(file)) {
                        action.setEnabled(false);
                        return;
                    }
                    list.add(file);
                    continue;
                }
                action.setEnabled(false);
                return;
            }
        }
        action.setEnabled(true);
        this.objects = list;
    }

    private boolean isInArchiveFolder(IFile file) {
        IPath path = file.getProjectRelativePath();
        if (!"libraries".equals(path.segment(0))) {
            return false;
        }
        return path.segmentCount() == 2;
    }

    private boolean isExtLibDC(IProject project) {
        IDCProxy proxy = this.getDcProxy(project);
        if (proxy == null) {
            return false;
        }
        DevelopmentComponent dc = proxy.getComponent();
        if (dc == null) {
            return false;
        }
        ComponentType type = dc.getComponentType();
        if (type == null) {
            return false;
        }
        if (!"External Library".equals(type.getType())) {
            return false;
        }
        return type.getSubType() == null || "".equals(type.getSubType());
    }

    private IDCProxy getDcProxy(IProject project) {
        IDCExtendedProject dcPrj = null;
        try {
            dcPrj = (IDCExtendedProject)project.getNature("com.sap.ide.eclipse.component.provider.dcnature");
        }
        catch (CoreException e1) {
            Util.logExceptionMessage(this.theTracer, 3, "getting DC Project failed", e1);
        }
        if (dcPrj == null) {
            return null;
        }
        IDevelopmentComponentNode dcNode = dcPrj.getDCNode();
        if (dcNode == null) {
            return null;
        }
        try {
            return dcNode.getDCProxy();
        }
        catch (DevConfigException e) {
            return null;
        }
    }

    private void addToPP(IFile file) {
        String entityName;
        if (!this.isJarFile(file) || !this.isInArchiveFolder(file)) {
            return;
        }
        IProject theProject = file.getProject();
        if (theProject == null || !this.isExtLibDC(theProject)) {
            return;
        }
        String entityCaption = entityName = file.getName();
        String entityType = "Archive";
        String entitySubtype = "Java Library";
        String entityPackageName = "";
        IPPModel thePPModel = this.getPPModel(theProject, null);
        if (thePPModel == null) {
            return;
        }
        Entity aNewEntity = ComponentFactory.createEntity();
        aNewEntity.setName(entityName);
        aNewEntity.setCaption(entityCaption);
        aNewEntity.setDescription("");
        aNewEntity.setPackageName(entityPackageName);
        aNewEntity.setType(entityType);
        aNewEntity.setSubType(entitySubtype);
        ActionStatus result = thePPModel.addEntity(aNewEntity);
        if (!result.getStatus()) {
            Shell aShell = ComponentProviderPlugin.getPlugin().getMyShell();
            MessageDialog.openWarning((Shell)aShell, (String)this.getMessageUtil().getString("Public.Part.Editor"), (String)result.getMessage());
        }
        IFile thePPFile = this.getPPFile(theProject, thePPModel);
        PublicPartFileOutputProvider anOutPutProvider = new PublicPartFileOutputProvider(thePPFile, this.getMessageUtil());
        try {
            thePPModel.writeModelTo(anOutPutProvider);
        }
        catch (Exception e) {
            Util.logExceptionMessage(this.theTracer, 2, this.getMessageUtil().getString("Exception.Occured"), e);
        }
    }

    public synchronized IPPModel getPPModel(IProject aProject, String appName) {
        IPPModel aPPModel = (IPPModel)this.thePPModels.get(aProject.getFullPath());
        if (aPPModel == null) {
            aPPModel = super.getPPModel(aProject, appName);
            this.thePPModels.put(aProject.getFullPath(), aPPModel);
        }
        return aPPModel;
    }

    private synchronized void clearPPModels() {
        this.thePPModels.clear();
    }

    public IProject getDCProject(Element element) {
        return null;
    }

    public void run(Element element) {
    }

    public boolean isEnabled(Element element) {
        return false;
    }

    public boolean isAvailable(Element element) {
        return false;
    }

    public ICategory getCategory() {
        return null;
    }
}

