/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.actions.dcproject;

import com.sap.ide.eclipse.component.dcmdcommons.model.ActionStatus;
import com.sap.ide.eclipse.component.dcmetadata.model.IPPModel;
import com.sap.ide.eclipse.component.dcmetadata.model.PublicPartFileOutputProvider;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.actions.dcmetadata.ModifyPublicPartAction;
import com.sap.ide.eclipse.component.wizard.java.Util;
import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.Entity;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.action.ICategory;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;

public class PublishAction
extends ModifyPublicPartAction
implements IActionDelegate {
    private static final String ADD_TO_PP_AS_TREE_ACTION_ID = "com.sap.ide.eclipse.component.provider.actions.dcproject.PublishAction.PackageTree";
    private TracerI theTracer = TracingManager.getTracer(this.getClass());
    private List objects = null;
    private HashMap thePPModels = new HashMap();

    public void run(IAction action) {
        if (this.objects == null || this.objects.isEmpty()) {
            return;
        }
        Iterator it = this.objects.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof ICompilationUnit) {
                ICompilationUnit jFile = (ICompilationUnit)obj;
                this.addToPP((IJavaElement)jFile, action.getId());
                continue;
            }
            if (!(obj instanceof IPackageFragment)) continue;
            IPackageFragment pack = (IPackageFragment)obj;
            this.addToPP((IJavaElement)pack, action.getId());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.objects != null) {
            this.objects.clear();
        }
        this.clearPPModels();
        ArrayList<Object> list = new ArrayList<Object>();
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        if (selection != null && selection instanceof IStructuredSelection) {
            Iterator it = ((IStructuredSelection)selection).iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (obj instanceof ICompilationUnit) {
                    ICompilationUnit jFile = (ICompilationUnit)obj;
                    if (!Util.isInPackageFolder((IJavaElement)jFile)) {
                        action.setEnabled(false);
                        return;
                    }
                    list.add(jFile);
                    continue;
                }
                if (obj instanceof IPackageFragment) {
                    IPackageFragment pack = (IPackageFragment)obj;
                    if (!Util.isInPackageFolder((IJavaElement)pack)) {
                        action.setEnabled(false);
                        return;
                    }
                    list.add(pack);
                    continue;
                }
                action.setEnabled(false);
                return;
            }
        }
        action.setEnabled(true);
        this.objects = list;
    }

    private void addToPP(IJavaElement element, String actionID) {
        IProject theProject = element.getJavaProject().getProject();
        if (theProject == null) {
            return;
        }
        String entityName = null;
        String entityCaption = null;
        String entityType = null;
        String entityPackageName = Util.getPackageName(element);
        if (entityPackageName == null) {
            entityPackageName = "";
        }
        entityPackageName = entityPackageName.replace('.', '/');
        if (element instanceof ICompilationUnit) {
            String name = ((ICompilationUnit)element).getElementName();
            if (!name.toLowerCase().endsWith(".java")) {
                return;
            }
            entityName = name.substring(0, name.length() - 5);
            entityType = "Java Class";
            entityCaption = "Java Class: " + entityName;
        } else if (element instanceof IPackageFragment) {
            entityName = element.getElementName();
            if (ADD_TO_PP_AS_TREE_ACTION_ID.equals(actionID)) {
                entityType = "Java Package Tree";
                entityCaption = "Java Package Tree: " + entityName;
            } else {
                entityType = "Java Package";
                entityCaption = "Java Package: " + entityName;
            }
        } else {
            return;
        }
        IPPModel thePPModel = this.getPPModel(theProject, null);
        if (thePPModel == null) {
            return;
        }
        Entity aNewEntity = ComponentFactory.createEntity();
        aNewEntity.setName(entityName);
        aNewEntity.setCaption(entityCaption);
        aNewEntity.setDescription("");
        aNewEntity.setPackageName(entityPackageName);
        aNewEntity.setType(entityType);
        aNewEntity.setSubType("Class");
        ActionStatus result = thePPModel.addEntity(aNewEntity);
        if (!result.getStatus()) {
            Shell aShell = ComponentProviderPlugin.getPlugin().getMyShell();
            MessageDialog.openWarning((Shell)aShell, (String)this.getMessageUtil().getString("Public.Part.Editor"), (String)result.getMessage());
        }
        IFile thePPFile = this.getPPFile(theProject, thePPModel);
        PublicPartFileOutputProvider anOutPutProvider = new PublicPartFileOutputProvider(thePPFile, this.getMessageUtil());
        try {
            thePPModel.writeModelTo(anOutPutProvider);
        }
        catch (Exception e) {
            com.sap.ide.eclipse.component.core.Util.logExceptionMessage(this.theTracer, 2, this.getMessageUtil().getString("Exception.Occured"), e);
        }
    }

    public synchronized IPPModel getPPModel(IProject aProject, String appName) {
        IPPModel aPPModel = (IPPModel)this.thePPModels.get(aProject.getFullPath());
        if (aPPModel == null) {
            aPPModel = super.getPPModel(aProject, appName);
            this.thePPModels.put(aProject.getFullPath(), aPPModel);
        }
        return aPPModel;
    }

    private synchronized void clearPPModels() {
        this.thePPModels.clear();
    }

    public IProject getDCProject(Element element) {
        return null;
    }

    public void run(Element element) {
    }

    public boolean isEnabled(Element element) {
        return false;
    }

    public boolean isAvailable(Element element) {
        return false;
    }

    public ICategory getCategory() {
        return null;
    }
}

