/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.actions.dcproject;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.component.provider.actions.dc.DCProjectUpdateAction;
import com.sap.ide.eclipse.component.provider.ui.message.ComponentProviderMessages;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;

public class DeleteProjectActionImpl
extends DCProjectUpdateAction {
    private IDevelopmentComponentNode dcNode;
    private IProject dcProject;
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$provider$actions$dcproject$DeleteProjectActionImpl;

    public DeleteProjectActionImpl(Element element) {
        super(TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$provider$actions$dcproject$DeleteProjectActionImpl == null ? (class$com$sap$ide$eclipse$component$provider$actions$dcproject$DeleteProjectActionImpl = DeleteProjectActionImpl.class$("com.sap.ide.eclipse.component.provider.actions.dcproject.DeleteProjectActionImpl")) : class$com$sap$ide$eclipse$component$provider$actions$dcproject$DeleteProjectActionImpl)));
        this.dcNode = ComponentUtil.getDCNode(element);
        this.dcProject = DCProjectUtil.getProject(element);
    }

    public void run() {
        try {
            if (this.dcNode == null || this.dcProject == null) {
                return;
            }
            if (this.dcNode.isLocalOnlySource()) {
                ArrayList<IProject> list = new ArrayList<IProject>();
                list.add(this.dcProject);
                DeleteProjectDialog dialog = new DeleteProjectDialog(ComponentProviderPlugin.getPlugin().getMyShell(), list);
                dialog.setSelectText(ComponentProviderMessages.getString("deleteDCContents.label"), ComponentProviderMessages.getString("doNotDeleteDC.label"));
                if (dialog.open() != 0) {
                    return;
                }
                if (dialog.getDeleteContent()) {
                    this.dcNode.getDCProxy().removeLocalDC(true);
                    this.dcProject.delete(false, true, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    this.dcProject.delete(false, true, (IProgressMonitor)new NullProgressMonitor());
                }
            } else {
                ArrayList<IProject> list = new ArrayList<IProject>();
                list.add(this.dcProject);
                DeleteProjectDialog dialog = new DeleteProjectDialog(ComponentProviderPlugin.getPlugin().getMyShell(), list);
                dialog.setSelectText(ComponentProviderMessages.getString("unsyncDCProjectContents.label"), null);
                if (dialog.open() != 0) {
                    return;
                }
                if (dialog.getDeleteContent()) {
                    this.dcProject.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    this.dcProject.delete(false, true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        catch (Exception e) {
            Util.logExceptionMessage(this.theTracer, 2, "Delete DC PRoject failed", e);
            Util.showException(e, null);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class DeleteProjectDialog
    extends MessageDialog {
        private List projects;
        private boolean deleteContent = false;
        private Button radio1;
        private Button radio2;
        private String textWithContent = null;
        private String textWithoutContent = null;
        private SelectionListener selectionListener = new SelectionAdapter(this){
            private final /* synthetic */ DeleteProjectDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    DeleteProjectDialog.access$002(this.this$0, button == DeleteProjectDialog.access$100(this.this$0));
                }
            }
        };

        DeleteProjectDialog(Shell parentShell, List projects) {
            super(parentShell, DeleteProjectDialog.getTitle(projects), null, DeleteProjectDialog.getMessage(projects), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            this.projects = projects;
        }

        public void setSelectText(String textWithContent, String textWithoutContent) {
            this.textWithContent = textWithContent;
            this.textWithoutContent = textWithoutContent;
        }

        static String getTitle(List projects) {
            if (projects.size() == 1) {
                return WorkbenchMessages.getString((String)"DeleteResourceAction.titleProject1");
            }
            return WorkbenchMessages.getString((String)"DeleteResourceAction.titleProjectN");
        }

        static String getMessage(List projects) {
            if (projects.size() == 1) {
                IProject project = (IProject)projects.get(0);
                return WorkbenchMessages.format((String)"DeleteResourceAction.confirmProject1", (Object[])new Object[]{project.getName()});
            }
            return WorkbenchMessages.format((String)"DeleteResourceAction.confirmProjectN", (Object[])new Object[]{new Integer(projects.size())});
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.ui.delete_project_dialog_context");
        }

        protected Control createCustomArea(Composite parent) {
            String text1;
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.radio1 = new Button(composite, 16);
            this.radio1.addSelectionListener(this.selectionListener);
            if (this.projects.size() == 1) {
                IProject project = (IProject)this.projects.get(0);
                text1 = this.textWithContent != null ? this.textWithContent : (project == null || project.getLocation() == null ? WorkbenchMessages.getString((String)"DeleteResourceAction.deleteContentsN") : WorkbenchMessages.format((String)"DeleteResourceAction.deleteContents1", (Object[])new Object[]{project.getLocation().toOSString()}));
            } else {
                text1 = WorkbenchMessages.getString((String)"DeleteResourceAction.deleteContentsN");
            }
            this.radio1.setText(text1);
            this.radio2 = new Button(composite, 16);
            this.radio2.addSelectionListener(this.selectionListener);
            String text2 = this.textWithoutContent != null ? this.textWithoutContent : WorkbenchMessages.getString((String)"DeleteResourceAction.doNotDeleteContents");
            this.radio2.setText(text2);
            this.radio1.setSelection(this.deleteContent);
            this.radio2.setSelection(!this.deleteContent);
            return composite;
        }

        public boolean getDeleteContent() {
            return this.deleteContent;
        }

        static /* synthetic */ boolean access$002(DeleteProjectDialog x0, boolean x1) {
            x0.deleteContent = x1;
            return x0.deleteContent;
        }

        static /* synthetic */ Button access$100(DeleteProjectDialog x0) {
            return x0.radio1;
        }
    }
}

