/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.actions.dcproject;

import com.sap.ide.eclipse.component.core.DCProject;
import com.sap.ide.eclipse.component.core.SelectDCsDialog;
import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.component.provider.actions.dc.WorkerThreadConsistency;
import com.sap.ide.eclipse.component.provider.actions.dcproject.AbstractDCMultiProjectAction;
import com.sap.tc.buildtool.IBuildResult;
import com.sap.tc.devconf.BuildException;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentComponentRef;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.SyncException;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.action.ICategory;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class BuildAction
extends AbstractDCMultiProjectAction
implements IWorkbenchWindowActionDelegate {
    private static TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$provider$actions$dcproject$BuildAction == null ? (class$com$sap$ide$eclipse$component$provider$actions$dcproject$BuildAction = BuildAction.class$("com.sap.ide.eclipse.component.provider.actions.dcproject.BuildAction")) : class$com$sap$ide$eclipse$component$provider$actions$dcproject$BuildAction));
    public static final int SINGLE_BUILD = 0;
    public static final int RECURSIVE_BUILD = 1;
    public static final int RECURSIVE_REBUILD = 2;
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$provider$actions$dcproject$BuildAction;

    public ICategory getCategory() {
        return ComponentCategoryImage.CATEGORY__DC_PROJECT_BUILD;
    }

    public boolean isAvailable(Element[] el) {
        if (el == null) {
            return false;
        }
        int i = 0;
        while (i < el.length) {
            Element element = el[i];
            IDevelopmentComponentNode dcNode = ComponentUtil.getDCNode(element);
            if (dcNode != null && (dcNode.isLocalOnlySource() || dcNode.isSynchedAsSource())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void run(IAction action) {
        this.run(action, 1);
    }

    public void run(IAction action, int buildKind) {
        block20: {
            if (this.dcList == null || this.dcList.isEmpty()) {
                return;
            }
            ArrayList forBuildDCList = new ArrayList();
            this.devConfSet = this.collectConfigurations(this.dcList.toArray(new Element[this.dcList.size()]), forBuildDCList);
            if (!Util.saveSensitiveEditors(this.devConfSet)) {
                return;
            }
            final HashSet<IProject> projectSet = new HashSet<IProject>();
            Util.showUserOutputViewer();
            ArrayList<IDCProxy> originalSelection = new ArrayList<IDCProxy>();
            HashSet<IDCProxy> defaultSelectSet = new HashSet<IDCProxy>();
            final HashMap<IDCProxy, List<IDCProxy>> buildDependenciesMap = new HashMap<IDCProxy, List<IDCProxy>>();
            ArrayList<IDCProxy> proxyList = new ArrayList<IDCProxy>();
            Iterator it = forBuildDCList.iterator();
            while (it.hasNext()) {
                Element dcElement = (Element)it.next();
                IDevelopmentComponentNode dcNode = ComponentUtil.getDCNode(dcElement);
                if (dcNode == null) {
                    Util.logExceptionMessage(theTracer, 3, "No IDevelopmentComponent Instance for " + dcElement.getUniqueName() + " (null)", null);
                    continue;
                }
                IDCProxy dcProxy = null;
                try {
                    dcProxy = dcNode.getDCProxy();
                }
                catch (DevConfigException e1) {
                    Util.logExceptionMessage(theTracer, 3, "No IDCProxy Instance for " + dcNode.getName(), e1);
                }
                if (dcProxy == null) continue;
                if (dcProxy.isDirty()) {
                    defaultSelectSet.add(dcProxy);
                }
                originalSelection.add(dcProxy);
                proxyList.add(dcProxy);
                IDCProxy[] proxiesForRecBuild = null;
                try {
                    proxiesForRecBuild = dcProxy.listDCProxiesForRecursiveMake();
                    if (proxiesForRecBuild != null) {
                        buildDependenciesMap.put(dcProxy, Arrays.asList(proxiesForRecBuild));
                    }
                }
                catch (BuildException e) {
                    Util.logExceptionMessage(theTracer, 3, "listDCProxiesForRecursiveMake failed for " + dcProxy.getName(), e);
                }
                if (buildKind != 1 && buildKind != 2 || proxiesForRecBuild == null) continue;
                int i = 0;
                while (i < proxiesForRecBuild.length) {
                    IProject prj;
                    if (proxiesForRecBuild[i].isDirty() && !defaultSelectSet.contains(proxiesForRecBuild[i])) {
                        defaultSelectSet.add(proxiesForRecBuild[i]);
                        Collection userDCs = this.listRecursiveUsers(proxiesForRecBuild[i]);
                        defaultSelectSet.addAll(userDCs);
                    }
                    if ((prj = DCProjectUtil.getProject(proxiesForRecBuild[i])) != null && prj.exists() && prj.isOpen()) {
                        projectSet.add(prj);
                    }
                    proxyList.add(proxiesForRecBuild[i]);
                    ++i;
                }
            }
            HashSet myProxySet = new HashSet(proxyList);
            final ArrayList<Object> selectedProxies = new ArrayList<Object>();
            SelectDCsDialog dialog = SelectDCsDialog.newSelectDCsDialog(null, "Build Development Components", "Select the Development Components to build", myProxySet, originalSelection, null);
            dialog.initializeOptions("Only build if necessary", true, null, false);
            dialog.setInitialElementSelections(new ArrayList(defaultSelectSet));
            int returnValue = dialog.open();
            if (returnValue == 0) {
                selectedProxies.addAll(Arrays.asList(dialog.getResult()));
            } else if (returnValue == 1) {
                return;
            }
            if (selectedProxies.isEmpty()) {
                return;
            }
            final boolean ignoreDirtyFlag = !dialog.isOptionSelected();
            BuildAction.saveAllDCProjects(selectedProxies);
            ProgressMonitorDialog progressMonitor = new ProgressMonitorDialog(ComponentProviderPlugin.getPlugin().getMyShell());
            boolean fork = true;
            try {
                progressMonitor.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InterruptedException {
                        WorkerThreadConsistency.setWorkerThreadActive();
                        try {
                            if (monitor == null) {
                                monitor = new NullProgressMonitor();
                            }
                            monitor.beginTask("Build DC(s)", 110);
                            BuildAction.this.devConfSet = BuildAction.buildDCsForDevConfig(BuildAction.this.devConfSet, selectedProxies, buildDependenciesMap, (IProgressMonitor)new SubProgressMonitor(monitor, 100), ignoreDirtyFlag);
                            monitor.subTask("Updating DC Projects ...");
                            Util.updateGenFolder(projectSet.toArray(new IProject[projectSet.size()]));
                            if (BuildAction.this.shouldUpdateProject()) {
                                BuildAction.super.updateDCProjects((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                            }
                            Object var3_2 = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            WorkerThreadConsistency.resetWorkerThreadActive();
                            throw throwable;
                        }
                        WorkerThreadConsistency.resetWorkerThreadActive();
                    }
                });
            }
            catch (InvocationTargetException e) {
                Util.logExceptionMessage(theTracer, 3, "DC build failed", e);
            }
            catch (InterruptedException e) {
                Util.updateGenFolder(projectSet.toArray(new IProject[projectSet.size()]));
                if (!this.shouldUpdateProject()) break block20;
                this.updateDCProjects((IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    public boolean shouldUpdateProject() {
        return true;
    }

    private Collection listRecursiveUsers(IDCProxy proxy) {
        HashSet<IDCProxy> collection = new HashSet<IDCProxy>();
        IDevelopmentComponentRef[] result = null;
        try {
            result = proxy.listLocalAtBuildTimeUsersRecursively(true);
        }
        catch (DevConfigException e) {
            Util.logExceptionMessage(theTracer, 3, "Atomatic Select for build failed", e);
        }
        catch (SyncException e) {
            Util.logExceptionMessage(theTracer, 3, "Atomatic Select for build failed", e);
        }
        if (result != null) {
            int i = 0;
            while (i < result.length) {
                IDevelopmentComponentRef ref = result[i];
                IDCProxy foundProxy = null;
                if (ref != null) {
                    try {
                        foundProxy = proxy.getDevelopmentConfiguration().getDCProxyLocally(ref.getCompartment(), ref.getVendor(), ref.getName());
                    }
                    catch (DevConfigException e) {
                        Util.logExceptionMessage(theTracer, 3, "Atomatic Select for build failed", e);
                    }
                }
                if (foundProxy != null) {
                    collection.add(foundProxy);
                }
                ++i;
            }
        }
        return collection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set buildDCsForDevConfig(Set devConfigSet, Collection myProxySet, Map buildDependenciesMap, IProgressMonitor monitor, boolean ignoreDirtyFlag) throws InterruptedException {
        int oldStatus = 0;
        float currentStatus = 0.0f;
        float step = 100 / myProxySet.size();
        monitor.beginTask("Build", 100);
        HashSet<IDevelopmentConfiguration> affectedDevConfigSet = new HashSet<IDevelopmentConfiguration>();
        try {
            Iterator it2;
            Iterator it = devConfigSet.iterator();
            block13: while (true) {
                if (!it.hasNext()) {
                    it2 = myProxySet.iterator();
                    break;
                }
                IDevelopmentConfiguration devConfig = (IDevelopmentConfiguration)it.next();
                IDCProxy[] orderedDCs = devConfig.getBuildOrderOfDCsAvailableAsSource(true);
                int i = 0;
                while (true) {
                    if (i >= orderedDCs.length) continue block13;
                    if (monitor.isCanceled()) {
                        monitor.subTask("");
                        throw new InterruptedException();
                    }
                    IDCProxy orderedDC = orderedDCs[i];
                    if (myProxySet.contains(orderedDC)) {
                        myProxySet.remove(orderedDC);
                        if (ignoreDirtyFlag || orderedDC.isDirty()) {
                            IBuildResult buildResult;
                            block31: {
                                DCProject prj;
                                Object var18_24;
                                monitor.subTask("Building " + orderedDC.getName() + " (" + orderedDC.getVendor() + ")" + " ...");
                                buildResult = null;
                                try {
                                    try {
                                        String buildVariant = Util.getBuildVariant(orderedDC.getDevelopmentConfiguration(), orderedDC.getCompartment().getName());
                                        buildResult = orderedDC.make(buildVariant, null, null);
                                    }
                                    catch (BuildException ex) {
                                        Util.logExceptionMessage(theTracer, 3, "Build for " + orderedDC.getName() + " failed", ex);
                                        var18_24 = null;
                                        affectedDevConfigSet.add(orderedDC.getDevelopmentConfiguration());
                                        prj = DCProjectUtil.getDCProject(DCProjectUtil.getProject(orderedDC));
                                        if (prj != null) {
                                            prj.notifyBuild();
                                        }
                                        break block31;
                                    }
                                    catch (Throwable ex) {
                                        Util.showUserOutputViewer();
                                        Util.logExceptionMessage(theTracer, 2, "Build for " + orderedDC.getName() + " failed", ex);
                                        theTracer.userOut("Development Component", 2, "" + orderedDC.getName() + ": Failed with exception (" + ex.getMessage() + ") ");
                                        var18_24 = null;
                                        affectedDevConfigSet.add(orderedDC.getDevelopmentConfiguration());
                                        prj = DCProjectUtil.getDCProject(DCProjectUtil.getProject(orderedDC));
                                        if (prj != null) {
                                            prj.notifyBuild();
                                        }
                                        break block31;
                                    }
                                    var18_24 = null;
                                    affectedDevConfigSet.add(orderedDC.getDevelopmentConfiguration());
                                }
                                catch (Throwable throwable) {
                                    var18_24 = null;
                                    affectedDevConfigSet.add(orderedDC.getDevelopmentConfiguration());
                                    prj = DCProjectUtil.getDCProject(DCProjectUtil.getProject(orderedDC));
                                    if (prj != null) {
                                        prj.notifyBuild();
                                    }
                                    throw throwable;
                                }
                                prj = DCProjectUtil.getDCProject(DCProjectUtil.getProject(orderedDC));
                                if (prj != null) {
                                    prj.notifyBuild();
                                }
                            }
                            BuildAction.optimizeBuildList(buildDependenciesMap, myProxySet, orderedDC, buildResult);
                        } else {
                            theTracer.userOut("Development Component", 4, "" + orderedDC.getName() + ": Skipped build as not necessary (to force build turn off checkbox at bottom of build dialog)");
                        }
                        if ((int)(currentStatus += step) > oldStatus) {
                            monitor.worked((int)currentStatus - oldStatus);
                            oldStatus = (int)currentStatus;
                        }
                    }
                    ++i;
                }
                break;
            }
            while (it2.hasNext()) {
                block32: {
                    if (monitor.isCanceled()) {
                        monitor.subTask("");
                        throw new InterruptedException();
                    }
                    IDCProxy dcProxy = (IDCProxy)it2.next();
                    if (ignoreDirtyFlag || dcProxy.isDirty()) {
                        DCProject prj;
                        Object var21_27;
                        monitor.subTask("Building " + dcProxy.getName() + " (" + dcProxy.getVendor() + ")" + " ...");
                        try {
                            try {
                                String buildVariant = Util.getBuildVariant(dcProxy.getDevelopmentConfiguration(), dcProxy.getCompartment().getName());
                                dcProxy.make(buildVariant, null, null);
                            }
                            catch (Throwable e1) {
                                Util.logExceptionMessage(theTracer, 2, "Build for " + dcProxy.getName() + " failed", e1);
                                var21_27 = null;
                                affectedDevConfigSet.add(dcProxy.getDevelopmentConfiguration());
                                prj = DCProjectUtil.getDCProject(DCProjectUtil.getProject(dcProxy));
                                if (prj != null) {
                                    prj.notifyBuild();
                                }
                                break block32;
                            }
                            var21_27 = null;
                            affectedDevConfigSet.add(dcProxy.getDevelopmentConfiguration());
                        }
                        catch (Throwable throwable) {
                            var21_27 = null;
                            affectedDevConfigSet.add(dcProxy.getDevelopmentConfiguration());
                            prj = DCProjectUtil.getDCProject(DCProjectUtil.getProject(dcProxy));
                            if (prj != null) {
                                prj.notifyBuild();
                            }
                            throw throwable;
                        }
                        prj = DCProjectUtil.getDCProject(DCProjectUtil.getProject(dcProxy));
                        if (prj != null) {
                            prj.notifyBuild();
                        }
                    }
                }
                if ((int)(currentStatus += step) <= oldStatus) continue;
                monitor.worked((int)currentStatus - oldStatus);
                oldStatus = (int)currentStatus;
            }
        }
        catch (RuntimeException e) {
            Util.logExceptionMessage(theTracer, 2, "Build failed", e);
        }
        catch (DevConfigException e) {
            Util.logExceptionMessage(theTracer, 2, "Build failed", e);
        }
        catch (SyncException e) {
            Util.logExceptionMessage(theTracer, 2, "Build failed", e);
        }
        monitor.subTask("");
        return affectedDevConfigSet;
    }

    public static void optimizeBuildList(Map buildDependenciesMap, Collection haveToBuildDCCollection, IDCProxy orderedDC, IBuildResult buildResult) {
        if (buildDependenciesMap != null) {
            buildDependenciesMap.remove(orderedDC);
            if (buildResult == null || buildResult.getResultCode() != 0 && buildResult.getResultCode() != 1) {
                ArrayList<IDCProxy> affectedTopBuildDCList = new ArrayList<IDCProxy>();
                HashSet askForRequestToBuildDCList = new HashSet();
                Iterator it = buildDependenciesMap.keySet().iterator();
                while (it.hasNext()) {
                    IDCProxy keyProxy = (IDCProxy)it.next();
                    List recursiveList = (List)buildDependenciesMap.get(keyProxy);
                    if (!recursiveList.contains(orderedDC)) continue;
                    affectedTopBuildDCList.add(keyProxy);
                    askForRequestToBuildDCList.addAll(recursiveList);
                }
                if (!affectedTopBuildDCList.isEmpty()) {
                    Iterator it2 = affectedTopBuildDCList.iterator();
                    while (it2.hasNext()) {
                        buildDependenciesMap.remove(it2.next());
                    }
                    ArrayList<IDCProxy> willBeBuildDCList = new ArrayList<IDCProxy>();
                    Iterator it3 = buildDependenciesMap.keySet().iterator();
                    while (it3.hasNext()) {
                        List recursiveList = (List)buildDependenciesMap.get(it3.next());
                        Iterator iter = askForRequestToBuildDCList.iterator();
                        while (iter.hasNext()) {
                            IDCProxy shouldBeBuildDC = (IDCProxy)iter.next();
                            if (!recursiveList.contains(shouldBeBuildDC)) continue;
                            willBeBuildDCList.add(shouldBeBuildDC);
                        }
                    }
                    askForRequestToBuildDCList.removeAll(willBeBuildDCList);
                    haveToBuildDCCollection.removeAll(askForRequestToBuildDCList);
                    haveToBuildDCCollection.removeAll(affectedTopBuildDCList);
                }
            }
        }
    }

    protected IAction getDCAction(Element el) {
        return null;
    }

    public void run(Element[] elements) {
        this.dcList = new ArrayList();
        int i = 0;
        while (i < elements.length) {
            Element element = elements[i];
            if (this.isAvailable(new Element[]{element})) {
                this.dcList.add(element);
            }
            ++i;
        }
        this.run((IAction)null);
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public static void saveAllDCProjects(Collection dcList) {
        if (dcList == null || dcList.isEmpty()) {
            return;
        }
        if (!org.eclipse.ui.actions.BuildAction.isSaveAllSet()) {
            return;
        }
        ArrayList<IProject> projects = new ArrayList<IProject>();
        Iterator it = dcList.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            IProject project = null;
            if (obj instanceof IDevelopmentComponentNode) {
                project = DCProjectUtil.getProject((IDevelopmentComponentNode)obj);
            } else if (obj instanceof IDCProxy) {
                project = DCProjectUtil.getProject((IDCProxy)obj);
            } else if (obj instanceof Element) {
                project = DCProjectUtil.getParentProject((Element)obj);
            }
            if (project == null || !project.isOpen()) continue;
            projects.add(project);
        }
        BuildAction.saveAllProjectResources(projects);
    }

    public static void saveAllProjectResources(Collection projects) {
        if (projects == null || projects.isEmpty()) {
            return;
        }
        if (!org.eclipse.ui.actions.BuildAction.isSaveAllSet()) {
            return;
        }
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int j = 0;
            while (j < pages.length) {
                IWorkbenchPage page = pages[j];
                IEditorPart[] editors = page.getDirtyEditors();
                int k = 0;
                while (k < editors.length) {
                    IFile inputFile;
                    IEditorPart editor = editors[k];
                    IEditorInput input = editor.getEditorInput();
                    if (input instanceof IFileEditorInput && projects.contains((inputFile = ((IFileEditorInput)input).getFile()).getProject())) {
                        page.saveEditor(editor, false);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

