/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.actions.dcproject;

import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.actions.dc.AbstractDcMultiAction;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.tssap.selena.model.elements.Element;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionDelegate;

public abstract class AbstractDCMultiProjectAction
extends AbstractDcMultiAction
implements IActionDelegate {
    protected static ComponentProviderPlugin myPlugin = ComponentProviderPlugin.getPlugin();
    protected List dcList;

    protected abstract IAction getDCAction(Element var1);

    protected IAction getDCAction(Element element, IDevelopmentComponentNode dcNode) {
        return this.getDCAction(element);
    }

    public void run(IAction action) {
        if (this.dcList == null || this.dcList.isEmpty()) {
            return;
        }
        if (this.shouldUpdateProject()) {
            this.devConfSet = this.collectConfigurations(this.dcList.toArray(new Element[this.dcList.size()]), new ArrayList());
            if (!this.saveEditors()) {
                return;
            }
        } else {
            this.devConfSet = new HashSet();
        }
        if (this.hasBusyIndicator()) {
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                public void run() {
                    AbstractDCMultiProjectAction.this.runContent();
                }
            });
        } else {
            this.runContent();
        }
        if (this.shouldUpdateProject()) {
            this.updateDCProjects();
        }
    }

    private void runContent() {
        Iterator it = this.dcList.iterator();
        while (it.hasNext()) {
            IAction dcAction;
            Element element = (Element)it.next();
            if (!this.isAvailable(new Element[]{element}) || (dcAction = this.getDCAction(element)) == null) continue;
            dcAction.run();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.dcList = new ArrayList();
        if (selection != null && selection instanceof IStructuredSelection) {
            Iterator it = ((IStructuredSelection)selection).iterator();
            while (it.hasNext()) {
                Element myDcNodeElement;
                Object obj = it.next();
                Object selectedProject = obj instanceof IProject ? (IProject)obj : (obj instanceof IJavaProject ? ((IJavaProject)obj).getProject() : null);
                if (selectedProject == null || (myDcNodeElement = ObjectUtil.getDCNodeElement(selectedProject)) == null) continue;
                this.dcList.add(myDcNodeElement);
            }
        }
        if (!this.dcList.isEmpty()) {
            action.setEnabled(this.isAvailable(this.dcList.toArray(new Element[this.dcList.size()])));
        } else {
            action.setEnabled(false);
        }
    }

    protected boolean hasBusyIndicator() {
        return true;
    }
}

