/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.actions.dcmetadata;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.dcmdcommons.resources.MessageUtil;
import com.sap.ide.eclipse.component.dcmetadata.model.IPPModel;
import com.sap.ide.eclipse.component.dcmetadata.model.PPModel;
import com.sap.ide.eclipse.component.dcmetadata.model.PPModelInitException;
import com.sap.ide.eclipse.component.dcmetadata.view.CreatePpInputShell;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.component.provider.actions.dcmetadata.AbstractMetaDataAction;
import com.sap.ide.eclipse.dii.component.ComponentUtil;
import com.sap.ide.eclipse.dii.component.ProjectConsistencyManager;
import com.sap.ide.login.UserValidator;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.tssap.dii.dtri.util.RepositoryObject;
import com.tssap.dii.dtri.util.RepositoryServiceException;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.action.ICategory;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.dialog.ObjectSelectionDialog;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public abstract class ModifyPublicPartAction
extends AbstractMetaDataAction {
    public static final ArrayList GENERATED_PP_NAMES = new ArrayList();
    private TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$provider$actions$dcmetadata$ModifyPublicPartAction == null ? (class$com$sap$ide$eclipse$component$provider$actions$dcmetadata$ModifyPublicPartAction = ModifyPublicPartAction.class$("com.sap.ide.eclipse.component.provider.actions.dcmetadata.ModifyPublicPartAction")) : class$com$sap$ide$eclipse$component$provider$actions$dcmetadata$ModifyPublicPartAction));
    private MessageUtil theMessageUtil = MessageUtil.getInstance("com.sap.ide.eclipse.component.dcmdcommons.resources.messages");
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$provider$actions$dcmetadata$ModifyPublicPartAction;

    public MessageUtil getMessageUtil() {
        return this.theMessageUtil;
    }

    public IFile getPPFile(IProject theProject, IPPModel thePPModel) {
        return this.getPublicPartFile(theProject, thePPModel.getName());
    }

    public IPPModel getPPModel(IProject aDCProject, String aPPName) {
        return this.getPPModel(aDCProject, aPPName, true);
    }

    public IPPModel getPPModel(IProject aDCProject, String aPPName, boolean withCheckOut) {
        DevelopmentComponent aDC = this.getDC(aDCProject);
        if (aDC == null) {
            Util.showUserOutputViewer();
            this.theTracer.userOut(3, this.theMessageUtil.getString("Warning.Could.Not.Find.DC"));
            return null;
        }
        PublicPart aPP = this.getPublicPart(aDCProject, aDC, aPPName);
        if (aPP == null) {
            return null;
        }
        IFile thePPFile = this.getPublicPartFile(aDCProject, aPP.getName());
        if (thePPFile == null || !thePPFile.exists() || !thePPFile.isAccessible()) {
            Util.showUserOutputViewer();
            this.theTracer.userOut(3, this.theMessageUtil.getString("Warning.Target.PublicPart.NotAccessible"));
            return null;
        }
        if (thePPFile.isReadOnly() && withCheckOut) {
            try {
                RepositoryObject anObjectToEdit = new RepositoryObject("PublicPart", thePPFile.getName(), thePPFile.getProject());
                anObjectToEdit.addlResource((IResource)thePPFile);
                RepositoryObject.ResourceRepositoryStatus aStatus = anObjectToEdit.checkOut(false, null);
                if (!aStatus.status) {
                    Shell aShell = ComponentProviderPlugin.getPlugin().getMyShell();
                    MessageDialog.openWarning((Shell)aShell, (String)this.getMessageUtil().getString("Public.Part.Editor"), (String)this.getMessageUtil().format("Warning.Target.PublicPart.Could.Not.Be.Checked.Out", new Object[]{aStatus.message}));
                    return null;
                }
            }
            catch (RepositoryServiceException rse) {
                if (rse.getErrorCode() != 13) {
                    Util.showUserOutputViewer();
                    this.theTracer.userOut(2, rse.getMessage());
                }
                return null;
            }
        }
        IPPModel thePPModel = null;
        try {
            thePPModel = PPModel.getPublicPartModel(thePPFile);
        }
        catch (PPModelInitException pie) {
            this.theTracer.userOut(this.theMessageUtil.getString("Exception.Occured"), pie.toString());
            return null;
        }
        return thePPModel;
    }

    public boolean isGenerated(IPPModel aPPModel) {
        String aPPName;
        String aDCType = aPPModel.getDCModel().getComponentType().getType();
        return aDCType.startsWith("J2EE") && GENERATED_PP_NAMES.contains(aPPName = aPPModel.getName());
    }

    protected IFile getPublicPartFile(IProject theDCProject, String aPPFileName) {
        IFile aPPFile;
        IFolder aFolder;
        IResource aResource;
        IFile aResult = null;
        if (theDCProject == null) {
            aResult = null;
        }
        aResult = (aResource = theDCProject.findMember("def")) instanceof IFolder ? ((aResource = (aFolder = (IFolder)aResource).findMember(aPPFileName + ".pp")) != null && aResource instanceof IFile ? (aPPFile = (IFile)aResource) : null) : null;
        return aResult;
    }

    private PublicPart getPublicPart(IProject theProject, DevelopmentComponent aDC, String thePPName) {
        Object aPPResult = null;
        Map thePublicParts = aDC.getPublicParts();
        if (thePPName != null) {
            if (thePublicParts == null || thePublicParts.size() <= 0) {
                return null;
            }
            aPPResult = (PublicPart)thePublicParts.get(thePPName);
            return aPPResult;
        }
        if (thePublicParts == null || thePublicParts.size() <= 0) {
            return this.createNewPP(theProject, aDC);
        }
        HashSet aPPKeySet = new HashSet(thePublicParts.keySet());
        if (!UserValidator.isDefaultServerOnline()) {
            ArrayList<String> toRemoveCol = new ArrayList<String>();
            Iterator it = aPPKeySet.iterator();
            while (it.hasNext()) {
                String ppName = (String)it.next();
                IFile thePPFile = this.getPublicPartFile(theProject, ppName);
                if (thePPFile != null && thePPFile.exists() && thePPFile.isAccessible() && !thePPFile.isReadOnly()) continue;
                toRemoveCol.add(ppName);
            }
            aPPKeySet.removeAll(toRemoveCol);
        }
        Object[] theKeys = aPPKeySet.toArray();
        Shell aShell = ComponentProviderPlugin.getPlugin().getMyShell();
        String aTitle = this.theMessageUtil.getString("Dialog.Message.Select.PublicPart.Title");
        String aMessage = this.theMessageUtil.getString("Dialog.Message.Select.Public.Part.Message");
        ModObjectSelectionDialog aSelectDialog = new ModObjectSelectionDialog(aShell, aTitle, aMessage);
        aSelectDialog.setSingleSelection(true);
        Object[] theSelectedKeys = aSelectDialog.openDialog(theKeys);
        aPPResult = theSelectedKeys != null && theSelectedKeys.length > 0 && !aSelectDialog.isNewRequested() ? (PublicPart)thePublicParts.get(theSelectedKeys[0]) : (aSelectDialog.isNewRequested() ? this.createNewPP(theProject, aDC) : null);
        return aPPResult;
    }

    private PublicPart createNewPP(IProject theProject, DevelopmentComponent aDC) {
        CreatePpInputShell aNewPPWizard;
        Shell aShell = ComponentProviderPlugin.getPlugin().getMyShell();
        if (theProject == null) {
            return null;
        }
        IFolder theDefFolder = theProject.getFolder((IPath)new Path("def"));
        try {
            aNewPPWizard = new CreatePpInputShell(theDefFolder, false);
        }
        catch (Exception e) {
            Util.logException(this.theTracer, e);
            return null;
        }
        WizardDialog aWizardDialog = new WizardDialog(aShell, (IWizard)aNewPPWizard);
        aWizardDialog.open();
        IFile theNewPPFile = aNewPPWizard.getNewPPFile();
        if (theNewPPFile == null) {
            return null;
        }
        String aPPName = theNewPPFile.getName().substring(0, theNewPPFile.getName().length() - 3);
        Map aPPMap = aDC.getPublicParts();
        if (aPPMap != null) {
            return (PublicPart)aPPMap.get(aPPName);
        }
        return null;
    }

    private DevelopmentComponent getDC(IProject aDCProject) {
        DevelopmentComponent aDC = null;
        IDevelopmentComponentNode theDCNode = ComponentUtil.getDCNode((IProject)aDCProject);
        if (theDCNode == null) {
            Util.showUserOutputViewer();
            this.theTracer.userOut(3, this.theMessageUtil.getString("Warning.Could.Not.Find.DCNode"));
            return null;
        }
        try {
            aDC = theDCNode.getDevelopmentComponent(true);
        }
        catch (Exception e) {
            Util.showUserOutputViewer();
            this.theTracer.userOut(2, e.toString());
        }
        return aDC;
    }

    public IProject getDCProject(Element element) {
        return DCProjectUtil.getParentProject(element);
    }

    public void updateDCProjects(IDevelopmentConfiguration aDevConf) {
        ProjectConsistencyManager aManager = ProjectConsistencyManager.getInstance((IDevelopmentConfiguration)aDevConf);
        ProgressMonitorDialog aProgressMonitor = new ProgressMonitorDialog(ComponentProviderPlugin.getPlugin().getMyShell());
        try {
            aProgressMonitor.run(false, false, (IRunnableWithProgress)aManager);
        }
        catch (InvocationTargetException ite) {
            Util.logExceptionMessage(this.theTracer, 2, this.getMessageUtil().getString("Exception.Occured"), ite);
        }
        catch (InterruptedException ie) {
            Util.logExceptionMessage(this.theTracer, 2, this.getMessageUtil().getString("Exception.Occured"), ie);
        }
    }

    public abstract void run(Element var1);

    public abstract boolean isEnabled(Element var1);

    public abstract boolean isAvailable(Element var1);

    public abstract ICategory getCategory();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        GENERATED_PP_NAMES.add("ejbjar");
        GENERATED_PP_NAMES.add("war");
    }

    static class ModObjectSelectionDialog
    extends ObjectSelectionDialog
    implements MouseListener {
        private Button theNewButton;
        private boolean isNewRequested;

        ModObjectSelectionDialog(Shell aShell, String aTitle, String aMessage) {
            super(aShell, aTitle, aMessage);
        }

        public void mouseDown(MouseEvent anEvent) {
        }

        public void mouseUp(MouseEvent anEvent) {
            this.close();
            this.isNewRequested = true;
        }

        public void mouseDoubleClick(MouseEvent anEvent) {
        }

        public boolean isNewRequested() {
            return this.isNewRequested;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.theNewButton = this.createButton(parent, 100, "New...", false);
            this.theNewButton.addMouseListener((MouseListener)this);
        }
    }
}

