/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.actions.dcmetadata;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.dcmdcommons.resources.MessageUtil;
import com.sap.ide.eclipse.component.dcmetadata.model.DCModel;
import com.sap.ide.eclipse.component.dcmetadata.model.IDCModel;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.tssap.dii.dtri.util.RepositoryObject;
import com.tssap.dii.dtri.util.RepositoryServiceException;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public abstract class ModifyDCCommand {
    private TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$provider$actions$dcmetadata$ModifyDCAction == null ? (class$com$sap$ide$eclipse$component$provider$actions$dcmetadata$ModifyDCAction = ModifyDCCommand.class$("com.sap.ide.eclipse.component.provider.actions.dcmetadata.ModifyDCAction")) : class$com$sap$ide$eclipse$component$provider$actions$dcmetadata$ModifyDCAction));
    private MessageUtil theMessageUtil = MessageUtil.getInstance("com.sap.ide.eclipse.component.dcmdcommons.resources.messages");
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$provider$actions$dcmetadata$ModifyDCAction;

    public MessageUtil getMessageUtil() {
        return this.theMessageUtil;
    }

    public IFile getDCFile(IProject theProject) {
        return this.getDevelopmentComponentFile(theProject);
    }

    public IDCModel getDCModel(IProject aDCProject) {
        DevelopmentComponent aDC = this.getDC(aDCProject);
        if (aDC == null) {
            Util.logExceptionMessage(this.theTracer, 3, this.theMessageUtil.getString("Warning.Could.Not.Find.DC"), null);
            return null;
        }
        IFile theDCFile = this.getDevelopmentComponentFile(aDCProject);
        if (theDCFile == null || !theDCFile.exists() || !theDCFile.isAccessible()) {
            String message = this.theMessageUtil.getString("Warning.Target.DC.NotAccessible");
            Util.showUserOutputViewer();
            this.theTracer.userOut(3, message);
            return null;
        }
        if (theDCFile.isReadOnly()) {
            try {
                RepositoryObject anObjectToEdit = new RepositoryObject("DC Definition", theDCFile.getName(), theDCFile.getProject());
                anObjectToEdit.addlResource((IResource)theDCFile);
                RepositoryObject.ResourceRepositoryStatus aStatus = anObjectToEdit.checkOut(false, null);
                if (!aStatus.status) {
                    Util.showUserOutputViewer();
                    this.theTracer.userOut(3, this.theMessageUtil.getString("Warning.Target.DC.Could.Not.Be.Checked.Out"));
                    return null;
                }
            }
            catch (RepositoryServiceException rse) {
                Util.showUserOutputViewer();
                this.theTracer.userOut(2, rse.getMessage());
                return null;
            }
        }
        IDCModel theDCModel = null;
        theDCModel = DCModel.getDevelopmentComponentModel(theDCFile);
        return theDCModel;
    }

    private IFile getDevelopmentComponentFile(IProject theDCProject) {
        IFile aFile;
        IFile aResult = null;
        if (theDCProject == null) {
            return null;
        }
        IResource aResource = theDCProject.findMember(".dcdef");
        aResult = aResource instanceof IFile ? (aFile = (IFile)aResource) : null;
        return aResult;
    }

    private DevelopmentComponent getDC(IProject aDCProject) {
        DevelopmentComponent aDC = null;
        IDevelopmentComponentNode theDCNode = com.sap.ide.eclipse.dii.component.ComponentUtil.getDCNode((IProject)aDCProject);
        if (theDCNode == null) {
            return null;
        }
        try {
            aDC = theDCNode.getDevelopmentComponent(true);
        }
        catch (Exception e) {
            Util.showUserOutputViewer();
            this.theTracer.userOut(2, e.getMessage());
        }
        return aDC;
    }

    public IProject getDCProject(Element element) {
        IDevelopmentComponentNode dcNode = ComponentUtil.getParentDCNode(element);
        if (dcNode == null) {
            return null;
        }
        return DCProjectUtil.getProject(dcNode);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

