/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.actions.dcmetadata;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.component.provider.UpdateUtil;
import com.sap.ide.eclipse.component.provider.actions.dcmetadata.AbstractMetaDataAction;
import com.sap.ide.eclipse.component.provider.actions.dcmetadata.ModifyPublicPartAction;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.ide.eclipse.component.provider.ui.message.ComponentProviderMessages;
import com.sap.ide.eclipse.dii.component.ProjectConsistencyManager;
import com.sap.ide.login.UserValidator;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.InvalidDefinitionException;
import com.sap.tc.devconf.RepositoryAccessException;
import com.tssap.dii.component.DCUtil;
import com.tssap.dii.dtri.util.RepositoryObject;
import com.tssap.dii.dtri.util.RepositoryServiceException;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import com.tssap.util.action.ICategory;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class DeletePPAction
extends AbstractMetaDataAction {
    protected static ComponentProviderPlugin myPlugin = ComponentProviderPlugin.getPlugin();
    private TracerI theTracer = TracingManager.getTracer(this.getClass());

    public ICategory getCategory() {
        return ComponentCategoryImage.CATEGORY__PP_DELETE;
    }

    public boolean isAvailable(Element element) {
        String[] subDomains = new String[]{"com.sap.ide.eclipse.component.DCMetaData.PPMetaData"};
        if (!this.isAvailable(element, subDomains)) {
            return false;
        }
        IProject dcProject = DCProjectUtil.getParentProject(element);
        if (dcProject != null) {
            boolean result = DCUtil.isDCProject((IProject)dcProject);
            return result;
        }
        return false;
    }

    public boolean isEnabled(Element element) {
        IFile aPPFile = this.getFile(element);
        if (aPPFile != null) {
            IDevelopmentComponentNode dcNode = ComponentUtil.getParentDCNode(element);
            if (dcNode == null || dcNode.isInstalledLocally()) {
                return false;
            }
            try {
                boolean isGenerated = this.isGenerated(element);
                if (isGenerated) {
                    return false;
                }
            }
            catch (Exception e) {
                Util.logExceptionMessage(this.theTracer, 3, ComponentProviderMessages.getString("warning.failed.to.get.dc.information"), e);
                return false;
            }
            if (dcNode.isLocalOnlySource()) {
                return true;
            }
            if (UserValidator.isDefaultServerOnline()) {
                return dcNode.isSynchedAsSource();
            }
            return dcNode.isSynchedAsSource() && !aPPFile.isReadOnly();
        }
        return false;
    }

    private boolean isGenerated(Element element) throws RepositoryAccessException, InvalidDefinitionException {
        IDevelopmentComponentNode dcNode = ComponentUtil.getParentDCNode(element);
        DevelopmentComponent aDC = dcNode.getDevelopmentComponent(true);
        String aDCType = aDC.getComponentType().getType();
        if (aDCType.startsWith("J2EE")) {
            Object aPP = ObjectUtil.getComponentObject(element);
            if (aPP == null || !(aPP instanceof PublicPart)) {
                Util.logExceptionMessage(this.theTracer, 3, ComponentProviderMessages.getString("warning.could.not.determine.pp.for.element"), null);
                return false;
            }
            PublicPart aPublicPart = (PublicPart)aPP;
            String aPPName = aPublicPart.getName();
            if (ModifyPublicPartAction.GENERATED_PP_NAMES.contains(aPPName) || aPPName.equals("client")) {
                return true;
            }
        }
        return false;
    }

    public void run(Element element) {
        IFile file = this.getFile(element);
        if (file != null) {
            String ppName = element.getUniqueName().getName();
            IDevelopmentComponentNode dcNode = ComponentUtil.getParentDCNode(element);
            IDevelopmentConfiguration aDevConf = ComponentUtil.getParentDevConf(element);
            if (dcNode.isInstalledLocally()) {
                return;
            }
            if (aDevConf != null && !Util.saveSensitiveEditors(aDevConf)) {
                return;
            }
            boolean successfullDeleted = false;
            if (dcNode.isLocalOnlySource()) {
                try {
                    file.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    this.updatePParts(dcNode, ppName);
                    Entity aParent = ObjectUtil.getParent(element);
                    element.delete();
                    UpdateUtil.updateElement((Element)aParent, ModelDeltaNodeKind.TOTALLY_CHANGED);
                    successfullDeleted = true;
                }
                catch (CoreException e) {
                    Util.logExceptionMessage(this.theTracer, 2, "PP Delete failed", e);
                    Util.showException(e, null);
                }
            } else if (dcNode.isSynchedAsModifiableSource()) {
                try {
                    RepositoryObject anObjectToDelete = new RepositoryObject("PublicPart", ppName, file.getProject());
                    anObjectToDelete.addlResource((IResource)file);
                    RepositoryObject.ResourceRepositoryStatus aStatus = anObjectToDelete.checkOutForDelete(true, null);
                    if (aStatus.status) {
                        this.updatePParts(dcNode, ppName);
                        element.delete();
                        successfullDeleted = true;
                    }
                }
                catch (RepositoryServiceException rse) {
                    Util.logExceptionMessage(this.theTracer, 2, "PP Delete failed", rse);
                    Util.showException(rse, null);
                }
            }
            if (successfullDeleted) {
                if (aDevConf != null) {
                    this.updateDCProjects(aDevConf);
                } else {
                    Util.logExceptionMessage(this.theTracer, 3, "Warning.DevConf.Not.Updated", null);
                }
            }
        }
    }

    private void updatePParts(IDevelopmentComponentNode dcNode, String ppName) {
        IDCProxy dcProxy = null;
        try {
            dcProxy = dcNode.getDCProxy();
        }
        catch (DevConfigException e) {
            Util.logExceptionMessage(this.theTracer, 3, ComponentProviderMessages.format("dcProxyIsNull.ActionFailed.error", new String[]{dcNode.getName()}), null);
        }
        if (dcProxy != null) {
            Map pps = dcProxy.getComponent().getPublicParts();
            if (pps != null) {
                pps.remove(ppName);
            }
            dcNode.refresh();
        }
    }

    private void updateDCProjects(IDevelopmentConfiguration aDevConf) {
        ProjectConsistencyManager aManager = ProjectConsistencyManager.getInstance((IDevelopmentConfiguration)aDevConf);
        ProgressMonitorDialog aProgressMonitor = new ProgressMonitorDialog(ComponentProviderPlugin.getPlugin().getMyShell());
        try {
            aProgressMonitor.run(false, false, (IRunnableWithProgress)aManager);
        }
        catch (InvocationTargetException ite) {
            Util.logExceptionMessage(this.theTracer, 2, "Exception.Occured", ite);
        }
        catch (InterruptedException ie) {
            Util.logExceptionMessage(this.theTracer, 2, "Exception.Occured", ie);
        }
    }

    private IFile getFile(Element element) {
        IProject selectedProject = DCProjectUtil.getProject(ComponentUtil.getParentDCElement(element));
        if (selectedProject == null) {
            return null;
        }
        IFile file = selectedProject.getFile("def" + File.separator + element.getUniqueName().getName() + ".pp");
        if (file != null && file.exists()) {
            return file;
        }
        return null;
    }
}

