/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.actions.dcmetadata;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.dcmetadata.model.IPPModel;
import com.sap.ide.eclipse.component.dcmetadata.view.EntitiesInputShell;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.component.provider.actions.dcmetadata.AddPPCollectionElement;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.tc.complib.PublicPart;
import com.tssap.dii.component.DCUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.action.ICategory;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public class AddEntityAction
extends AddPPCollectionElement {
    private TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$provider$actions$dcmetadata$AddEntityAction == null ? (class$com$sap$ide$eclipse$component$provider$actions$dcmetadata$AddEntityAction = AddEntityAction.class$("com.sap.ide.eclipse.component.provider.actions.dcmetadata.AddEntityAction")) : class$com$sap$ide$eclipse$component$provider$actions$dcmetadata$AddEntityAction));
    private Set thePackages = new HashSet();
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$provider$actions$dcmetadata$AddEntityAction;

    public void run(Element element) {
        IProject theProject = this.getDCProject(element);
        if (theProject == null) {
            return;
        }
        Object aParentPP = ObjectUtil.getComponentObject(element);
        if (aParentPP == null || !(aParentPP instanceof PublicPart)) {
            return;
        }
        PublicPart thePP = (PublicPart)aParentPP;
        IPPModel thePPModel = this.getPPModel(theProject, thePP.getName());
        if (thePPModel == null) {
            return;
        }
        this.updatePackagesFromProject(theProject);
        EntitiesInputShell inputShell = new EntitiesInputShell(thePPModel, this.thePackages, -1, false);
        Shell shell = new Shell(ComponentProviderPlugin.getPlugin().getMyShell(), 65648);
        WizardDialog theWizardDialog = new WizardDialog(shell, (IWizard)inputShell);
        int aReturnCode = theWizardDialog.open();
        if (aReturnCode == 0 && this.theTracer.debug()) {
            this.theTracer.debug("Added new entity");
        }
    }

    private void updatePackagesFromProject(IProject theProject) {
        boolean isJava = false;
        try {
            isJava = theProject.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException ce) {
            Util.logExceptionMessage(this.theTracer, 2, "Exception.Occured", ce);
        }
        if (isJava) {
            IJavaProject theJavaProjectOfTheDC = JavaCore.create((IProject)theProject);
            this.updatePackagesFromJavaProject(theJavaProjectOfTheDC);
        } else if (this.thePackages.size() > 0) {
            this.thePackages.clear();
        }
    }

    private void updatePackagesFromJavaProject(IJavaProject theJavaProject) {
        try {
            IPackageFragment[] theJavaPackages = theJavaProject.getPackageFragments();
            ArrayList<IPackageFragment> theSourcePackages = new ArrayList<IPackageFragment>();
            int i = 0;
            while (i < theJavaPackages.length) {
                if (theJavaPackages[i].getKind() == 1) {
                    theSourcePackages.add(theJavaPackages[i]);
                }
                ++i;
            }
            Comparator aComparator = new Comparator(){

                public int compare(Object aPackage, Object aSecondPackage) {
                    IPackageFragment aFragment = (IPackageFragment)aPackage;
                    IPackageFragment aSecondFragment = (IPackageFragment)aSecondPackage;
                    Collator aCollator = Collator.getInstance();
                    int result = aCollator.compare(aFragment.getElementName(), aSecondFragment.getElementName());
                    return result;
                }
            };
            Collections.sort(theSourcePackages, aComparator);
            ArrayList theSortedPackages = new ArrayList(this.thePackages);
            Comparator aSecondComparator = new Comparator(){

                public int compare(Object aObject, Object aSecondObject) {
                    String aPackageName = (String)aObject;
                    String aSecondPackageName = (String)aSecondObject;
                    Collator aCollator = Collator.getInstance();
                    int result = aCollator.compare(aPackageName, aSecondPackageName);
                    return result;
                }
            };
            Collections.sort(theSortedPackages, aSecondComparator);
            boolean hasChanged = false;
            if (theSourcePackages.size() != this.thePackages.size()) {
                hasChanged = true;
            } else {
                int size = theSourcePackages.size();
                int i2 = 0;
                while (i2 < size) {
                    IPackageFragment aNewPackage = (IPackageFragment)theSourcePackages.get(i2);
                    String aOldPackageName = (String)theSortedPackages.get(i2);
                    if (!aNewPackage.getElementName().equals(aOldPackageName.replace('/', '.'))) {
                        hasChanged = true;
                        break;
                    }
                    ++i2;
                }
            }
            if (hasChanged) {
                this.thePackages.clear();
                AddEntityAction.addJavaPackages(this.thePackages, theSourcePackages.toArray(new IPackageFragment[theSourcePackages.size()]));
            }
        }
        catch (JavaModelException jme) {
            Util.logExceptionMessage(this.theTracer, 2, "Exception.Occured", jme);
            Util.logExceptionMessage(this.theTracer, 3, "Warning.Packages.Not.Found", null);
        }
    }

    private static void addJavaPackages(Set packages, IPackageFragment[] theSourceFragements) {
        int numberOfPackages = theSourceFragements.length;
        int i = 0;
        while (i < numberOfPackages) {
            String aStringPackage = theSourceFragements[i].getElementName().replace('.', '/');
            packages.add(aStringPackage);
            ++i;
        }
    }

    public boolean isAvailable(Element element) {
        String[] subDomains = new String[]{"com.sap.ide.eclipse.component.DCMetaData.PPEntityFolder"};
        if (!this.isAvailable(element, subDomains)) {
            return false;
        }
        IProject dcProject = DCProjectUtil.getParentProject(element);
        if (dcProject != null) {
            boolean result = DCUtil.isDCProject((IProject)dcProject);
            return result;
        }
        return false;
    }

    public ICategory getCategory() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

