/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.actions.dc;

import com.sap.tc.devconf.DCActivityState;
import com.sap.tc.devconf.DCNodeSyncMode;
import com.sap.tc.devconf.DCNodeSyncState;
import com.sap.tc.devconf.IDevConfListener;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.util.Logbook;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.List;

public class WorkerThreadConsistency {
    private static int __isWorkerThreadActive;
    private static final Location LOCATION;
    private static List __dcChangesQueue;
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$provider$actions$dc$WorkerThreadConsistency;

    public static synchronized boolean isWorkerThreadActive() {
        return __isWorkerThreadActive != 0;
    }

    public static synchronized void setWorkerThreadActive() {
        ++__isWorkerThreadActive;
    }

    public static synchronized void resetWorkerThreadActive() {
        if (--__isWorkerThreadActive < 0) {
            throw new IllegalStateException("workerThreadActive counter got negative!");
        }
        if (__isWorkerThreadActive == 0) {
            WorkerThreadConsistency.fireEvents();
        }
    }

    private static void fireEvents() {
        String METHOD = "fireEvents";
        if (LOCATION.bePath()) {
            String msg = "Firing " + __dcChangesQueue.size() + " delayed DC events in " + Thread.currentThread().getName() + " thread...";
            LOCATION.pathT("fireEvents", msg);
            Logbook.getInfoChapter().println(msg);
        }
        AbstractOnDCEvent[] events = __dcChangesQueue.toArray(new AbstractOnDCEvent[0]);
        int i = 0;
        while (i < events.length) {
            AbstractOnDCEvent event = events[i];
            event.fire();
            ++i;
        }
        if (events.length != __dcChangesQueue.size()) {
            throw new ConcurrentModificationException("Threading problem: new events occured while handling all others.");
        }
        __dcChangesQueue.clear();
    }

    public static void onDCSyncStateChanged(IDevConfListener actualListener, IDevelopmentComponentNode dcNode, DCNodeSyncState oldState) {
        __dcChangesQueue.add(new OnDCSyncStateChangedEvent(actualListener, dcNode, oldState));
    }

    public static void onDCSyncModeChanged(IDevConfListener actualListener, IDevelopmentComponentNode dcNode, DCNodeSyncMode oldMode) {
        __dcChangesQueue.add(new OnDCSyncModeChangedEvent(actualListener, dcNode, oldMode));
    }

    public static void onDCActivityStateChanged(IDevConfListener actualListener, IDevelopmentComponentNode dcNode, DCActivityState oldState) {
        __dcChangesQueue.add(new OnDCActivityStateChangedEvent(actualListener, dcNode, oldState));
    }

    public static void onDCChanged(IDevConfListener actualListener, IDevelopmentComponentNode dcNode) {
        __dcChangesQueue.add(new OnDCChangedEvent(actualListener, dcNode));
    }

    public static void onDCsBuildStatusChanged(IDevConfListener actualListener, IDevelopmentComponentNode[] affectedDCs) {
        __dcChangesQueue.add(new OnDCsBuildStatusChangedEvent(actualListener, affectedDCs));
    }

    public static void onDCDeleted(IDevConfListener actualListener, IDevelopmentComponentNode dcNode) {
        __dcChangesQueue.add(new OnDCDeletedEvent(actualListener, dcNode));
    }

    public static void onDCCreated(IDevConfListener actualListener, IDevelopmentComponentNode dcNode) {
        __dcChangesQueue.add(new OnDCCreatedEvent(actualListener, dcNode));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        LOCATION = Location.getLocation((Class)(class$com$sap$ide$eclipse$component$provider$actions$dc$WorkerThreadConsistency == null ? (class$com$sap$ide$eclipse$component$provider$actions$dc$WorkerThreadConsistency = WorkerThreadConsistency.class$("com.sap.ide.eclipse.component.provider.actions.dc.WorkerThreadConsistency")) : class$com$sap$ide$eclipse$component$provider$actions$dc$WorkerThreadConsistency));
        __dcChangesQueue = Collections.synchronizedList(new LinkedList());
    }

    private static class OnDCCreatedEvent
    extends AbstractOnDCEvent {
        final IDevelopmentComponentNode _dcNode;

        OnDCCreatedEvent(IDevConfListener actualListener, IDevelopmentComponentNode dcNode) {
            super(actualListener);
            this._dcNode = dcNode;
        }

        void fire() {
            this._actualListener.onDCCreated(this._dcNode);
        }
    }

    private static class OnDCDeletedEvent
    extends AbstractOnDCEvent {
        final IDevelopmentComponentNode _dcNode;

        OnDCDeletedEvent(IDevConfListener actualListener, IDevelopmentComponentNode dcNode) {
            super(actualListener);
            this._dcNode = dcNode;
        }

        void fire() {
            this._actualListener.onDCDeleted(this._dcNode);
        }
    }

    private static class OnDCChangedEvent
    extends AbstractOnDCEvent {
        final IDevelopmentComponentNode _dcNode;

        OnDCChangedEvent(IDevConfListener actualListener, IDevelopmentComponentNode dcNode) {
            super(actualListener);
            this._dcNode = dcNode;
        }

        void fire() {
            this._actualListener.onDCChanged(this._dcNode);
        }
    }

    private static class OnDCsBuildStatusChangedEvent
    extends AbstractOnDCEvent {
        final IDevelopmentComponentNode[] _affectedDCs;

        OnDCsBuildStatusChangedEvent(IDevConfListener actualListener, IDevelopmentComponentNode[] affectedDCs) {
            super(actualListener);
            this._affectedDCs = affectedDCs;
        }

        void fire() {
            this._actualListener.onDCsBuildStatusChanged(this._affectedDCs);
        }
    }

    private static class OnDCActivityStateChangedEvent
    extends AbstractOnDCEvent {
        final IDevelopmentComponentNode _dcNode;
        final DCActivityState _oldState;

        OnDCActivityStateChangedEvent(IDevConfListener actualListener, IDevelopmentComponentNode dcNode, DCActivityState oldState) {
            super(actualListener);
            this._dcNode = dcNode;
            this._oldState = oldState;
        }

        void fire() {
            this._actualListener.onDCActivityStateChanged(this._dcNode, this._oldState);
        }
    }

    private static class OnDCSyncModeChangedEvent
    extends AbstractOnDCEvent {
        final IDevelopmentComponentNode _dcNode;
        final DCNodeSyncMode _oldMode;

        OnDCSyncModeChangedEvent(IDevConfListener actualListener, IDevelopmentComponentNode dcNode, DCNodeSyncMode oldMode) {
            super(actualListener);
            this._dcNode = dcNode;
            this._oldMode = oldMode;
        }

        void fire() {
            this._actualListener.onDCSyncModeChanged(this._dcNode, this._oldMode);
        }
    }

    private static class OnDCSyncStateChangedEvent
    extends AbstractOnDCEvent {
        final IDevelopmentComponentNode _dcNode;
        final DCNodeSyncState _oldState;

        OnDCSyncStateChangedEvent(IDevConfListener actualListener, IDevelopmentComponentNode dcNode, DCNodeSyncState oldState) {
            super(actualListener);
            this._dcNode = dcNode;
            this._oldState = oldState;
        }

        void fire() {
            this._actualListener.onDCSyncStateChanged(this._dcNode, this._oldState);
        }
    }

    private static abstract class AbstractOnDCEvent {
        final IDevConfListener _actualListener;

        AbstractOnDCEvent(IDevConfListener actualListener) {
            this._actualListener = actualListener;
        }

        abstract void fire();
    }
}

