/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.actions.dc;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.component.provider.actions.dc.DCProjectUpdateAction;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.RemovalException;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.trace.TracingManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class DcRemoveActionImpl
extends DCProjectUpdateAction {
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$provider$actions$dc$DcRemoveActionImpl;

    public DcRemoveActionImpl(Element element, IDevelopmentComponentNode dcNode) {
        super(TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$provider$actions$dc$DcRemoveActionImpl == null ? (class$com$sap$ide$eclipse$component$provider$actions$dc$DcRemoveActionImpl = DcRemoveActionImpl.class$("com.sap.ide.eclipse.component.provider.actions.dc.DcRemoveActionImpl")) : class$com$sap$ide$eclipse$component$provider$actions$dc$DcRemoveActionImpl)));
        this.theSelenaElement = element;
    }

    public void run() {
        IProject project;
        Object object = ObjectUtil.getComponentObject(this.theSelenaElement);
        if (!(object instanceof IDevelopmentComponentNode)) {
            return;
        }
        Shell shell = ComponentProviderPlugin.getPlugin().getMyShell();
        IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)object;
        IDCProxy dcInfo = null;
        try {
            dcInfo = dcNode.getDCProxy();
        }
        catch (DevConfigException e) {
            Util.showException(e, null);
            return;
        }
        if (dcNode.isLocalOnlySource()) {
            String title = "Confirm Delete";
            String label = "Are you sure you want to delete '" + dcInfo.getName() + "'?";
            if (!MessageDialog.openQuestion((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)title, (String)label)) {
                return;
            }
            try {
                dcInfo.removeLocalDC(true);
            }
            catch (RemovalException e) {
                Util.logExceptionMessage(this.theTracer, 2, "DC Remove Action failed", null);
                Util.showException(e, null);
                return;
            }
            catch (DevConfigException e) {
                Util.logExceptionMessage(this.theTracer, 2, "DC Remove Action failed", null);
                Util.showException(e, null);
                return;
            }
        }
        if ((project = DCProjectUtil.getProject(this.theSelenaElement)) != null && project.exists()) {
            try {
                project.delete(false, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Util.logExceptionMessage(this.theTracer, 3, "Project deletion failed", e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

