/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.actions.dc;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.ide.eclipse.component.wizard.ProjectWizard;
import com.sap.tc.devconf.ICompartmentNode;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.ISoftwareComponentNode;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public class DcNewAction
implements IElementSingleAction {
    protected static ComponentProviderPlugin myPlugin = ComponentProviderPlugin.getPlugin();
    private TracerI theTracer = TracingManager.getTracer(this.getClass());

    public ICategory getCategory() {
        return ComponentCategoryImage.getDispCat(Category.DEFAULT, "Create New DC...");
    }

    public boolean isAvailable(Element element) {
        String domain = element.getUniqueName().getDomain();
        if (domain != "com.sap.ide.eclipse.component") {
            return false;
        }
        String subDomain = element.getUniqueName().getSubDomain();
        if ("com.sap.ide.eclipse.component.SC.inactive".equals(subDomain) || "com.sap.ide.eclipse.component.SC.active".equals(subDomain) || "com.sap.ide.eclipse.component.compartment".equals(subDomain)) {
            Object obj = ObjectUtil.getComponentObject(element);
            if (obj instanceof ICompartmentNode) {
                ICompartmentNode compNode = (ICompartmentNode)obj;
                if ("com.sap.ide.eclipse.component.SC.active".equals(subDomain) && compNode.getCompartment().hasInactiveSourceState()) {
                    return false;
                }
                return compNode.modificationAllowed();
            }
            if (obj instanceof ISoftwareComponentNode) {
                ISoftwareComponentNode scNode = (ISoftwareComponentNode)obj;
                return scNode.modificationAllowed();
            }
        }
        return false;
    }

    public boolean isEnabled(Element element) {
        return true;
    }

    public void run(Element element) {
        Object obj;
        IDevelopmentConfiguration config = ComponentUtil.getParentDevConf(element);
        ICompartmentNode compNode = ComponentUtil.getParentCompartmentNode(element);
        IDevelopmentComponentNode parentNode = null;
        if ("com.sap.ide.eclipse.component.DC".equals(element.getUniqueName().getSubDomain()) && (obj = ObjectUtil.getComponentObject(element)) instanceof IDevelopmentComponentNode) {
            parentNode = (IDevelopmentComponentNode)obj;
        }
        if (compNode == null) {
            return;
        }
        try {
            ProjectWizard wizard = new ProjectWizard();
            wizard.init(config, compNode, parentNode);
            Shell shell = ComponentProviderPlugin.getPlugin().getMyShell();
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            dialog.open();
        }
        catch (Throwable e) {
            Util.logExceptionMessage(this.theTracer, 2, "Open DC Wizard failed", e);
            Util.showException(e, null);
        }
    }
}

