/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.actions.dc;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.component.provider.actions.dcproject.AbstractDCMultiProjectAction;
import com.sap.ide.eclipse.sdm.SDMManager;
import com.sap.tc.devconf.DCUsageFilter;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.action.ICategory;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.dialog.UserDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BuildAction;

public class DcDeployAction
extends AbstractDCMultiProjectAction
implements IWorkbenchWindowActionDelegate {
    private static TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$provider$actions$dc$DcDeployAction == null ? (class$com$sap$ide$eclipse$component$provider$actions$dc$DcDeployAction = DcDeployAction.class$("com.sap.ide.eclipse.component.provider.actions.dc.DcDeployAction")) : class$com$sap$ide$eclipse$component$provider$actions$dc$DcDeployAction));
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$provider$actions$dc$DcDeployAction;

    public boolean isAvailable(Element[] el) {
        if (el == null) {
            return false;
        }
        return this.isEnabled(el);
    }

    public boolean isEnabled(Element[] el) {
        int i = 0;
        while (i < el.length) {
            Element element = el[i];
            IDevelopmentComponentNode dcNode = ComponentUtil.getDCNode(element);
            if (dcNode == null) {
                return false;
            }
            if (!dcNode.isLocalOnlySource() && !dcNode.isSynched()) {
                return false;
            }
            File[] files = this.getDeployableFiles(dcNode);
            if (files.length == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private File[] getDeployableFiles(IDevelopmentComponentNode dcNode) {
        String buildVariant;
        IDevelopmentConfiguration developmentConfiguration = dcNode.getConfiguration();
        String compartmentName = dcNode.getCompartmentName();
        try {
            buildVariant = developmentConfiguration.getDefaultBuildVariant(compartmentName);
        }
        catch (DevConfigException e) {
            Util.logException(theTracer, e);
            return new File[0];
        }
        String deployableFolderPath = dcNode.getDeployableFolder(buildVariant);
        File deployableFolder = new File(deployableFolderPath);
        if (!deployableFolder.exists() || !deployableFolder.isDirectory()) {
            return new File[0];
        }
        File[] files = deployableFolder.listFiles();
        return files;
    }

    public void run(IAction action) {
        List dcNodesInDeployOrder;
        if (this.dcList == null || this.dcList.isEmpty()) {
            return;
        }
        ArrayList dcNodeElements = new ArrayList();
        this.devConfSet = this.collectConfigurations(this.dcList.toArray(new Element[this.dcList.size()]), dcNodeElements);
        ArrayList<IDevelopmentComponentNode> dcNodes = new ArrayList<IDevelopmentComponentNode>();
        Iterator it = dcNodeElements.iterator();
        while (it.hasNext()) {
            Element dcElement = (Element)it.next();
            IDevelopmentComponentNode dcNode = ComponentUtil.getDCNode(dcElement);
            if (dcNode == null) {
                Util.logExceptionMessage(theTracer, 3, "No IDevelopmentComponent Instance for " + dcElement.getUniqueName() + " (null)", null);
                continue;
            }
            dcNodes.add(dcNode);
        }
        if (dcNodes.size() == 0) {
            return;
        }
        IDevelopmentConfiguration developmentConfiguration = ((IDevelopmentComponentNode)dcNodes.get(0)).getConfiguration();
        ArrayList exceptions = new ArrayList();
        DCUsageFilter usageFilter = new DCUsageFilter(false, false, false, true, false);
        try {
            dcNodesInDeployOrder = developmentConfiguration.orderLocalDCsByDependencies(dcNodes, true, exceptions, usageFilter);
        }
        catch (DevConfigException e) {
            throw new IllegalStateException(e.getMessage());
        }
        Iterator iterator = dcNodesInDeployOrder.iterator();
        while (iterator.hasNext()) {
            IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)iterator.next();
            File[] deployableFiles = this.getDeployableFiles(dcNode);
            int i = 0;
            while (i < deployableFiles.length) {
                File deployableFile = deployableFiles[i];
                this.asyncDeploy(deployableFile);
                ++i;
            }
        }
    }

    private void asyncDeploy(File deployableFile) {
        if (SDMManager.getInstance().canDeployArchiveAsync(deployableFile)) {
            Display currentDisplay = Display.getDefault().getActiveShell().getDisplay();
            try {
                BackgroundDeployThread.deployAsync(deployableFile);
            }
            catch (Exception ex) {
                UserDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Could not deploy successfully", (String)("The deployment of the archive failed with an exception!\n(" + ex.getMessage() + ")" + "\nCheck the error log for further informations."));
            }
        } else {
            UserDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Cannot deploy", (String)"The deployment of the archive is already running !\nWait until it is finished (watch the Deploy Output View).");
        }
    }

    public boolean shouldUpdateProject() {
        return true;
    }

    protected IAction getDCAction(Element el) {
        return null;
    }

    public void run(Element[] elements) {
        this.dcList = new ArrayList();
        int i = 0;
        while (i < elements.length) {
            Element element = elements[i];
            if (this.isAvailable(new Element[]{element})) {
                this.dcList.add(element);
            }
            ++i;
        }
        this.run((IAction)null);
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public static void saveAllDCProjects(Collection dcList) {
        if (dcList == null || dcList.isEmpty()) {
            return;
        }
        if (!BuildAction.isSaveAllSet()) {
            return;
        }
        ArrayList<IProject> projects = new ArrayList<IProject>();
        Iterator it = dcList.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            IProject project = null;
            if (obj instanceof IDevelopmentComponentNode) {
                project = DCProjectUtil.getProject((IDevelopmentComponentNode)obj);
            } else if (obj instanceof IDCProxy) {
                project = DCProjectUtil.getProject((IDCProxy)obj);
            } else if (obj instanceof Element) {
                project = DCProjectUtil.getParentProject((Element)obj);
            }
            if (project == null || !project.isOpen()) continue;
            projects.add(project);
        }
        DcDeployAction.saveAllProjectResources(projects);
    }

    public static void saveAllProjectResources(Collection projects) {
        if (projects == null || projects.isEmpty()) {
            return;
        }
        if (!BuildAction.isSaveAllSet()) {
            return;
        }
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int j = 0;
            while (j < pages.length) {
                IWorkbenchPage page = pages[j];
                IEditorPart[] editors = page.getDirtyEditors();
                int k = 0;
                while (k < editors.length) {
                    IFile inputFile;
                    IEditorPart editor = editors[k];
                    IEditorInput input = editor.getEditorInput();
                    if (input instanceof IFileEditorInput && projects.contains((inputFile = ((IFileEditorInput)input).getFile()).getProject())) {
                        page.saveEditor(editor, false);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public ICategory getCategory() {
        return ComponentCategoryImage.CATEGORY__DC_DEPLOY;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class BackgroundDeployThread {
        private static Queue _queue = new Queue();

        BackgroundDeployThread() {
        }

        static void deployAsync(File deployableFile) {
            _queue.nq(new Runnable(deployableFile){
                private final /* synthetic */ File val$deployableFile;
                {
                    this.val$deployableFile = val$deployableFile;
                }

                public void run() {
                    try {
                        SDMManager.getInstance().deployArchive(this.val$deployableFile, DcDeployAction.access$100());
                    }
                    catch (Exception x) {
                        UserDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Could not deploy successfully", (String)("The deployment of the archive failed with an exception!\n(" + x.getMessage() + ")" + "\nCheck the error log for further informations."));
                    }
                }
            });
        }

        static /* synthetic */ Queue access$000() {
            return _queue;
        }

        static {
            new Thread(new Runnable(){

                public void run() {
                    while (!Thread.interrupted()) {
                        Runnable action = BackgroundDeployThread.access$000().dq();
                        try {
                            action.run();
                        }
                        catch (Exception x) {
                            UserDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Could not deploy successfully", (String)("The deployment of the archive failed with an exception!\n(" + x.getMessage() + ")" + "\nCheck the error log for further informations."));
                        }
                    }
                }
            }, "BackgroundDeployThread").start();
        }

        static class Queue {
            final LinkedList q = new LinkedList();
            volatile int nqs = 0;
            volatile int dqs = 0;
            static final int MAX_Q = 10000;
            private volatile int inWork = 0;

            Queue() {
            }

            void nq(Runnable action) {
                Queue queue;
                while (this.nqs - this.dqs >= 10000) {
                    queue = this;
                    synchronized (queue) {
                        this.notify();
                    }
                    Thread.yield();
                }
                queue = this;
                synchronized (queue) {
                    this.q.addFirst(action);
                    ++this.nqs;
                    this.notify();
                }
            }

            synchronized Runnable dq() {
                while (this.q.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Util.logExceptionMessage(theTracer, 3, "Action was interrupted", e);
                    }
                }
                ++this.dqs;
                ++this.inWork;
                return (Runnable)this.q.removeLast();
            }

            synchronized void done() {
                if (this.inWork > 0) {
                    --this.inWork;
                }
            }

            synchronized boolean isIdle() {
                return this.inWork == 0;
            }
        }
    }
}

