/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.actions.dc;

import com.sap.ide.eclipse.component.core.DCProject;
import com.sap.ide.eclipse.component.core.SelectDCsDialog;
import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.component.provider.actions.dc.AbstractDcMultiAction;
import com.sap.ide.eclipse.component.provider.actions.dc.UsedDCFoundHandler;
import com.sap.ide.eclipse.component.provider.actions.dc.UsedDCFoundHandlerForBuildDcs;
import com.sap.ide.eclipse.component.provider.actions.dc.WorkerThreadConsistency;
import com.sap.ide.eclipse.component.provider.listener.WorkspaceResourceListener;
import com.sap.ide.eclipse.component.wizard.DCWizardUtil;
import com.sap.ide.eclipse.dii.component.DCBuildSettings;
import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.ide.login.UserValidator;
import com.sap.tc.buildtool.IBuildResult;
import com.sap.tc.complib.ComponentType;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.PPReference;
import com.sap.tc.devconf.BuildException;
import com.sap.tc.devconf.DCNodeSyncMode;
import com.sap.tc.devconf.DCNodeSyncState;
import com.sap.tc.devconf.DCUsageFilter;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDCNodeResult;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.IUsedDCFoundHandler;
import com.sap.tc.devconf.InvalidDefinitionException;
import com.sap.tc.devconf.RepositoryAccessException;
import com.sap.tc.devconf.SyncException;
import com.sap.tc.devconf.UsedDCSearchInstruction;
import com.tssap.dii.component.DCProjectInfo;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.action.ICategory;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class DcCreateProjectAction
extends AbstractDcMultiAction {
    final boolean USE_OLD_BEHAVIOR_BEFORE_TASKFORCE = Boolean.getBoolean("dii.classic_dependencies_check_for_sync");
    public static final boolean RECURSE = true;
    public static final boolean DONT_RECURSE = false;
    private static TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$provider$actions$dc$DcCreateProjectAction == null ? (class$com$sap$ide$eclipse$component$provider$actions$dc$DcCreateProjectAction = DcCreateProjectAction.class$("com.sap.ide.eclipse.component.provider.actions.dc.DcCreateProjectAction")) : class$com$sap$ide$eclipse$component$provider$actions$dc$DcCreateProjectAction));
    private boolean automaticDCBuild = true;
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$provider$actions$dc$DcCreateProjectAction;

    public ICategory getCategory() {
        return ComponentCategoryImage.CATEGORY__DC_PROJECT_CREATE;
    }

    public boolean isAvailable(Element[] elements) {
        if (!super.isAvailable(elements)) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            IDevelopmentComponentNode dcNode;
            Element element = elements[i];
            if (null == DCProjectUtil.getProject(element) && (dcNode = ComponentUtil.getDCNode(element)) != null && dcNode.hasSourceState()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IAction getDCAction(Element element, IDevelopmentComponentNode dcNode) {
        return null;
    }

    public boolean shouldUpdateProject() {
        return true;
    }

    public void run(Element[] elements) {
        this.execute(elements, "Create Project(s)", true, true, false);
    }

    protected void execute(Element[] elements, String actionName, boolean createProject, boolean syncUsedDCs, boolean syncSourcesForSelectedDCs) {
        this.execute(elements, new ArrayList(), actionName, createProject, syncUsedDCs, syncSourcesForSelectedDCs, null);
    }

    public void execute(Element[] elements, final List myElements, final String actionName, final boolean createProject, final boolean syncUsedDCs, boolean syncSourcesForSelectedDCs, List initialToSyncDCList) {
        if (myElements == null) {
            return;
        }
        if (elements == null && myElements.isEmpty()) {
            return;
        }
        final ArrayList<Exception> exceptions = new ArrayList<Exception>();
        this.devConfSet = new HashSet();
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                Element element = elements[i];
                if (this.isAvailable(new Element[]{element})) {
                    IDevelopmentComponentNode dcNode = ComponentUtil.getDCNode(element);
                    if (dcNode == null) {
                        Exception ex = new Exception("no DC Node for" + element.getUniqueName());
                        Util.logExceptionMessage(theTracer, 2, actionName + " failed: get DC Node failed", ex);
                        exceptions.add(ex);
                    } else {
                        myElements.add(dcNode);
                        if (this.shouldUpdateProject()) {
                            this.devConfSet.add(dcNode.getConfiguration());
                        }
                    }
                }
                ++i;
            }
        } else if (this.shouldUpdateProject()) {
            Iterator it = myElements.iterator();
            while (it.hasNext()) {
                IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)it.next();
                this.devConfSet.add(dcNode.getConfiguration());
            }
        }
        if (this.shouldUpdateProject() && !this.saveEditors()) {
            return;
        }
        final ArrayList projectList = new ArrayList();
        final ArrayList allDCsList = new ArrayList();
        List tempList = null;
        if (initialToSyncDCList == null) {
            Map dependenciesMap = new HashMap();
            Collection buildDependencies = new ArrayList();
            if (syncUsedDCs) {
                if (this.USE_OLD_BEHAVIOR_BEFORE_TASKFORCE) {
                    dependenciesMap = DcCreateProjectAction.beforeTaskforce_collectDependencies(myElements);
                    buildDependencies = DcCreateProjectAction.beforeTaskforce_collectBuildDependencies(dependenciesMap, exceptions);
                } else {
                    dependenciesMap = DcCreateProjectAction.collectDependencies(myElements, true);
                    buildDependencies = DcCreateProjectAction.collectBuildDependencies(dependenciesMap, exceptions);
                }
                allDCsList.addAll(DcCreateProjectAction.dependencyMapToSet(dependenciesMap));
                allDCsList.addAll(buildDependencies);
            }
            if ((tempList = this.selectDCsToSync(dependenciesMap, buildDependencies, syncSourcesForSelectedDCs || createProject ? myElements : new ArrayList(), syncSourcesForSelectedDCs)) == null) {
                return;
            }
        } else {
            tempList = initialToSyncDCList;
        }
        final List toSyncDCList = tempList;
        ProgressMonitorDialog progressMonitor = new ProgressMonitorDialog(ComponentProviderPlugin.getPlugin().getMyShell());
        final IWorkspaceDescription description = ResourcesPlugin.getWorkspace().isAutoBuilding() ? ResourcesPlugin.getWorkspace().getDescription() : null;
        final boolean fork = this.isThreadSafe(toSyncDCList, myElements);
        final ArrayList actualDcsSyncedAsSources = new ArrayList();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                if (fork) {
                    WorkerThreadConsistency.setWorkerThreadActive();
                }
                try {
                    monitor.beginTask(actionName, 100);
                    this.syncSelectedDCs(toSyncDCList, myElements, (IProgressMonitor)new SubProgressMonitor(monitor, 15), exceptions);
                    if (syncUsedDCs || createProject) {
                        Collection newToCreateProjectList;
                        Map dependenciesMap;
                        Map map = dependenciesMap = DcCreateProjectAction.this.USE_OLD_BEHAVIOR_BEFORE_TASKFORCE ? DcCreateProjectAction.beforeTaskforce_collectDependencies(myElements) : DcCreateProjectAction.collectDependencies(actualDcsSyncedAsSources, true);
                        if (syncUsedDCs) {
                            Set allNewDCsList = DcCreateProjectAction.dependencyMapToSet(dependenciesMap);
                            allNewDCsList.addAll(DcCreateProjectAction.this.USE_OLD_BEHAVIOR_BEFORE_TASKFORCE ? DcCreateProjectAction.beforeTaskforce_collectBuildDependencies(dependenciesMap, exceptions) : DcCreateProjectAction.collectBuildDependencies(dependenciesMap, exceptions));
                            allNewDCsList.removeAll(allDCsList);
                            List newToSyncDCs = DcCreateProjectAction.getNotSyncedDCs(allNewDCsList);
                            if (!newToSyncDCs.isEmpty()) {
                                theTracer.userOut("Development Component", 4, "New Dependencies are detected!\nFollowing DCs will be synced now:\n" + newToSyncDCs.toString());
                                this.syncSelectedDCs(newToSyncDCs, myElements, (IProgressMonitor)new SubProgressMonitor(monitor, 5), exceptions);
                            }
                        }
                        if (createProject && !(newToCreateProjectList = DcCreateProjectAction.listAutomaticCreateProject(myElements, dependenciesMap)).isEmpty()) {
                            myElements.addAll(newToCreateProjectList);
                            theTracer.userOut("Development Component", 4, "For following DCs projects will be created automatically:\n" + newToCreateProjectList.toString());
                        }
                    }
                    monitor.subTask("");
                    List prjectListFoSyncedDCs = this.listProjectsForSyncedDCs(toSyncDCList);
                    Map buildMap = null;
                    if (DcCreateProjectAction.this.automaticDCBuild) {
                        buildMap = this.clculateBuildMap(myElements, exceptions, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                    }
                    if (description != null) {
                        description.setAutoBuilding(false);
                        try {
                            ResourcesPlugin.getWorkspace().setDescription(description);
                        }
                        catch (CoreException e) {
                            Util.logExceptionMessage(theTracer, 3, actionName + ": Deactivate auto build failed", e);
                        }
                    }
                    if (DcCreateProjectAction.this.automaticDCBuild) {
                        DcCreateProjectAction.buildDCs(buildMap, (IProgressMonitor)new SubProgressMonitor(monitor, 30), exceptions);
                    }
                    if (createProject) {
                        this.createProjects(exceptions, projectList, (IProgressMonitor)new SubProgressMonitor(monitor, 10), myElements);
                    }
                    try {
                        if (DcCreateProjectAction.this.shouldUpdateProject()) {
                            DcCreateProjectAction.this.updateDCProjects((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                        }
                    }
                    catch (Throwable e) {
                        Util.logExceptionMessage(theTracer, 2, actionName + " failed", e);
                    }
                    DcCreateProjectAction.this.refreshAndBuildProjects(prjectListFoSyncedDCs, projectList, monitor);
                    Object var6_7 = null;
                    if (!fork) return;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (!fork) throw throwable;
                    WorkerThreadConsistency.resetWorkerThreadActive();
                    throw throwable;
                }
                WorkerThreadConsistency.resetWorkerThreadActive();
            }

            private List listProjectsForSyncedDCs(List toSyncDCList2) {
                ArrayList<IProject> prjectListFoSyncedDCs = new ArrayList<IProject>();
                if (toSyncDCList2 != null) {
                    Iterator it = toSyncDCList2.iterator();
                    while (it.hasNext()) {
                        IProject project;
                        IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)it.next();
                        if (!dcNode.isSynchedAsSource() || (project = DCProjectUtil.getProject(dcNode)) == null || !project.exists() || !project.isOpen()) continue;
                        prjectListFoSyncedDCs.add(project);
                    }
                }
                return prjectListFoSyncedDCs;
            }

            private Map clculateBuildMap(List myElements2, List exceptions2, IProgressMonitor monitor) {
                monitor.beginTask("Calculate BuildFolder", 100);
                HashMap result = new HashMap();
                Iterator iter = myElements2.iterator();
                while (iter.hasNext()) {
                    IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)iter.next();
                    if (dcNode.isSynchedAsSource()) {
                        this.calculateBuildMap(result, exceptions2, dcNode);
                    }
                    monitor.worked(100 / myElements2.size());
                }
                monitor.done();
                return result;
            }

            private void calculateBuildMap(Map result, List exceptions2, IDevelopmentComponentNode dcNode) {
                IDCNodeResult dcNodeResult = null;
                try {
                    dcNodeResult = dcNode.listUsedDCs(new DCUsageFilter(true, true, true, true, false), false);
                }
                catch (Throwable e1) {
                    Util.logExceptionMessage(theTracer, 3, "calculate Build DC failed for " + dcNode.getName(), e1);
                    exceptions2.add(e1);
                }
                Collection resultDCs = dcNodeResult != null ? dcNodeResult.getDCNodes() : new ArrayList();
                boolean allDCsSynced = true;
                Iterator it = resultDCs.iterator();
                while (it.hasNext() && allDCsSynced) {
                    IDevelopmentComponentNode depDCNode = (IDevelopmentComponentNode)it.next();
                    if (!DCNodeSyncMode.NOT_SYNCHED.equals(depDCNode.getNodeSyncMode())) continue;
                    allDCsSynced = false;
                }
                if (allDCsSynced) {
                    result.put(dcNode, resultDCs);
                    Iterator it2 = resultDCs.iterator();
                    while (it2.hasNext() && allDCsSynced) {
                        IDevelopmentComponentNode depDCNode = (IDevelopmentComponentNode)it2.next();
                        if (!depDCNode.isSynchedAsSource() || result.containsKey(depDCNode)) continue;
                        this.calculateBuildMap(result, exceptions2, depDCNode);
                    }
                }
            }

            private void createProjects(List exceptions2, List projectList2, IProgressMonitor monitor, List dcList) {
                try {
                    int i = 0;
                    while (i < dcList.size()) {
                        IProject prj;
                        IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)dcList.get(i);
                        if ((dcNode.isSynchedAsActiveSource() && !dcNode.IsInactive() || dcNode.isSynchedAsInActiveSource() && dcNode.IsInactive() || dcNode.isLocalOnlySource()) && (prj = DCWizardUtil.createProjectFromDC(dcNode, false, null, monitor)) != null) {
                            projectList2.add(prj);
                        }
                        monitor.worked(100 / dcList.size());
                        ++i;
                    }
                }
                catch (Exception ex) {
                    exceptions2.add(ex);
                }
                monitor.done();
            }

            private void syncSelectedDCs(Collection dependendNodeList, Collection forSyncSrcDCs, IProgressMonitor monitor, List exceptions2) {
                monitor.beginTask("Sync of DCs ", 100);
                ArrayList<IDevelopmentComponentNode> forSyncArchiveDCs = new ArrayList<IDevelopmentComponentNode>();
                Iterator it = dependendNodeList.iterator();
                while (it.hasNext()) {
                    Object var11_10;
                    IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)it.next();
                    if (dcNode == null) continue;
                    IProject prj = DCProjectUtil.getProject(dcNode);
                    WorkspaceResourceListener.getListener().addToIgnoreProject(prj);
                    try {
                        block12: {
                            try {
                                if (forSyncSrcDCs.contains(dcNode)) {
                                    if (dcNode.isSynchedAsActiveSource() && dcNode.IsInactive() || dcNode.isSynchedAsInActiveSource() && !dcNode.IsInactive() || dcNode.isSynchedAsArchives()) {
                                        monitor.subTask("Remove from client " + dcNode.getName());
                                        dcNode.unsync();
                                    }
                                    monitor.subTask("Syncing of " + dcNode.getName());
                                    dcNode.syncAsSources(false);
                                    actualDcsSyncedAsSources.add(dcNode);
                                    break block12;
                                }
                                if (DcCreateProjectAction.haveToCreateProject(dcNode)) {
                                    if (dcNode.isSynchedAsArchives()) {
                                        monitor.subTask("Remove from client " + dcNode.getName());
                                        dcNode.unsync();
                                    }
                                    monitor.subTask("Syncing of " + dcNode.getName());
                                    dcNode.syncAsSources(false);
                                    actualDcsSyncedAsSources.add(dcNode);
                                    break block12;
                                }
                                monitor.subTask("Syncing of " + dcNode.getName());
                                if (dcNode.isSynchedAsSource()) {
                                    dcNode.resync(false);
                                    actualDcsSyncedAsSources.add(dcNode);
                                    break block12;
                                }
                                if (DcCreateProjectAction.canSyncArchive(dcNode)) {
                                    forSyncArchiveDCs.add(dcNode);
                                    break block12;
                                }
                                dcNode.syncAsSources(false);
                                actualDcsSyncedAsSources.add(dcNode);
                            }
                            catch (Throwable e) {
                                exceptions2.add(e);
                                Util.logExceptionMessage(theTracer, 3, "sync of DC failed: " + dcNode.getName(), e);
                                var11_10 = null;
                                WorkspaceResourceListener.getListener().removeToIgnoreProject(prj);
                            }
                        }
                        var11_10 = null;
                        WorkspaceResourceListener.getListener().removeToIgnoreProject(prj);
                    }
                    catch (Throwable throwable) {
                        var11_10 = null;
                        WorkspaceResourceListener.getListener().removeToIgnoreProject(prj);
                        throw throwable;
                    }
                    monitor.worked(100 / dependendNodeList.size());
                    monitor.subTask("");
                }
                if (!forSyncArchiveDCs.isEmpty()) {
                    ComponentUtil.syncDCsAsArchive(monitor, forSyncArchiveDCs, true);
                }
                monitor.done();
            }
        };
        try {
            progressMonitor.run(fork, false, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e2) {
            Util.logExceptionMessage(theTracer, 2, actionName + " failed", e2);
            exceptions.add(e2);
        }
        catch (InterruptedException e2) {
            Util.logExceptionMessage(theTracer, 3, "Action was canceled", e2);
        }
        if (description != null) {
            description.setAutoBuilding(true);
            try {
                ResourcesPlugin.getWorkspace().setDescription(description);
            }
            catch (CoreException e) {
                Util.logExceptionMessage(theTracer, 3, actionName + ": Activate auto build failed", e);
            }
        }
        progressMonitor.getProgressMonitor().done();
        progressMonitor.close();
        if (exceptions != null && !exceptions.isEmpty()) {
            Util.showException((Throwable)exceptions.get(0), "Warning", actionName + " completed with " + exceptions.size() + " error(s)." + (exceptions.size() > 1 ? "\nFor more Information see Error Log" : ""), null);
        }
        if (createProject && projectList != null && !projectList.isEmpty()) {
            int counter = 0;
            Iterator it = projectList.iterator();
            while (it.hasNext()) {
                IProject prj = (IProject)it.next();
                try {
                    IDevelopmentComponentNode dcNode = ((IDCExtendedProject)prj.getNature("com.sap.ide.eclipse.component.provider.dcnature")).getDCNode();
                    if (dcNode == null || dcNode.IsInactive() || !dcNode.getConfiguration().isWithBuildServer()) continue;
                    ++counter;
                }
                catch (CoreException e) {
                    Util.logExceptionMessage(theTracer, 3, "Generating Warning Problems", e);
                }
            }
            if (counter > 0) {
                String message = (counter == projectList.size() ? "" : "Some ") + "Project" + (counter > 1 ? "s are" : " is") + " created for active DC sources.\n" + "For Editing of sources you should use inactive DC sources.";
                MessageDialog.openInformation((Shell)ComponentProviderPlugin.getPlugin().getMyShell(), (String)"Info", (String)message);
            }
        }
    }

    private boolean isThreadSafe(Collection dependendNodeList, Collection forSyncSrcDCs) {
        if (dependendNodeList == null || forSyncSrcDCs == null) {
            return true;
        }
        Iterator it = dependendNodeList.iterator();
        while (it.hasNext()) {
            IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)it.next();
            if (dcNode == null || !forSyncSrcDCs.contains(dcNode) || !(dcNode.isSynchedAsActiveSource() && dcNode.IsInactive() || dcNode.isSynchedAsInActiveSource() && !dcNode.IsInactive()) && !dcNode.isSynchedAsArchives()) continue;
            return false;
        }
        return true;
    }

    public static Collection beforeTaskforce_collectBuildDependencies(Map dependenciesMap, Collection exceptions) {
        HashMap<IDevelopmentConfiguration, HashSet<IDevelopmentComponentNode>> buildPlugins = new HashMap<IDevelopmentConfiguration, HashSet<IDevelopmentComponentNode>>();
        HashSet result = new HashSet();
        if (dependenciesMap == null) {
            return result;
        }
        Iterator it = dependenciesMap.keySet().iterator();
        while (it.hasNext()) {
            IDevelopmentComponentNode buildDC;
            block6: {
                IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)it.next();
                buildDC = null;
                try {
                    buildDC = dcNode.getBuildPlugin();
                }
                catch (DevConfigException e) {
                    if (exceptions == null) break block6;
                    exceptions.add(e);
                }
            }
            if (buildDC == null || buildDC.isInstalledLocally()) continue;
            HashSet<IDevelopmentComponentNode> set = (HashSet<IDevelopmentComponentNode>)buildPlugins.get(buildDC.getConfiguration());
            if (set == null) {
                set = new HashSet<IDevelopmentComponentNode>();
            }
            set.add(buildDC);
            buildPlugins.put(buildDC.getConfiguration(), set);
        }
        DCUsageFilter atRunTimeFilter = new DCUsageFilter(true, false, false, false, false);
        Iterator iter = buildPlugins.keySet().iterator();
        while (iter.hasNext()) {
            IDevelopmentConfiguration config = (IDevelopmentConfiguration)iter.next();
            Set set = (Set)buildPlugins.get(config);
            result.addAll(set);
            IDCNodeResult res = config.listRecursivelyUsedNodes(set.toArray(new IDevelopmentComponentNode[set.size()]), atRunTimeFilter, false);
            if (res == null) continue;
            result.addAll(res.getDCNodes());
        }
        return result;
    }

    public static Collection collectBuildDependencies(Map dependenciesMap, Collection exceptions) {
        HashMap<IDevelopmentConfiguration, HashSet<IDevelopmentComponentNode>> buildPluginsToSyncByConfig = new HashMap<IDevelopmentConfiguration, HashSet<IDevelopmentComponentNode>>();
        HashMap<IDevelopmentConfiguration, HashSet<IDevelopmentComponentNode>> visitedBuildPluginByConfig = new HashMap<IDevelopmentConfiguration, HashSet<IDevelopmentComponentNode>>();
        HashSet result = new HashSet();
        if (dependenciesMap == null) {
            return result;
        }
        Iterator it = dependenciesMap.keySet().iterator();
        block7: while (it.hasNext()) {
            IDevelopmentComponentNode buildPluginNode;
            IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)it.next();
            PPReference buildPluginRef = null;
            IDevelopmentConfiguration config = dcNode.getConfiguration();
            HashSet<IDevelopmentComponentNode> vistitedbuildDcsOfConfig = (HashSet<IDevelopmentComponentNode>)visitedBuildPluginByConfig.get(config);
            if (vistitedbuildDcsOfConfig != null) {
                try {
                    buildPluginRef = dcNode.getDevelopmentComponent(false).getBuildPlugin();
                }
                catch (RepositoryAccessException e) {
                    Util.logExceptionMessage(theTracer, 2, "Error while trying to get meta data of DC " + dcNode, e);
                    continue;
                }
                catch (InvalidDefinitionException e) {
                    Util.logExceptionMessage(theTracer, 2, "Error while trying to get meta data of DC " + dcNode, e);
                    continue;
                }
                if (buildPluginRef != null && buildPluginRef.getComponent().getSCAlias() == null) {
                    Iterator iter = vistitedbuildDcsOfConfig.iterator();
                    while (iter.hasNext()) {
                        IDevelopmentComponentNode buildPlugin = (IDevelopmentComponentNode)iter.next();
                        if (buildPlugin.getName().equals(buildPluginRef.getComponent().getName()) && buildPlugin.getVendor().equals(buildPluginRef.getComponent().getVendor())) continue block7;
                    }
                }
            }
            try {
                buildPluginNode = dcNode.getBuildPlugin();
            }
            catch (DevConfigException e) {
                Util.logExceptionMessage(theTracer, 2, "Error while trying to get meta data for build plugin of DC " + dcNode, e);
                continue;
            }
            if (buildPluginNode == null) continue;
            if (vistitedbuildDcsOfConfig == null) {
                vistitedbuildDcsOfConfig = new HashSet<IDevelopmentComponentNode>();
                visitedBuildPluginByConfig.put(config, vistitedbuildDcsOfConfig);
            }
            vistitedbuildDcsOfConfig.add(buildPluginNode);
            if (buildPluginNode.isInstalledLocally()) continue;
            HashSet<IDevelopmentComponentNode> set = (HashSet<IDevelopmentComponentNode>)buildPluginsToSyncByConfig.get(config);
            if (set == null) {
                set = new HashSet<IDevelopmentComponentNode>();
                buildPluginsToSyncByConfig.put(config, set);
            }
            set.add(buildPluginNode);
        }
        Iterator iter = buildPluginsToSyncByConfig.keySet().iterator();
        while (iter.hasNext()) {
            IDevelopmentConfiguration config = (IDevelopmentConfiguration)iter.next();
            Set buildPluginSet = (Set)buildPluginsToSyncByConfig.get(config);
            try {
                if (buildPluginSet == null) continue;
                Set usedBuildDCs = config.listUsedDCs(buildPluginSet, (IUsedDCFoundHandler)new UsedDCFoundHandlerForBuildDcs());
                result.addAll(buildPluginSet);
                result.addAll(usedBuildDCs);
            }
            catch (DevConfigException e) {
                Util.logExceptionMessage(theTracer, 2, "Error while trying to get used build infratsructure DCs for selected Dcs in configuration " + config.getConfigurationData().getName(), e);
            }
        }
        return result;
    }

    public static Map beforeTaskforce_collectDependencies(List myElements) {
        ArrayList exceptions = new ArrayList();
        HashMap dependenciesMap = new HashMap();
        if (!UserValidator.isDefaultServerOnline()) {
            return dependenciesMap;
        }
        Iterator it = myElements.iterator();
        while (it.hasNext()) {
            IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)it.next();
            if (dcNode.getConfiguration().isLocalConfiguration()) continue;
            DcCreateProjectAction.updateMapForSourceDCNode(dependenciesMap, exceptions, dcNode, myElements);
        }
        return dependenciesMap;
    }

    public static Map collectDependencies(List selectedDCNodes, final boolean recurse) {
        HashMap dependencyMap = new HashMap();
        if (!UserValidator.isDefaultServerOnline() || selectedDCNodes.isEmpty()) {
            return new HashMap();
        }
        HashMap<IDevelopmentConfiguration, HashSet<IDevelopmentComponentNode>> nodesByConfig = new HashMap<IDevelopmentConfiguration, HashSet<IDevelopmentComponentNode>>();
        Iterator iter = selectedDCNodes.iterator();
        while (iter.hasNext()) {
            IDevelopmentComponentNode node = (IDevelopmentComponentNode)iter.next();
            HashSet<IDevelopmentComponentNode> nodes = (HashSet<IDevelopmentComponentNode>)nodesByConfig.get(node.getConfiguration());
            if (nodes == null) {
                nodes = new HashSet<IDevelopmentComponentNode>();
                nodesByConfig.put(node.getConfiguration(), nodes);
            }
            nodes.add(node);
        }
        Iterator iter2 = nodesByConfig.keySet().iterator();
        while (iter2.hasNext()) {
            IDevelopmentConfiguration config = (IDevelopmentConfiguration)iter2.next();
            final Set startDCs = (Set)nodesByConfig.get(config);
            try {
                config.listUsedDCs(startDCs, (IUsedDCFoundHandler)new UsedDCFoundHandler(dependencyMap, startDCs){

                    public UsedDCSearchInstruction atComponentNode(IDevelopmentComponentNode currentDC, IDevelopmentComponentNode usingDC) {
                        if (!recurse && !startDCs.contains(currentDC)) {
                            return UsedDCSearchInstruction.DO_NOT_APPLY_RECURSIVE_SEARCH;
                        }
                        return super.atComponentNode(currentDC, usingDC);
                    }
                });
            }
            catch (DevConfigException e) {
                Util.logExceptionMessage(theTracer, 2, "Error while trying to get used Dcs for selected Dcs in configuration " + config.getConfigurationData().getName(), e);
            }
        }
        return dependencyMap;
    }

    private static void updateMapForSourceDCNode(Map dependenciesMap, Collection exceptions, IDevelopmentComponentNode dcNode, Collection selectedDCs) {
        if (dcNode == null || dcNode.isInstalledLocally()) {
            return;
        }
        IDCNodeResult dcNodeResult = null;
        try {
            dcNodeResult = dcNode.listUsedDCs(new DCUsageFilter(true, true, true, true, false), true);
        }
        catch (Throwable e) {
            Util.logExceptionMessage(theTracer, 3, "list used DCs for " + dcNode.getName() + " failed.", e);
            exceptions.add(e);
        }
        ArrayList dependendDCs = new ArrayList();
        if (dcNodeResult != null) {
            exceptions.addAll(dcNodeResult.getExceptions());
            dependendDCs.addAll(dcNodeResult.getDCNodes());
            dependenciesMap.put(dcNode, dependendDCs);
            Iterator it = dependendDCs.iterator();
            while (it.hasNext()) {
                IDevelopmentComponentNode myDCNode = (IDevelopmentComponentNode)it.next();
                if (dependenciesMap.containsKey(myDCNode) || !DcCreateProjectAction.haveToCreateProject(myDCNode) && DcCreateProjectAction.canSyncArchive(myDCNode)) continue;
                DcCreateProjectAction.updateMapForSourceDCNode(dependenciesMap, exceptions, myDCNode, selectedDCs);
            }
        } else {
            dependenciesMap.put(dcNode, dependendDCs);
        }
    }

    private List selectDCsToSync(Map dependenciesMap, Collection buildDCs, Collection selectedDCList, boolean forceSyncSelectedDCs) {
        ArrayList<Object> result = new ArrayList<Object>();
        if ((dependenciesMap == null || dependenciesMap.isEmpty()) && (selectedDCList == null || selectedDCList.isEmpty())) {
            return result;
        }
        HashSet myNodeList = new HashSet();
        myNodeList.addAll(buildDCs);
        Iterator iter = dependenciesMap.keySet().iterator();
        while (iter.hasNext()) {
            IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)iter.next();
            Collection list = (Collection)dependenciesMap.get(dcNode);
            ArrayList<IDevelopmentComponentNode> listForDCNode = new ArrayList<IDevelopmentComponentNode>();
            if (list == null) continue;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                IDevelopmentComponentNode myDCNode = (IDevelopmentComponentNode)it.next();
                if (selectedDCList.contains(myDCNode) || myDCNode.isInstalledLocally() || myDCNode.isLocalOnlySource()) continue;
                listForDCNode.add(myDCNode);
            }
            myNodeList.addAll(listForDCNode);
        }
        if (selectedDCList != null) {
            Iterator it = selectedDCList.iterator();
            while (it.hasNext()) {
                IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)it.next();
                if (dcNode.isLocalOnlySource() || dcNode.getConfiguration().isInOfflineMode()) continue;
                myNodeList.add(dcNode);
            }
        }
        if (myNodeList != null && !myNodeList.isEmpty()) {
            this.updateArchiveStates(myNodeList);
            ArrayList<IDevelopmentComponentNode> staticSelectedDCs = null;
            if (forceSyncSelectedDCs) {
                staticSelectedDCs = selectedDCList;
            } else {
                staticSelectedDCs = new ArrayList<IDevelopmentComponentNode>();
                Iterator it = selectedDCList.iterator();
                while (it.hasNext()) {
                    IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)it.next();
                    if (dcNode.isSynched()) continue;
                    staticSelectedDCs.add(dcNode);
                }
            }
            SelectDCsDialog dialog = SelectDCsDialog.newSelectDCsDialog(null, "Sync Development Components", "Select the Development Components to sync.\nNote: The local build may fail if not all DCs are synced.", myNodeList, selectedDCList, staticSelectedDCs);
            dialog.initializeOptions("Build DCs after sync", true, "Skipping build may lead to an inconsistent state.", true);
            List toSelectList = DcCreateProjectAction.getInitialSelection(myNodeList, selectedDCList, forceSyncSelectedDCs);
            dialog.setInitialElementSelections(toSelectList);
            int returnValue = dialog.open();
            if (returnValue == 0) {
                result.addAll(Arrays.asList(dialog.getResult()));
                this.automaticDCBuild = dialog.isOptionSelected();
            } else if (returnValue == 1) {
                return null;
            }
        }
        return result;
    }

    public static List getInitialSelection(Collection myNodeList, Collection selectedDCList, boolean forceSancSelectedDCs) {
        ArrayList<IDevelopmentComponentNode> toSelectList = new ArrayList<IDevelopmentComponentNode>();
        Iterator iter = myNodeList.iterator();
        while (iter.hasNext()) {
            IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)iter.next();
            DCNodeSyncMode mode = dcNode.getNodeSyncMode();
            DCNodeSyncState state = dcNode.getNodeSyncState();
            if (mode != null && DCNodeSyncMode.SYNCHED_AS_ARCHIVE.equals(mode) && (DCNodeSyncState.OUTDATED.equals(state) || DcCreateProjectAction.haveToCreateProject(dcNode)) || DCNodeSyncMode.NOT_SYNCHED.equals(mode) || selectedDCList.contains(dcNode)) {
                toSelectList.add(dcNode);
                continue;
            }
            if (!dcNode.isSynchedAsSource()) continue;
            toSelectList.add(dcNode);
        }
        return toSelectList;
    }

    private void updateArchiveStates(Collection myNodeList) {
        if (myNodeList != null) {
            HashSet<IDevelopmentConfiguration> configSet = new HashSet<IDevelopmentConfiguration>();
            Iterator it = myNodeList.iterator();
            while (it.hasNext()) {
                IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)it.next();
                if (!dcNode.isSynchedAsArchives()) continue;
                configSet.add(dcNode.getConfiguration());
            }
            Iterator it2 = configSet.iterator();
            while (it2.hasNext()) {
                IDevelopmentConfiguration config = (IDevelopmentConfiguration)it2.next();
                try {
                    config.refreshArchiveSyncState();
                }
                catch (SyncException e) {
                    Util.logExceptionMessage(theTracer, 3, "refreshArchiveSyncState failed", e);
                }
            }
        }
    }

    public static void buildDCs(Map buildMap, IProgressMonitor progressMonitor, List exceptions) {
        if (buildMap == null || buildMap.isEmpty()) {
            return;
        }
        progressMonitor.beginTask("DC Build ", 100);
        int size = buildMap.keySet().size();
        HashSet<IDevelopmentConfiguration> configSet = new HashSet<IDevelopmentConfiguration>();
        Iterator it = buildMap.keySet().iterator();
        while (it.hasNext()) {
            IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)it.next();
            configSet.add(dcNode.getConfiguration());
        }
        Iterator it2 = configSet.iterator();
        while (it2.hasNext()) {
            Object obj = it2.next();
            if (!(obj instanceof IDevelopmentConfiguration)) continue;
            IDevelopmentConfiguration aDevconf = (IDevelopmentConfiguration)obj;
            IDCProxy[] orderedProxies = null;
            try {
                orderedProxies = aDevconf.getBuildOrderOfDCsAvailableAsSource(true);
            }
            catch (Throwable e) {
                Util.logExceptionMessage(theTracer, 2, "getBuildOrderOfDCsAvailableAsSource failed", e);
                exceptions.add(e);
            }
            if (orderedProxies == null) continue;
            int i = 0;
            while (i < orderedProxies.length) {
                IDCProxy proxy = orderedProxies[i];
                IDevelopmentComponentNode dcNode = null;
                dcNode = DcCreateProjectAction.getDCNodeForProxy(buildMap.keySet(), proxy);
                if (dcNode != null) {
                    DevelopmentComponent dc;
                    buildMap.remove(dcNode);
                    if (proxy.isDirty() && (dc = proxy.getComponent()) != null) {
                        boolean isJavaDC = false;
                        try {
                            isJavaDC = "java".equals(dc.getComponentType().getType().toLowerCase());
                        }
                        catch (Throwable e2) {
                            Util.logExceptionMessage(theTracer, 3, "Problems reading DC Type for " + dc.getName(), e2);
                        }
                        if (!isJavaDC || isJavaDC && DCBuildSettings.isUseDCReferencesForJavaDCActiv()) {
                            IBuildResult buildResult;
                            block17: {
                                String buildVariant = null;
                                try {
                                    buildVariant = Util.getBuildVariant(dcNode.getConfiguration(), dcNode.getCompartmentName());
                                }
                                catch (Exception e) {
                                    Util.logExceptionMessage(theTracer, 2, "Get Build Variant failed", e);
                                    exceptions.add(e);
                                }
                                progressMonitor.subTask("Building DC " + proxy.getComponent().getName() + " with Build Variant " + buildVariant);
                                buildResult = null;
                                try {
                                    buildResult = proxy.make(buildVariant, null, null);
                                }
                                catch (BuildException e1) {
                                    Util.logExceptionMessage(theTracer, 3, "build failed:", e1);
                                    if (e1.getErrorCode() == 2) break block17;
                                    exceptions.add(e1);
                                }
                            }
                            DCProject prj = DCProjectUtil.getDCProject(DCProjectUtil.getProject(proxy));
                            if (prj != null) {
                                prj.notifyBuild();
                            }
                            if (buildResult == null || buildResult.getResultCode() == 2 || buildResult.getResultCode() == 3) {
                                DcCreateProjectAction.removeDCNodeRecursive(buildMap, dcNode);
                            }
                        }
                    }
                    progressMonitor.worked(100 / size);
                }
                ++i;
            }
        }
        progressMonitor.done();
    }

    private static void removeDCNodeRecursive(Map buildMap, IDevelopmentComponentNode dcNode) {
        if (buildMap == null || dcNode == null) {
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(dcNode);
        if (!list.isEmpty()) {
            dcNode = (IDevelopmentComponentNode)list.get(0);
            ArrayList tempList = new ArrayList();
            Iterator it = buildMap.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                Collection col = (Collection)buildMap.get(key);
                if (!col.contains(dcNode)) continue;
                tempList.add(key);
            }
            list.addAll(tempList);
            list.remove(dcNode);
            Iterator it2 = tempList.iterator();
            while (it2.hasNext()) {
                buildMap.remove(it2.next());
            }
        }
    }

    private static IDevelopmentComponentNode getDCNodeForProxy(Collection set, IDCProxy proxy) {
        if (set == null || proxy == null) {
            return null;
        }
        Iterator it = set.iterator();
        while (it.hasNext()) {
            IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)it.next();
            try {
                if (!dcNode.getDCProxy().equals(proxy)) continue;
                return dcNode;
            }
            catch (Throwable e) {
                Util.logExceptionMessage(theTracer, 3, "get DCProxy failed", e);
            }
        }
        return null;
    }

    public static boolean canSyncArchive(IDevelopmentComponentNode dcNode) {
        if (dcNode.isLocalOnlySource() || dcNode.isInstalledLocally()) {
            return false;
        }
        if (dcNode.isSynchedAsArchives()) {
            return true;
        }
        return !dcNode.isSynched() && !dcNode.IsInactive() && dcNode.getConfiguration().isWithBuildServer();
    }

    static boolean haveToCreateProject(IDevelopmentComponentNode dcNode) {
        ComponentType type;
        DevelopmentComponent dc = null;
        if (dcNode == null || !dcNode.hasSourceState()) {
            return false;
        }
        try {
            dc = dcNode.getDevelopmentComponent(false);
        }
        catch (Throwable e) {
            Util.logExceptionMessage(theTracer, 2, "asking for DC Type failrd", e);
        }
        if (dc != null && (type = dc.getComponentType()) != null) {
            return "sap.com".equals(type.getVendor()) && "J2EE".equals(type.getType()) && ("EJBModule".equals(type.getSubType()) || "WebModule".equals(type.getSubType()));
        }
        return false;
    }

    private static Collection listAutomaticCreateProject(List myElements, Map dependenciesMap) {
        ArrayList<IDevelopmentComponentNode> result = new ArrayList<IDevelopmentComponentNode>();
        Iterator it = dependenciesMap.entrySet().iterator();
        while (it.hasNext()) {
            Collection dependendDCs;
            ComponentType type;
            Map.Entry entry = it.next();
            IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)entry.getKey();
            if (!myElements.contains(dcNode)) continue;
            DevelopmentComponent dc = null;
            try {
                dc = dcNode.getDevelopmentComponent(false);
            }
            catch (Throwable e) {
                Util.logExceptionMessage(theTracer, 2, "asking for DC Type failed", e);
            }
            if (dc == null || (type = dc.getComponentType()) == null || !"Enterprise Application".equals(type.getSubType()) || !"J2EE".equals(type.getType()) || !"sap.com".equals(type.getVendor()) || (dependendDCs = (Collection)entry.getValue()) == null) continue;
            Iterator iter = dependendDCs.iterator();
            while (iter.hasNext()) {
                IDevelopmentComponentNode dependentDCNode = (IDevelopmentComponentNode)iter.next();
                if (myElements.contains(dependentDCNode) || result.contains(dependentDCNode) || !DcCreateProjectAction.haveToCreateProject(dependentDCNode)) continue;
                result.add(dependentDCNode);
            }
        }
        return result;
    }

    private void refreshAndBuildProjects(List projectList, List newCreatedProjects, IProgressMonitor monitor) {
        ArrayList allProjects = new ArrayList(projectList);
        allProjects.addAll(newCreatedProjects);
        List orderedProjectList = DCProjectUtil.pruneResources(allProjects);
        if (orderedProjectList == null) {
            return;
        }
        Iterator it = orderedProjectList.iterator();
        while (it.hasNext()) {
            IProject project = (IProject)it.next();
            try {
                if (project == null || !project.exists() || !project.isOpen()) continue;
                if (projectList.contains(project)) {
                    project.refreshLocal(2, monitor);
                    if (DCProjectInfo.isDCProject((IProject)project)) {
                        ((DCProject)project.getNature("com.sap.ide.eclipse.component.provider.dcnature")).notifySync();
                    }
                }
                if (!this.automaticDCBuild) continue;
                project.build(6, monitor);
            }
            catch (CoreException e) {
                Util.logExceptionMessage(theTracer, 2, "Sync DC:Update project failed", e);
            }
        }
    }

    protected static Set dependencyMapToSet(Map dependencyMap) {
        HashSet result = new HashSet();
        Iterator it = dependencyMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            result.add(entry.getKey());
            result.addAll((Collection)entry.getValue());
        }
        return result;
    }

    protected static List getNotSyncedDCs(Set allNewDCsList) {
        ArrayList<IDevelopmentComponentNode> result = new ArrayList<IDevelopmentComponentNode>();
        if (allNewDCsList != null) {
            Iterator it = allNewDCsList.iterator();
            while (it.hasNext()) {
                IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)it.next();
                if (!DCNodeSyncMode.NOT_SYNCHED.equals(dcNode.getNodeSyncMode())) continue;
                result.add(dcNode);
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

