/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.actions.dc;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.component.provider.NamereservationUtil;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.ide.eclipse.component.provider.ui.message.ComponentProviderMessages;
import com.sap.ide.eclipse.dii.namereservation.NameServerUtil;
import com.sap.lcr.namealloc.NameAllocator;
import com.sap.lcr.namealloc.api.AllocationState;
import com.sap.lcr.namealloc.api.CommunicationFailureException;
import com.sap.tc.complib.Compartment;
import com.sap.tc.devconf.CheckoutException;
import com.sap.tc.devconf.CreateException;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.RepositoryAccessException;
import com.sap.tc.devconf.SyncException;
import com.tssap.dtr.client.eclipse.ui.SelectActivityDialog;
import com.tssap.dtr.client.eclipse.ui.util.WorkspacesWithDefaultActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class DcAddToSourceControlImpl
extends Action {
    private Element element;
    private TracerI theTracer = TracingManager.getTracer(((Object)((Object)this)).getClass());

    public DcAddToSourceControlImpl(Element element, IDevelopmentComponentNode dcNode) {
        this.element = element;
    }

    public void run() {
        block33: {
            Object object = ObjectUtil.getComponentObject(this.element);
            Shell shell = ComponentProviderPlugin.getPlugin().getMyShell();
            if (!(object instanceof IDevelopmentComponentNode)) {
                return;
            }
            IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)object;
            IDCProxy dcInfo = null;
            try {
                dcInfo = dcNode.getDCProxy();
            }
            catch (DevConfigException e2) {
                Util.showException(e2, shell);
                return;
            }
            IVfsWorkspace workspace = this.getWorkspace(dcNode);
            if (workspace == null) {
                return;
            }
            try {
                IVfsActivity activity = null;
                if (WorkspacesWithDefaultActivity.usingDefaultActivity((IVfsWorkspace)workspace)) {
                    activity = workspace.getDefaultActivity();
                } else {
                    IVfsActivity[] results;
                    SelectActivityDialog selectActivity = new SelectActivityDialog(shell, workspace, false, null, null, 0);
                    if (selectActivity.open() == 0 && (results = selectActivity.getActivitySelection()).length > 0) {
                        activity = results[0];
                    }
                }
                if (activity == null) {
                    return;
                }
                AllocationState nameState = null;
                String resName = NamereservationUtil.getDCReservationName(dcNode);
                NameAllocator allocator = NameServerUtil.getNameAllocator((Element)this.element);
                if (allocator != null) {
                    try {
                        if (NamereservationUtil.isDCReserved(resName, allocator)) {
                            MessageDialog.openError((Shell)shell, (String)ComponentProviderMessages.getString("nameReservation.error"), (String)ComponentProviderMessages.format("AllreadyReserved.error", new String[]{resName}));
                            return;
                        }
                    }
                    catch (CommunicationFailureException e) {
                        Util.logExceptionMessage(this.theTracer, 2, "Communication to Name server failed", e);
                        Util.showException(e, shell);
                        return;
                    }
                    try {
                        if (allocator != null && resName != null) {
                            nameState = NamereservationUtil.reserveDC(resName, allocator);
                        }
                    }
                    catch (Throwable e) {
                        Util.logExceptionMessage(this.theTracer, 2, "Name reservation failed", e);
                        Util.showException(e, shell);
                        return;
                    }
                }
                boolean success = false;
                try {
                    dcInfo.addToSourceControl(activity);
                    success = true;
                }
                catch (SyncException e) {
                    Util.logExceptionMessage(this.theTracer, 2, "Add to Source Control failed", e);
                    Util.showException(e, shell);
                }
                catch (CreateException e) {
                    Util.logExceptionMessage(this.theTracer, 2, "Add to Source Control failed", e);
                    Util.showException(e, shell);
                }
                catch (CheckoutException e) {
                    Util.logExceptionMessage(this.theTracer, 2, "Add to Source Control failed", e);
                    Util.showException(e, shell);
                }
                boolean nameinDtrReserved = false;
                if (success && allocator != null && nameState != null) {
                    try {
                        IVfsFile dcdefFile = dcInfo.getComponentDefinitionVfsFile();
                        if (dcdefFile == null) {
                            success = false;
                        } else {
                            nameinDtrReserved = NamereservationUtil.reserveDCinDTR(dcdefFile, resName, nameState, allocator, activity);
                        }
                    }
                    catch (VfsException e) {
                        Util.logExceptionMessage(this.theTracer, 2, "Setting of DTR Properties failed", e);
                        Util.showException(e, shell);
                    }
                    catch (Throwable e) {
                        Util.logExceptionMessage(this.theTracer, 2, "Setting of DTR Properties failed", e);
                        Util.showException(e, shell);
                    }
                }
                if (!success || !nameinDtrReserved) {
                    try {
                        if (allocator != null && resName != null) {
                            NamereservationUtil.revertDCReservation(resName, allocator);
                        }
                        break block33;
                    }
                    catch (Throwable e) {
                        Util.logExceptionMessage(this.theTracer, 3, "Name Reservation Reverting failed", e);
                        Util.showException(e, shell);
                    }
                    break block33;
                }
                try {
                    DCProjectUtil.setDTRTeamProviderForProject(dcNode);
                }
                catch (Throwable e1) {
                    Util.logExceptionMessage(this.theTracer, 3, "Sharing of Project with DTR failed", e1);
                }
                MessageDialog.openWarning((Shell)shell, (String)"Warning", (String)ComponentProviderMessages.getString("addToDTR.NotAllFilesAreAdded.warning"));
            }
            catch (Throwable ex) {
                Util.logExceptionMessage(this.theTracer, 2, "DC Add to Source Control failed", ex);
            }
        }
    }

    private IVfsWorkspace getWorkspace(IDevelopmentComponentNode dcNode) {
        if (dcNode == null) {
            return null;
        }
        boolean active = !dcNode.IsInactive();
        IDevelopmentConfiguration configuration = dcNode.getConfiguration();
        Compartment compartment = dcNode.getCompartment();
        if (configuration != null && compartment != null) {
            try {
                return configuration.getWorkspaceOfCompartment(compartment.getName(), active);
            }
            catch (RepositoryAccessException e) {
                Util.logExceptionMessage(this.theTracer, 2, "Getting Workspace failed", e);
            }
            catch (DevConfigException e) {
                Util.logExceptionMessage(this.theTracer, 2, "Getting Workspace failed", e);
            }
        }
        return null;
    }
}

