/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.actions.dc;

import com.sap.ide.eclipse.component.core.DeleteProjectHelper;
import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.component.provider.actions.dc.AbstractDcMultiAction;
import com.sap.ide.login.UserValidator;
import com.sap.tc.devconf.DefaultDCOperationHandler;
import com.sap.tc.devconf.IDCOperationHandler;
import com.sap.tc.devconf.IDCOperationResult;
import com.sap.tc.devconf.IDCUnsyncResult;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.SyncException;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.action.ICategory;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class DCUnsyncAction
extends AbstractDcMultiAction {
    private TracerI theTracer = TracingManager.getTracer(this.getClass());

    public ICategory getCategory() {
        return ComponentCategoryImage.CATEGORY__DC_UNSYNC;
    }

    public boolean isAvailable(Element[] elements) {
        if (!UserValidator.isDefaultServerOnline()) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            Element element = elements[i];
            if (!ComponentUtil.isDCElement(element)) {
                return false;
            }
            IDevelopmentComponentNode dcNode = ComponentUtil.getDCNode(element);
            if (dcNode == null || !dcNode.isSynchedAsArchives() && !dcNode.isSynchedAsSource()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void run(Element[] elements) {
        Element[] myElements = elements;
        final ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        if (myElements == null) {
            return;
        }
        final Shell shell = ComponentProviderPlugin.getPlugin().getMyShell();
        this.devConfSet = new HashSet();
        final HashMap devConfMap = new HashMap();
        ArrayList<IProject> tempProjectList = new ArrayList<IProject>();
        int i = 0;
        while (i < myElements.length) {
            IDevelopmentComponentNode dcNode;
            Element element = myElements[i];
            if (this.isAvailable(new Element[]{element}) && (dcNode = ComponentUtil.getDCNode(element)) != null) {
                IDevelopmentConfiguration config = dcNode.getConfiguration();
                ArrayList<IDevelopmentComponentNode> list = (ArrayList<IDevelopmentComponentNode>)devConfMap.get(config);
                if (list == null) {
                    list = new ArrayList<IDevelopmentComponentNode>();
                }
                this.devConfSet.add(config);
                list.add(dcNode);
                devConfMap.put(config, list);
                IProject project = DCProjectUtil.getProject(dcNode);
                if (project != null) {
                    tempProjectList.add(project);
                }
            }
            ++i;
        }
        if (this.shouldUpdateProject() && !this.saveEditors()) {
            return;
        }
        final DeleteProjectHelper helper = new DeleteProjectHelper(shell);
        helper.setProjectList(tempProjectList);
        helper.confirmDelete();
        if (helper.isCanceled()) {
            return;
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("Removing from Client", 100);
                monitor.setTaskName("Removing DC(s) from Client");
                ArrayList<IProject> projectList = new ArrayList<IProject>();
                Iterator it = devConfMap.keySet().iterator();
                while (it.hasNext()) {
                    SyncException e;
                    long elapsed;
                    Object var11_12;
                    IDevelopmentConfiguration config = (IDevelopmentConfiguration)it.next();
                    Collection list = (Collection)devConfMap.get(config);
                    long start = System.currentTimeMillis();
                    IDCOperationResult[] dcresults = null;
                    IDCUnsyncResult res = null;
                    try {
                        res = config.unsync(list.toArray(new IDevelopmentComponentNode[list.size()]), (IDCOperationHandler)new DefaultDCOperationHandler());
                        dcresults = res.getResultsForDCs();
                        var11_12 = null;
                    }
                    catch (Throwable throwable) {
                        var11_12 = null;
                        elapsed = System.currentTimeMillis() - start;
                        LogUtil.logElapsedTime((long)elapsed, (String)("IDevelopmentConfiguration.unsync(..) called on " + config));
                        throw throwable;
                    }
                    elapsed = System.currentTimeMillis() - start;
                    LogUtil.logElapsedTime((long)elapsed, (String)("IDevelopmentConfiguration.unsync(..) called on " + config));
                    if (dcresults != null) {
                        int i = 0;
                        while (i < dcresults.length) {
                            IDCOperationResult result = dcresults[i];
                            if (IDCOperationResult.Status.OK.equals(result.getStatus())) {
                                IProject project = DCProjectUtil.getProject(result.getDCNode());
                                if (project != null) {
                                    projectList.add(project);
                                }
                            } else {
                                Exception ex = result.getException();
                                if (ex != null) {
                                    exceptions.add(ex);
                                }
                                if (IDCOperationResult.Status.EXCEPTION.equals(result.getStatus())) {
                                    Util.logExceptionMessage(DCUnsyncAction.this.theTracer, 2, "Remove from Client for the DC failed.", ex);
                                }
                            }
                            ++i;
                        }
                    }
                    if (res != null && (e = res.getRemoveMountpointException()) != null) {
                        Util.logExceptionMessage(DCUnsyncAction.this.theTracer, 2, "Remove from Client failed.", e);
                    }
                    monitor.worked(100 / devConfMap.keySet().size());
                    if (!monitor.isCanceled()) continue;
                    return;
                }
                if (!projectList.isEmpty()) {
                    helper.setProjectList(projectList);
                    try {
                        if (!helper.execute(monitor)) {
                            Iterator it2 = projectList.iterator();
                            while (it2.hasNext()) {
                                IProject project = (IProject)it2.next();
                                if (project == null || !project.exists() || !project.isOpen()) continue;
                                project.refreshLocal(2, monitor);
                            }
                        }
                    }
                    catch (CoreException e) {
                        DeleteProjectHelper.handleException(e, shell);
                    }
                }
                DCUnsyncAction.this.updateDCProjects(monitor);
            }
        };
        try {
            new ProgressMonitorDialog(shell).run(false, false, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            exceptions.add(e.getTargetException());
            Util.logExceptionMessage(this.theTracer, 2, "Remove from Client problems", e);
        }
        catch (InterruptedException e) {
            Util.logExceptionMessage(this.theTracer, 3, "Operation was canceled by user", e);
        }
        if (!exceptions.isEmpty()) {
            Util.showException((Throwable)exceptions.get(0), "Error", "Remove DC(s) from client completed with " + exceptions.size() + " error(s)." + (exceptions.size() > 1 ? "\nFor more Information see Error Log" : ""), null);
        }
    }

    public IAction getDCAction(Element element, IDevelopmentComponentNode dcNode) {
        return null;
    }

    public boolean shouldUpdateProject() {
        return true;
    }
}

