/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.actions.dc;

import com.sap.ide.eclipse.component.core.DeleteProjectHelper;
import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.component.provider.actions.dc.AbstractDcMultiAction;
import com.sap.ide.login.UserValidator;
import com.sap.tc.devconf.DefaultDCOperationHandler;
import com.sap.tc.devconf.IDCOperationHandler;
import com.sap.tc.devconf.IDCOperationResult;
import com.sap.tc.devconf.IDCUnsyncResult;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.SyncException;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.action.ICategory;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class DCSyncArchivesAction
extends AbstractDcMultiAction {
    private TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$provider$actions$dc$DCSyncArchivesAction == null ? (class$com$sap$ide$eclipse$component$provider$actions$dc$DCSyncArchivesAction = DCSyncArchivesAction.class$("com.sap.ide.eclipse.component.provider.actions.dc.DCSyncArchivesAction")) : class$com$sap$ide$eclipse$component$provider$actions$dc$DCSyncArchivesAction));
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$provider$actions$dc$DCSyncArchivesAction;

    public ICategory getCategory() {
        return ComponentCategoryImage.CATEGORY__DC_SYNC_ARCHIVES;
    }

    public boolean isAvailable(Element[] elements) {
        if (!super.isAvailable(elements)) {
            return false;
        }
        if (!UserValidator.isDefaultServerOnline()) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            Element element = elements[i];
            if (!ComponentUtil.isActive(element)) {
                return false;
            }
            IDevelopmentComponentNode dcNode = ComponentUtil.getDCNode(element);
            if (dcNode == null) {
                return false;
            }
            if (dcNode.isLocalOnlySource() || dcNode.isInstalledLocally()) {
                return false;
            }
            IDevelopmentConfiguration config = dcNode.getConfiguration();
            if (config == null || !config.isWithBuildServer()) {
                return false;
            }
            if (this.theTracer.debug()) {
                this.theTracer.debug("Tested enabled Sync as Archives for DC: " + dcNode.getName());
            }
            ++i;
        }
        return true;
    }

    public IAction getDCAction(Element element, IDevelopmentComponentNode dcNode) {
        return null;
    }

    public void run(Element[] elements) {
        final ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        if (elements == null) {
            return;
        }
        final Shell shell = ComponentProviderPlugin.getPlugin().getMyShell();
        this.devConfSet = new HashSet();
        final HashMap devConfMap = new HashMap();
        ArrayList<IProject> tempProjectList = new ArrayList<IProject>();
        int i = 0;
        while (i < elements.length) {
            IDevelopmentComponentNode dcNode;
            Element element = elements[i];
            if (this.isAvailable(new Element[]{element}) && (dcNode = ComponentUtil.getDCNode(element)) != null) {
                IDevelopmentConfiguration config = dcNode.getConfiguration();
                ArrayList<IDevelopmentComponentNode> list = (ArrayList<IDevelopmentComponentNode>)devConfMap.get(config);
                if (list == null) {
                    list = new ArrayList<IDevelopmentComponentNode>();
                }
                this.devConfSet.add(config);
                list.add(dcNode);
                devConfMap.put(config, list);
                IProject project = DCProjectUtil.getProject(dcNode);
                if (project != null) {
                    tempProjectList.add(project);
                }
            }
            ++i;
        }
        if (this.shouldUpdateProject() && !this.saveEditors()) {
            return;
        }
        final DeleteProjectHelper helper = new DeleteProjectHelper(shell);
        helper.setProjectList(tempProjectList);
        helper.confirmDelete();
        if (helper.isCanceled()) {
            return;
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("Syncing Archives", 140);
                if (!DCSyncArchivesAction.this.unsyncDCs(devConfMap, helper, shell, exceptions, (IProgressMonitor)new SubProgressMonitor(monitor, 30))) {
                    return;
                }
                Iterator it = devConfMap.entrySet().iterator();
                while (it.hasNext()) {
                    Collection list = (Collection)it.next().getValue();
                    ComponentUtil.syncDCsAsArchive((IProgressMonitor)new SubProgressMonitor(monitor, 100 / devConfMap.size()), list, true);
                }
                DCSyncArchivesAction.this.updateDCProjects((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                monitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(shell).run(false, false, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            exceptions.add(e.getTargetException());
            Util.logExceptionMessage(this.theTracer, 2, "Remove from Client problems", e);
        }
        catch (InterruptedException e) {
            Util.logExceptionMessage(this.theTracer, 3, "Operation was canceled by user", e);
        }
        if (!exceptions.isEmpty()) {
            Util.showException((Throwable)exceptions.get(0), "Error", "Sync Archives completed with " + exceptions.size() + " error(s)." + (exceptions.size() > 1 ? "\nFor more Information see Error Log" : ""), null);
        }
    }

    public boolean shouldUpdateProject() {
        return true;
    }

    private boolean unsyncDCs(Map devConfMap, DeleteProjectHelper helper, Shell shell, List exceptions, IProgressMonitor monitor) {
        monitor.beginTask("Removing DC(s) from Client", 120);
        ArrayList<IProject> projectList = new ArrayList<IProject>();
        Iterator it = devConfMap.keySet().iterator();
        while (it.hasNext()) {
            SyncException e;
            long elapsed;
            Object var17_20;
            IDevelopmentConfiguration config = (IDevelopmentConfiguration)it.next();
            Collection list = (Collection)devConfMap.get(config);
            ArrayList<IDevelopmentComponentNode> toUnsyncList = new ArrayList<IDevelopmentComponentNode>();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)iter.next();
                if (!dcNode.isSynchedAsSource()) continue;
                toUnsyncList.add(dcNode);
            }
            long start = System.currentTimeMillis();
            IDCOperationResult[] dcresults = null;
            IDCUnsyncResult res = null;
            try {
                res = config.unsync(toUnsyncList.toArray(new IDevelopmentComponentNode[toUnsyncList.size()]), (IDCOperationHandler)new DefaultDCOperationHandler());
                dcresults = res.getResultsForDCs();
                var17_20 = null;
            }
            catch (Throwable throwable) {
                var17_20 = null;
                elapsed = System.currentTimeMillis() - start;
                LogUtil.logElapsedTime((long)elapsed, (String)("IDevelopmentConfiguration.unsync(..) called on " + config));
                throw throwable;
            }
            elapsed = System.currentTimeMillis() - start;
            LogUtil.logElapsedTime((long)elapsed, (String)("IDevelopmentConfiguration.unsync(..) called on " + config));
            if (dcresults != null) {
                int i = 0;
                while (i < dcresults.length) {
                    IDCOperationResult result = dcresults[i];
                    if (IDCOperationResult.Status.OK.equals(result.getStatus())) {
                        IProject project = DCProjectUtil.getProject(result.getDCNode());
                        if (project != null) {
                            projectList.add(project);
                        }
                    } else {
                        Exception ex = result.getException();
                        if (ex != null) {
                            exceptions.add(ex);
                        }
                        if (IDCOperationResult.Status.EXCEPTION.equals(result.getStatus())) {
                            Util.logExceptionMessage(this.theTracer, 2, "Remove from Client for the DC failed.", ex);
                        }
                    }
                    ++i;
                }
            }
            if ((e = res.getRemoveMountpointException()) != null) {
                Util.logExceptionMessage(this.theTracer, 2, "Remove from Client failed.", e);
            }
            monitor.worked(100 / devConfMap.keySet().size());
            if (!monitor.isCanceled()) continue;
            return false;
        }
        if (!projectList.isEmpty()) {
            int ticks = 20 / projectList.size();
            if (ticks == 0) {
                ticks = 1;
            }
            helper.setProjectList(projectList);
            try {
                if (!helper.execute(monitor)) {
                    Iterator it2 = projectList.iterator();
                    while (it2.hasNext()) {
                        IProject project = (IProject)it2.next();
                        if (project == null || !project.exists() || !project.isOpen()) continue;
                        project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, ticks));
                    }
                }
            }
            catch (CoreException e) {
                DeleteProjectHelper.handleException(e, shell);
            }
        }
        monitor.done();
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

