/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.actions.dc;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.dcmdcommons.resources.MessageUtil;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.actions.dc.WorkerThreadConsistency;
import com.sap.ide.eclipse.dii.component.ProjectConsistencyManager;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.extension.action.IElementMultiAction;
import com.tssap.util.action.ICategory;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractDcMultiAction
implements IElementMultiAction {
    protected static ComponentProviderPlugin myPlugin = ComponentProviderPlugin.getPlugin();
    protected Set devConfSet = null;
    private TracerI theTracer = TracingManager.getTracer(this.getClass());
    private MessageUtil theMessageUtil = MessageUtil.getInstance("com.sap.ide.eclipse.component.dcmdcommons.resources.messages");

    protected abstract IAction getDCAction(Element var1, IDevelopmentComponentNode var2);

    public boolean isAvailable(Element[] elements) {
        int i = 0;
        while (i < elements.length) {
            Element element = elements[i];
            if (!ComponentUtil.isDCElement(element)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEnabled(Element[] arg0) {
        return true;
    }

    public boolean shouldUpdateProject() {
        return false;
    }

    public boolean shouldRunInModalContext() {
        return false;
    }

    public void run(Element[] elements) {
        Element[] myElements = elements;
        if (myElements == null) {
            return;
        }
        final ArrayList availableElementList = new ArrayList();
        this.devConfSet = this.collectConfigurations(myElements, availableElementList);
        if (this.shouldUpdateProject() && !this.saveEditors()) {
            return;
        }
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                Iterator it = availableElementList.iterator();
                while (it.hasNext()) {
                    Element element = (Element)it.next();
                    IDevelopmentComponentNode dcNode = ComponentUtil.getDCNode(element);
                    IAction dcAction = AbstractDcMultiAction.this.getDCAction(element, dcNode);
                    if (AbstractDcMultiAction.this.shouldRunInModalContext()) {
                        try {
                            ModalContext.run((IRunnableWithProgress)new IRunnableWithProgress(this, dcAction){
                                private final /* synthetic */ IAction val$dcAction;
                                private final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$dcAction = val$dcAction;
                                }

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    WorkerThreadConsistency.setWorkerThreadActive();
                                    try {
                                        this.val$dcAction.run();
                                        Object var3_2 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var3_3 = null;
                                        WorkerThreadConsistency.resetWorkerThreadActive();
                                        throw throwable;
                                    }
                                    WorkerThreadConsistency.resetWorkerThreadActive();
                                }
                            }, (boolean)true, (IProgressMonitor)new NullProgressMonitor(), (Display)Display.getCurrent());
                        }
                        catch (InvocationTargetException e) {
                            Util.logExceptionMessage(AbstractDcMultiAction.this.theTracer, 3, "Run Action failed", e);
                        }
                        catch (InterruptedException e) {
                            Util.logExceptionMessage(AbstractDcMultiAction.this.theTracer, 3, "Run Action failed", e);
                        }
                        continue;
                    }
                    dcAction.run();
                }
            }
        });
        if (this.shouldUpdateProject()) {
            this.updateDCProjects();
        }
    }

    protected Set collectConfigurations(Element[] myElements, List availableElementList) {
        HashSet<IDevelopmentConfiguration> result = new HashSet<IDevelopmentConfiguration>();
        int i = 0;
        while (i < myElements.length) {
            Element element = myElements[i];
            if (this.isAvailable(new Element[]{element})) {
                if (availableElementList != null) {
                    availableElementList.add(element);
                }
                if (this.shouldUpdateProject()) {
                    result.add(ComponentUtil.getParentDevConf(element));
                }
            }
            ++i;
        }
        return result;
    }

    protected void updateDCProjects() {
        this.updateDCProjects(null);
    }

    protected void updateDCProjects(IProgressMonitor monitor) {
        if (this.devConfSet == null) {
            return;
        }
        Iterator it = this.devConfSet.iterator();
        while (it.hasNext()) {
            IDevelopmentConfiguration aDevconf;
            ProjectConsistencyManager aMan;
            Object obj = it.next();
            long start = System.currentTimeMillis();
            if (obj instanceof IDevelopmentConfiguration && (aMan = ProjectConsistencyManager.getInstance((IDevelopmentConfiguration)(aDevconf = (IDevelopmentConfiguration)obj))) != null) {
                try {
                    if (monitor == null) {
                        ProgressMonitorDialog aProgressMonitor = new ProgressMonitorDialog(ComponentProviderPlugin.getPlugin().getMyShell());
                        aProgressMonitor.run(false, false, (IRunnableWithProgress)aMan);
                    } else {
                        aMan.run(monitor);
                    }
                }
                catch (InvocationTargetException ite) {
                    Util.logExceptionMessage(this.theTracer, 2, this.theMessageUtil.getString("Exception.Occured"), ite);
                }
                catch (InterruptedException ie) {
                    Util.logExceptionMessage(this.theTracer, 3, "Action was interrupted", ie);
                }
            }
            long elapsed = System.currentTimeMillis() - start;
            LogUtil.logElapsedTime((long)elapsed, (String)("AbstractDcMultiAction.updateDCProjects() done for " + obj));
        }
        this.devConfSet.clear();
    }

    protected boolean saveEditors() {
        return Util.saveSensitiveEditors(this.devConfSet);
    }

    public abstract ICategory getCategory();
}

