/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.actions;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.ui.message.ComponentProviderMessages;
import com.sap.ide.login.UserValidator;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.ICompartmentNode;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.SyncException;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.util.action.ICategory;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class SCResyncArchivesAction
implements IElementSingleAction {
    protected static ComponentProviderPlugin myPlugin = ComponentProviderPlugin.getPlugin();
    private TracerI theTracer = TracingManager.getTracer(this.getClass());

    public ICategory getCategory() {
        return ComponentCategoryImage.CATEGORY__SC_RESYNC_ARCHIVES;
    }

    public boolean isAvailable(Element element) {
        String subDomain = element.getUniqueName().getSubDomain();
        if (!("com.sap.ide.eclipse.component.compartment".equals(subDomain) || "com.sap.ide.eclipse.component.SC.inactive".equals(subDomain) || "com.sap.ide.eclipse.component.SC.active".equals(subDomain))) {
            return false;
        }
        if (!UserValidator.isDefaultServerOnline()) {
            return false;
        }
        IDevelopmentConfiguration config = ComponentUtil.getParentDevConf(element);
        if (config != null && !config.isLocalConfiguration() && config.isWithBuildServer()) {
            ICompartmentNode compNode = ComponentUtil.getParentCompartmentNode(element);
            if (compNode == null) {
                return true;
            }
            if (compNode.getCompartment() != null && !compNode.getCompartment().isLocal()) {
                return true;
            }
        }
        return false;
    }

    public boolean isEnabled(Element element) {
        return true;
    }

    public void run(Element element) {
        final ICompartmentNode compNode = ComponentUtil.getParentCompartmentNode(element);
        final IDevelopmentConfiguration config = ComponentUtil.getParentDevConf(element);
        if (!Util.saveSensitiveEditors(config)) {
            return;
        }
        final ArrayList exceptions = new ArrayList();
        if (compNode != null) {
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                public void run() {
                    SCResyncArchivesAction.this.resyncCompartmentArchives(compNode, config, exceptions);
                }
            });
        } else if (config != null) {
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                public void run() {
                    List list = config.getCompartmentNodes();
                    Iterator it = list.iterator();
                    while (it.hasNext()) {
                        ICompartmentNode compartmentNode = (ICompartmentNode)it.next();
                        if (compartmentNode == null || compartmentNode.getCompartment() == null || compartmentNode.getCompartment().isLocal()) continue;
                        SCResyncArchivesAction.this.resyncCompartmentArchives(compartmentNode, config, exceptions);
                    }
                }
            });
        }
        if (!exceptions.isEmpty()) {
            Util.showException((Throwable)exceptions.get(0), "Error", exceptions.size() + " Error(s) occured.\n For more Details see Error Log.", null);
        }
    }

    private void resyncCompartmentArchives(ICompartmentNode compNode, IDevelopmentConfiguration config, List exceptions) {
        List dcArchives = null;
        String buildVariant = null;
        try {
            buildVariant = Util.getBuildVariant(config, compNode.getCompartment().getName());
        }
        catch (Exception e) {
            Util.logExceptionMessage(this.theTracer, 2, "missing Build Variant", e);
            exceptions.add(e);
            return;
        }
        try {
            dcArchives = compNode.listOutdatedSynchedArchives(buildVariant);
        }
        catch (SyncException e) {
            Util.logExceptionMessage(this.theTracer, 2, "List Outdated Synched Archives :" + compNode.getSCName(), e);
            exceptions.add(e);
        }
        if (dcArchives != null) {
            Iterator it = dcArchives.iterator();
            while (it.hasNext()) {
                IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)it.next();
                IDCProxy dcProxy = null;
                try {
                    dcProxy = dcNode.getDCProxy();
                }
                catch (DevConfigException e1) {
                    Util.logExceptionMessage(this.theTracer, 2, "Resync of " + dcNode.getName() + " failed", e1);
                    exceptions.add(e1);
                }
                if (dcProxy != null) {
                    try {
                        dcProxy.resync(false);
                    }
                    catch (SyncException e) {
                        Util.logExceptionMessage(this.theTracer, 2, "Resync of " + dcNode.getName() + " failed", e);
                        exceptions.add(e);
                    }
                    continue;
                }
                exceptions.add(new Exception(ComponentProviderMessages.format("dcProxyIsNull.ActionFailed.error", new String[]{dcNode.getName()})));
            }
        }
    }
}

