/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider.actions;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.devconf.DevConfManager;
import com.sap.ide.eclipse.component.devconf.DevConfValidator;
import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.eclipse.component.provider.ComponentMetaDataUtil;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.ide.login.UserValidator;
import com.sap.tc.devconf.DevelopmentConfigurationFactory;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.SyncException;
import com.tssap.dtr.client.lib.vfs.VfsExceptionCategory;
import com.tssap.dtr.client.lib.vfs.VfsRuntimeException;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.util.action.ICategory;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.File;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class DevConfRemoveAction
implements IElementSingleAction {
    private TracerI theTracer = TracingManager.getTracer(this.getClass());

    public ICategory getCategory() {
        return ComponentCategoryImage.CATEGORY__DEVCONF_REMOVE;
    }

    public boolean isAvailable(Element element) {
        String subDomain = element.getUniqueName().getSubDomain();
        return subDomain == "com.sap.ide.eclipse.component.model" || subDomain == "com.sap.ide.eclipse.component.local.model";
    }

    public boolean isEnabled(Element element) {
        return true;
    }

    public void run(Element element) {
        Model remainConfigModel;
        MessageDialog dialog;
        Object object = ObjectUtil.getComponentObject(element);
        IDevelopmentConfiguration configuration = null;
        if (object instanceof IDevelopmentConfiguration) {
            configuration = (IDevelopmentConfiguration)object;
        }
        if (configuration == null) {
            return;
        }
        String rootFolder = configuration.getConfigurationRootFolder();
        UniqueName remainConfigName = null;
        String devConfigName = element.getUniqueName().getName();
        String domain = element.getUniqueName().getDomain();
        if (domain == "com.sap.ide.eclipse.component") {
            String subDomain = element.getUniqueName().getSubDomain();
            if (subDomain.equals("com.sap.ide.eclipse.component.model")) {
                remainConfigName = ComponentMetaDataUtil.createDevConfLocalName(configuration);
            } else if (subDomain.equals("com.sap.ide.eclipse.component.local.model")) {
                remainConfigName = ComponentMetaDataUtil.createDevConfName(configuration);
            }
        }
        String title = "Confirm Delete";
        String label = "Are you sure you want to delete '" + devConfigName + "'?" + "\nAll local resources and local DCs will be irrepealable deleted.";
        MessageDialog warnDialog = new MessageDialog(JavaPlugin.getActiveWorkbenchShell(), title, null, label, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        if (warnDialog.open() != 0) {
            return;
        }
        UserValidator.Data data = null;
        if (!configuration.isLocalConfiguration()) {
            data = UserValidator.getDefaultServerData((int)UserValidator.LAZY_LOGIN, (Shell)ComponentProviderPlugin.getPlugin().getMyShell());
        }
        boolean tryImergencyDelete = true;
        boolean success = false;
        boolean areProjektsDeleted = false;
        if (configuration.isLocalConfiguration() || data != null && data.isOnline()) {
            String user = data != null ? data.getUser() : null;
            String password = data != null ? data.getPassword() : null;
            DCProjectUtil.removeDevConfProjects(configuration);
            areProjektsDeleted = true;
            try {
                DevelopmentConfigurationFactory.getInstance().removeConfiguration(configuration.getConfigurationRootFolder(), user, password);
                tryImergencyDelete = false;
                success = true;
            }
            catch (SyncException e) {
                boolean bl = tryImergencyDelete = Util.showException(e, null) != 1;
                if (7 == e.getErrorCode()) {
                    return;
                }
                Util.logExceptionMessage(this.theTracer, 2, devConfigName + ":Remove Configuration Action failed", e);
            }
            catch (VfsRuntimeException e) {
                boolean isNotCanceled = Util.showException(e, null) != 1;
                tryImergencyDelete = VfsExceptionCategory.CANT_DELETE_MOUNTPOINT_IF_THERE_ARE_STILL_FILES_SYNCED.equals(e.getCategory()) ? isNotCanceled : false;
                Util.logExceptionMessage(this.theTracer, 2, devConfigName + ":Remove Configuration Action failed", e);
            }
            catch (Throwable e) {
                Util.logExceptionMessage(this.theTracer, 2, devConfigName + ":Remove Configuration Action failed", e);
                Util.showException(e, null);
                return;
            }
        }
        if (tryImergencyDelete && (dialog = new MessageDialog(ComponentProviderPlugin.getPlugin().getMyShell(), "Warning", null, " CAUTION\n\nThis is an emergency operation which should only be used if the normal procedure cannot be followed.\n(Example: DTR Server or user account no longer existing).\n\nIf possible, you should always prefer the normal \"Remove Configuration\" action which is available in online mode.\n\nThis action will delete the  meta data  of Development Configuration \"" + devConfigName + "\" and the " + "associated DTR client definition unconditionally \n" + "+ No check for changed files or open DTR activities is performed.\n" + "+ Any open changes that are not checked-in into DTR are lost.\n" + "+ You may also have problems to re-connect with a new configuration if activities are still open.\n\n" + "Do you really want to remove the Configuration ?", 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 1)).open() == 0) {
            if (!areProjektsDeleted) {
                DCProjectUtil.removeDevConfProjects(configuration);
            }
            try {
                DevelopmentConfigurationFactory.getInstance().removeConfigurationByForce(rootFolder, true);
                success = true;
            }
            catch (Throwable e) {
                Util.logExceptionMessage(this.theTracer, 2, devConfigName + ": remove Configuration By Force failed", e);
                Util.showException(e, null);
                return;
            }
        }
        if (!success) {
            return;
        }
        if (rootFolder != null) {
            File file;
            File tempFile = new File(rootFolder + "buildvariant.config");
            if (tempFile.exists()) {
                tempFile.delete();
            }
            if ((file = new File(rootFolder)) != null && file.exists() && !file.delete() && MessageDialog.openConfirm((Shell)ComponentProviderPlugin.getPlugin().getMyShell(), (String)"Warning", (String)"Root Folder of the Development Configuration is still existing.\nRemove the Folder?") && !DevConfRemoveAction.emptyContents(file)) {
                MessageDialog.openWarning((Shell)ComponentProviderPlugin.getPlugin().getMyShell(), (String)"Warning", (String)"Removing of Root Folder failed.");
            }
        }
        if (element instanceof Model) {
            ((Model)element).delete();
        }
        if ((remainConfigModel = ModelAccess.getModel((UniqueName)remainConfigName)) != null) {
            remainConfigModel.delete();
        }
        DevConfValidator.update();
    }

    public static boolean emptyContents(File cmf_dir) {
        File[] cmf_contents = cmf_dir.listFiles();
        boolean deleteFailed = false;
        int i = 0;
        while (i < cmf_contents.length) {
            if (cmf_contents[i].exists()) {
                boolean delval = true;
                delval = cmf_contents[i].isDirectory() ? DevConfRemoveAction.emptyContents(cmf_contents[i]) : cmf_contents[i].delete();
                if (!delval) {
                    deleteFailed = true;
                }
            }
            ++i;
        }
        if (deleteFailed) {
            DevConfManager.addAtStartDeleteFolder(cmf_dir.getAbsolutePath());
            return false;
        }
        return cmf_dir.delete();
    }
}

