/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.ComponentDeltaTreeProvider;
import com.sap.ide.eclipse.component.provider.ComponentMetaDataUtil;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.ide.eclipse.component.provider.objects.PackageObject;
import com.sap.ide.eclipse.dii.component.ComponentUtil;
import com.sap.ide.eclipse.dii.namereservation.NameServerManager;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.ICompartmentNode;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.ISoftwareComponentNode;
import com.sap.tc.devconf.SyncException;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IPackageFragment;

public class UpdateUtil {
    private static TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$provider$UpdateUtil == null ? (class$com$sap$ide$eclipse$component$provider$UpdateUtil = UpdateUtil.class$("com.sap.ide.eclipse.component.provider.UpdateUtil")) : class$com$sap$ide$eclipse$component$provider$UpdateUtil));
    private static boolean refreshMode = false;
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$provider$UpdateUtil;

    public static void updateDC(IDevelopmentComponentNode dcNode, ModelDeltaNodeKind kind) {
        if (dcNode == null) {
            return;
        }
        UniqueName uin = ComponentMetaDataUtil.createDCName(dcNode, "active");
        uin = UpdateUtil.setParameter(uin, "active");
        ComponentDeltaTreeProvider.addDelta(uin, kind);
        uin = UpdateUtil.setParameter(uin, "inactive");
        ComponentDeltaTreeProvider.addDelta(uin, kind);
    }

    public static void updateFolderItem(IVfsFolderItem folderItem, ModelDeltaNodeKind kind) {
        if (!folderItem.isReleased()) {
            UniqueName uin = ComponentMetaDataUtil.createVfsFolderItemName(folderItem, "active");
            ComponentDeltaTreeProvider.addDelta(uin, kind);
            uin = ComponentMetaDataUtil.createVfsFolderItemName(folderItem, "inactive");
            ComponentDeltaTreeProvider.addDelta(uin, kind);
        }
    }

    public static void updateElement(Element element, ModelDeltaNodeKind kind) {
        UpdateUtil.updateElement(element.getUniqueName(), kind);
    }

    public static boolean isRefreshMode() {
        return refreshMode;
    }

    public static void setRefreshMode() {
        refreshMode = true;
    }

    public static void resetRefreshMode() {
        refreshMode = false;
    }

    public static void refreshElement(Element element) {
        block25: {
            if (!UpdateUtil.isRefreshMode()) {
                return;
            }
            UniqueName uin = element.getUniqueName();
            String sd = uin.getSubDomain();
            Object obj = ObjectUtil.getComponentObject(element);
            if (obj instanceof IDevelopmentConfiguration) {
                IDevelopmentConfiguration devConf = (IDevelopmentConfiguration)obj;
                if (devConf.isLocalConfiguration()) {
                    try {
                        devConf.refreshLocalDCsList();
                    }
                    catch (DevConfigException e) {
                        Util.logExceptionMessage(theTracer, 2, "Refresh Local DCs List failed", e);
                        Util.showException(e, null);
                    }
                }
            } else if (obj instanceof ICompartmentNode) {
                try {
                    ISoftwareComponentNode inactiveSc;
                    ICompartmentNode compNode = (ICompartmentNode)obj;
                    if (compNode.getConfiguration().isInOfflineMode()) break block25;
                    compNode.refreshArchiveSyncState(ComponentUtil.getBuildVariant((Element)element));
                    ISoftwareComponentNode activeSc = compNode.getActiveSCNode();
                    if (activeSc != null) {
                        activeSc.refresh();
                    }
                    if ((inactiveSc = compNode.getInactiveSCNode()) != null) {
                        inactiveSc.refresh();
                    }
                }
                catch (SyncException e) {
                    Util.logExceptionMessage(theTracer, 2, "Refresh of Archive Sync State failed", e);
                    Util.showException(e, null);
                }
            } else if (obj instanceof ISoftwareComponentNode) {
                ((ISoftwareComponentNode)obj).refresh();
            } else if (obj instanceof IDevelopmentComponentNode) {
                ((IDevelopmentComponentNode)obj).refresh();
            } else if (obj instanceof IVfsFolder) {
                try {
                    ((IVfsFolder)obj).refreshFolderItems();
                }
                catch (VfsException e) {
                    Util.logExceptionMessage(theTracer, 2, "Refresh of Folder Items failed", e);
                    Util.showException(e, null);
                }
                ((IVfsFolder)obj).refreshState();
            } else if (obj instanceof IVfsFile) {
                ((IVfsFile)obj).refreshState();
            } else if (sd.equals("com.sap.ide.eclipse.component.DCMetaData.PackageFolder")) {
                NameServerManager.refreshProjectPackageNR((IProject)DCProjectUtil.getParentProject(element));
            } else if (obj instanceof PackageObject) {
                PackageObject packObj = (PackageObject)obj;
                NameServerManager.refreshPackage((IPackageFragment)packObj.getFragment());
            }
        }
    }

    public static void specialFileCheck(IResource resource, int kind) {
        if ((kind == 1 || kind == 2 || kind == 4) && resource.getType() == 1) {
            IContainer parent = resource.getParent();
            if (resource.getName().equals(".dcdef")) {
                UpdateUtil.projectDCUpdateCheck((IResource)parent);
            } else if (parent instanceof IFolder && parent.getName().equals("def")) {
                parent = parent.getParent();
                UpdateUtil.projectDCUpdateCheck((IResource)parent);
            }
        }
    }

    private static void projectDCUpdateCheck(IResource resource) {
        if (resource instanceof IProject) {
            IDevelopmentComponentNode dcNode = ComponentUtil.getDCNode((IProject)((IProject)resource));
            UpdateUtil.updateDC(dcNode, ModelDeltaNodeKind.TOTALLY_CHANGED);
        }
    }

    private static void updateElement(UniqueName uin, ModelDeltaNodeKind kind) {
        if (uin.getParametersCount() > 0) {
            String param = uin.getParameter(0);
            if (param.equals("active") || param.equals("inactive")) {
                uin = UpdateUtil.setParameter(uin, "active");
                ComponentDeltaTreeProvider.addDelta(uin, kind);
                uin = UpdateUtil.setParameter(uin, "inactive");
                ComponentDeltaTreeProvider.addDelta(uin, kind);
            }
        } else {
            ComponentDeltaTreeProvider.addDelta(uin, kind);
        }
    }

    private static UniqueName setParameter(UniqueName uin, String state) {
        int pc = uin.getParametersCount();
        String[] param = new String[pc];
        param[0] = state;
        int i = 1;
        while (i < pc) {
            param[i] = uin.getParameter(i);
            ++i;
        }
        UniqueName newUin = ModelAccess.createUniqueName((String)uin.getDomain(), (String)uin.getSubDomain(), (String)uin.getLocation(), (String)uin.getName(), (String[])param);
        return newUin;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

