/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider;

import com.sap.ide.eclipse.component.provider.AbstractComponentProvider;
import com.sap.ide.eclipse.component.provider.ComponentMetaDataUtil;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.component.provider.UpdateUtil;
import com.sap.ide.eclipse.component.wizard.java.Util;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.filefolder.FileAndFolderManagement;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public final class PackagesProxyProvider
extends AbstractComponentProvider
implements ChildrenProvider {
    private TracerI theTracer = TracingManager.getTracer(this.getClass());

    public boolean isChildrenProviderApplicable(Entity parent) {
        return true;
    }

    public UniqueNameEnumeration children(Entity parent) {
        IResource res;
        UpdateUtil.refreshElement((Element)parent);
        if (!"com.sap.ide.eclipse.component.DCMetaData.PackageFolder".equals(parent.getUniqueName().getSubDomain())) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        ArrayList<UniqueName> childrenList = new ArrayList<UniqueName>();
        IProject project = DCProjectUtil.getParentProject((Element)parent);
        if (project == null && (res = FileAndFolderManagement.getInstance().getResource((Element)parent.getModel())) instanceof IProject) {
            project = (IProject)res;
        }
        if (project == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            IPackageFragment[] fragments = null;
            try {
                fragments = javaProject.getPackageFragments();
            }
            catch (JavaModelException e) {
                com.sap.ide.eclipse.component.core.Util.logExceptionMessage(this.theTracer, 3, "Get Packages failed", e);
            }
            if (fragments != null) {
                int i = 0;
                while (i < fragments.length) {
                    IPackageFragment fragment = fragments[i];
                    try {
                        if (1 == fragment.getKind() && (fragment.hasChildren() || !fragment.hasSubpackages()) && !"".equals(fragment.getElementName()) && Util.isInPackageFolder((IJavaElement)fragment)) {
                            childrenList.add(ComponentMetaDataUtil.createPackage(fragment, parent));
                        }
                    }
                    catch (JavaModelException e) {
                        com.sap.ide.eclipse.component.core.Util.logExceptionMessage(this.theTracer, 3, "Get Packages failed", e);
                    }
                    ++i;
                }
            }
        }
        return EnumerationConverter.toUniqueNameEnumeration(childrenList.iterator());
    }

    public static UniqueName getEjb(Model ejbModel, UniqueName ejbUin, UniqueName ejbJarUin, String ejbName) {
        return ProxyMetaInfo.getProxyUniqueName((UniqueName)ejbJarUin, (UniqueName)ejbModel.getUniqueName(), (UniqueName)ejbUin, (String[])new String[]{ejbName});
    }
}

