/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider;

import com.sap.ide.eclipse.component.core.DCProject;
import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.component.provider.objects.PackageObject;
import com.sap.ide.eclipse.component.provider.ui.message.ComponentProviderMessages;
import com.sap.ide.eclipse.dii.component.PackageUtil;
import com.sap.ide.eclipse.dii.namereservation.NameServerUtil;
import com.sap.ide.login.UserValidator;
import com.sap.lcr.namealloc.NameAllocator;
import com.sap.lcr.namealloc.api.AllocationState;
import com.sap.lcr.namealloc.api.CommunicationFailureException;
import com.sap.lcr.namealloc.api.NameSyntaxViolation;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.net.MalformedURLException;
import javax.naming.CompoundName;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IPackageFragment;

public class NamereservationUtil {
    private static TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$provider$NamereservationUtil == null ? (class$com$sap$ide$eclipse$component$provider$NamereservationUtil = NamereservationUtil.class$("com.sap.ide.eclipse.component.provider.NamereservationUtil")) : class$com$sap$ide$eclipse$component$provider$NamereservationUtil));
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$provider$NamereservationUtil;

    public static boolean isDcDtrReserved(IVfsFolder folder) {
        IVfsFolderItem[] children = null;
        try {
            children = folder.getFolderItems();
        }
        catch (VfsException e) {
            Util.logExceptionMessage(theTracer, 3, "get Folder Items failed", e);
        }
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                if (".dcdef".equals(children[i].getName().toLowerCase())) {
                    return NameServerUtil.isNamereservationSetted((IVfsFile)children[i].asFile());
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isDCReserved(Object name, NameAllocator allocator) throws CommunicationFailureException {
        if (allocator == null) {
            return false;
        }
        String myName = NamereservationUtil.getComponentName(name);
        if (myName == null) {
            return false;
        }
        return NameServerUtil.isDCReserved((String)myName, (NameAllocator)allocator);
    }

    public static boolean reserveDCinDTR(IVfsFile dcdefFile, String generatedName, AllocationState state, NameAllocator allocator, IVfsActivity activity) throws Throwable {
        String server = NameServerUtil.getURL((NameAllocator)allocator);
        return NameServerUtil.reserveInDTR((IVfsFile)dcdefFile, (String)"SAP_DevelopmentComponentName", (String)generatedName, (String)state.getReservationKey(), (String)server, (IVfsActivity)activity, null);
    }

    public static AllocationState reserveDC(Object name, NameAllocator allocator) throws Throwable {
        if (allocator == null) {
            return null;
        }
        String myName = NamereservationUtil.getComponentName(name);
        if (myName == null) {
            return null;
        }
        if (NameServerUtil.isDCReserved((String)myName, (NameAllocator)allocator)) {
            throw new Exception(ComponentProviderMessages.format("AllreadyReserved.error", new String[]{myName}));
        }
        try {
            return NameServerUtil.reserveDC((String)myName, (NameAllocator)allocator);
        }
        catch (NameSyntaxViolation e) {
            String prefixes = NameServerUtil.PrefixesToString((CompoundName[])NamereservationUtil.getAllowedDCPrefixes(allocator));
            String message = e.getMessage();
            if (message == null) {
                message = ComponentProviderMessages.getString("NameSyntaxViolationDC.error");
            }
            if (prefixes != null) {
                message = message + ComponentProviderMessages.format("NameSyntaxViolationDC.error", new String[]{myName, prefixes});
                throw new Exception(message);
            }
            throw e;
        }
    }

    public static boolean revertDCReservation(Object name, NameAllocator allocator) throws Throwable {
        if (allocator == null) {
            return false;
        }
        String myName = NamereservationUtil.getComponentName(name);
        if (myName == null) {
            return false;
        }
        NameServerUtil.revertDCReservation((String)myName, (NameAllocator)allocator);
        return true;
    }

    private static String getComponentName(Object name) {
        String myName = null;
        myName = name instanceof String ? (String)name : (name instanceof IDevelopmentComponentNode ? NamereservationUtil.getDCReservationName((IDevelopmentComponentNode)name) : (name instanceof DevelopmentComponent ? NamereservationUtil.getDCReservationName((DevelopmentComponent)name) : null));
        return myName;
    }

    public static String getDCReservationName(IDevelopmentComponentNode dcNode) {
        return NameServerUtil.getDCReservationName((String)dcNode.getVendor(), (String)dcNode.getName());
    }

    public static String getDCReservationName(DevelopmentComponent dc) {
        return NameServerUtil.getDCReservationName((String)dc.getVendor(), (String)dc.getName());
    }

    public static CompoundName[] getAllowedDCPrefixes(NameAllocator allocator) {
        if (allocator == null) {
            return null;
        }
        try {
            return allocator.getAllowedPrefixList("SAP_DevelopmentComponentName");
        }
        catch (CommunicationFailureException e) {
            Util.logExceptionMessage(theTracer, 3, "get Prefixes failed", e);
            return null;
        }
    }

    public static String getPackageNRState(PackageObject pack) {
        if (!UserValidator.isDefaultServerOnline()) {
            return "local";
        }
        IPackageFragment resource = pack.getFragment();
        if (pack.getState() != null && pack.getState().isReserved()) {
            String caption;
            IVfsFile file = null;
            try {
                file = PackageUtil.getVFSPackageFile((IPackageFragment)resource);
            }
            catch (VfsException e1) {
                Util.logExceptionMessage(theTracer, 3, "Get Package status failed", e1);
                return "Getting Status failed";
            }
            if (file != null && (!VfsFolderItemLocationState.LOCAL_ONLY.equals(file.getLocationState()) || VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE.equals(file.getActivityState()))) {
                return "Name is reserved";
            }
            String dcName = null;
            if (resource != null) {
                DCProject dcPrj = DCProjectUtil.getDCProject(resource.getJavaProject().getProject());
                IDevelopmentComponentNode dcNode = dcPrj.getDCNode();
                dcName = dcNode.getVendor() + "/" + dcNode.getName();
            }
            if ("PACKAGE RESERVATION".equals(caption = pack.getState().getCaption())) {
                caption = null;
            }
            if (pack.getState().isReservedPreliminary()) {
                if (caption != null && caption.endsWith(dcName)) {
                    return "Package Name reverting is in progress.";
                }
                return "The Package is already reserved. You have to rename this package. " + (caption != null ? " (" + caption + ")" : "");
            }
            if (caption != null && caption.endsWith(dcName)) {
                return "Inconsistent state. File representing package is missing or defect.";
            }
            return "Name is finally reserved by other Package. You have to rename this package. " + (caption != null ? " (" + caption + ")" : "");
        }
        NameAllocator allocator = null;
        try {
            allocator = NameServerUtil.getNameAllocator((IProject)resource.getJavaProject().getProject());
        }
        catch (MalformedURLException e3) {
            Util.logExceptionMessage(theTracer, 3, "Get Nameallocator failed", e3);
        }
        catch (CommunicationFailureException e3) {
            Util.logExceptionMessage(theTracer, 3, "Get Nameallocator failed", e3);
        }
        if (allocator != null) {
            try {
                allocator.checkName("SAP_DesignTimePackage", resource.getElementName());
            }
            catch (CommunicationFailureException e1) {
                Util.logExceptionMessage(theTracer, 3, "Check Name failed", e1);
                return "Getting Status failed";
            }
            catch (NameSyntaxViolation e) {
                String prefixes = null;
                try {
                    prefixes = NameServerUtil.PrefixesToString((CompoundName[])allocator.getAllowedPrefixList("SAP_DesignTimePackage"));
                }
                catch (CommunicationFailureException e2) {
                    Util.logExceptionMessage(theTracer, 3, "get allowed prefixes failed", e2);
                }
                if (prefixes != null) {
                    return "Invalid Name: Packages should begin with " + prefixes;
                }
                return "Invalid Name";
            }
        }
        return "local";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

