/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.devconf.DevConfManager;
import com.sap.ide.eclipse.component.provider.preference.DevConfPreferencePage;
import com.sap.ide.login.IValidityCheckerWithProgress;
import com.sap.ide.login.UserValidator;
import com.sap.lcr.api.cimclient.CIMClient;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class LSDValidator
implements IValidityCheckerWithProgress {
    protected static LSDValidator defaultValidator;
    private TracerI theTracer = TracingManager.getTracer(this.getClass());

    public IStatus validate(UserValidator.Data data, IProgressMonitor monitor) {
        int severity = 0;
        CIMClient cimClient = null;
        try {
            cimClient = DevConfManager.getCIMClient(data.getUser(), data.getPassword(), UserValidator.getKeyStore());
        }
        catch (CIMClientException e) {
            Util.logExceptionMessage(this.theTracer, 3, "Get Landscape Directory Client failed", e);
        }
        String message = "";
        int code = -1;
        if (cimClient != null) {
            monitor.subTask("Landscape Directory :" + cimClient.getHost() + ":" + cimClient.getPort());
            try {
                cimClient.ping();
                code = 0;
            }
            catch (CIMClientException e) {
                severity = 2;
                message = "Landscape Directory " + cimClient.getHost() + ":" + cimClient.getPort() + " " + e.getMessage();
            }
        }
        monitor.subTask("");
        return new Status(severity, "com.sap.ide.component.provider", code, message, null);
    }

    public static LSDValidator getDefaultValidator() {
        if (defaultValidator == null) {
            defaultValidator = new LSDValidator();
        }
        return defaultValidator;
    }

    public boolean canValidate(IProgressMonitor monitor) {
        String url = DevConfPreferencePage.getDevConfPoolURL();
        return url != null && url.length() > 0;
    }
}

