/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.AbstractComponentProvider;
import com.sap.ide.eclipse.component.provider.ComponentMetaDataUtil;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.UpdateUtil;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.ide.login.UserValidator;
import com.sap.tc.devconf.ICompartmentNode;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.ISoftwareComponentNode;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Shell;

public class DCProvider
extends AbstractComponentProvider
implements ChildrenProvider {
    private TracerI theTracer = TracingManager.getTracer(this.getClass());

    public boolean isChildrenProviderApplicable(Entity parent) {
        return true;
    }

    public UniqueNameEnumeration children(Entity parent) {
        UpdateUtil.refreshElement((Element)parent);
        ArrayList<UniqueName> childrenList = new ArrayList<UniqueName>();
        List dcNodeList = null;
        ICompartmentNode compNode = null;
        String state = "";
        boolean local = false;
        Shell shell = ComponentProviderPlugin.getPlugin().getMyShell();
        shell.setCursor(new Cursor((Device)shell.getDisplay(), 1));
        Object object = ObjectUtil.getComponentObject((Element)parent);
        if (!(object instanceof ICompartmentNode)) {
            return null;
        }
        compNode = (ICompartmentNode)object;
        if (ComponentUtil.isLocal((Element)parent)) {
            local = true;
            IDevelopmentConfiguration config = ComponentUtil.getParentDevConf((Element)parent);
            dcNodeList = config.getDevelopmentComponentNodes();
        } else if (UserValidator.isDefaultServerOnline()) {
            ISoftwareComponentNode scNode;
            if (ComponentUtil.isActive((Element)parent)) {
                state = "active";
                scNode = compNode.getActiveSCNode();
            } else {
                state = "inactive";
                scNode = compNode.getInactiveSCNode();
            }
            try {
                if (scNode != null) {
                    dcNodeList = scNode.getChildren();
                }
            }
            catch (Exception RepositoryAccessException2) {
                Util.logExceptionMessage(this.theTracer, 3, "List DC Nodes failed", RepositoryAccessException2);
            }
        }
        if (dcNodeList != null) {
            int i = 0;
            while (i < dcNodeList.size()) {
                UniqueName dcNodeUName;
                IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)dcNodeList.get(i);
                if (local) {
                    String compNodeName = compNode.getCompartment().getName();
                    if (compNodeName.equals(dcNode.getCompartmentName())) {
                        state = ComponentUtil.getDCState(dcNode);
                        dcNodeUName = ComponentMetaDataUtil.createDC(parent, compNode, dcNode, state);
                        childrenList.add(dcNodeUName);
                    }
                } else {
                    dcNodeUName = ComponentMetaDataUtil.createDC(parent, compNode, dcNode, state);
                    childrenList.add(dcNodeUName);
                }
                ++i;
            }
        }
        shell.setCursor(null);
        return EnumerationConverter.toUniqueNameEnumeration(childrenList.iterator());
    }
}

